/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.item.GearSoulItem;
import net.silentchaos512.gems.lib.soul.GearSoul;
import net.silentchaos512.gems.lib.soul.GearSoulPart;
import net.silentchaos512.lib.util.PlayerUtils;

public final class SoulManager {
    private static final String NBT_SOUL = "SG_GearSoul";
    static final Map<UUID, GearSoul> SOULS = new HashMap<UUID, GearSoul>();

    private SoulManager() {
    }

    @Nullable
    public static GearSoul getSoul(ItemStack gearOrSoul) {
        if (!gearOrSoul.func_190926_b()) {
            if (GearHelper.isGear((ItemStack)gearOrSoul)) {
                return SoulManager.getSoulFromGear(gearOrSoul);
            }
            if (gearOrSoul.func_77973_b() instanceof GearSoulItem) {
                return SoulManager.getSoulFromItem(gearOrSoul);
            }
        }
        return null;
    }

    @Nullable
    private static GearSoul getSoulFromGear(ItemStack gear) {
        PartData part = GearData.getPartOfType((ItemStack)gear, (PartType)GearSoulPart.TYPE);
        if (part == null || !gear.func_77942_o() || !gear.func_196082_o().func_74764_b(NBT_SOUL)) {
            return null;
        }
        UUID uuid = GearData.getUUID((ItemStack)gear);
        GearSoul soul = SOULS.get(uuid);
        if (soul != null) {
            return soul;
        }
        GearSoul readSoul = SoulManager.getSoulFromItem(gear);
        SOULS.put(uuid, readSoul);
        return readSoul;
    }

    private static GearSoul getSoulFromItem(ItemStack soulItem) {
        CompoundNBT tags = soulItem.func_190925_c(NBT_SOUL);
        return GearSoul.read(tags);
    }

    @Nullable
    public static GearSoul getSoulByUuid(UUID uuid) {
        return SOULS.get(uuid);
    }

    public static void setSoul(ItemStack gear, GearSoul soul) {
        CompoundNBT tags = new CompoundNBT();
        soul.write(tags);
        gear.func_196082_o().func_218657_a(NBT_SOUL, (INBT)tags);
    }

    public static void addSoulXp(int amount, ItemStack tool, PlayerEntity player) {
        GearSoul soul = SoulManager.getSoul(tool);
        if (soul != null && amount > 0) {
            soul.addXp(amount, tool, player);
        }
    }

    static void queueSoulsForWrite(PlayerEntity player) {
        for (ItemStack tool : PlayerUtils.getNonEmptyStacks((PlayerEntity)player, (boolean)true, (boolean)true, (boolean)true, s -> s.func_77973_b() instanceof ICoreItem)) {
            GearSoul soul = SoulManager.getSoul(tool);
            if (soul == null) continue;
            soul.setReadyToSave(true);
        }
    }

    static void writeSoulsToNBT(PlayerEntity player, boolean forceAll) {
        int count = 0;
        for (ItemStack tool : PlayerUtils.getNonEmptyStacks((PlayerEntity)player, (boolean)true, (boolean)true, (boolean)true, s -> s.func_77973_b() instanceof ICoreItem)) {
            GearSoul soul = SoulManager.getSoul(tool);
            if (soul == null || !forceAll && !soul.isReadyToSave()) continue;
            SoulManager.setSoul(tool, soul);
            ++count;
        }
        SilentGems.LOGGER.debug("Saved {} gear souls for {}", (Object)count, (Object)player.func_195047_I_());
    }
}

