/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.silentchaos512.lib.util.DimPos;
import net.silentchaos512.lib.util.TeleporterSL;

public final class TeleportUtil {
    private TeleportUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean teleport(Entity entity, DimPos pos) {
        ServerWorld world = TeleportUtil.getServerWorld(entity, pos);
        if (world == null) {
            return false;
        }
        TeleporterSL teleporter = TeleporterSL.of((ServerWorld)world, (DimPos)pos.offset(Direction.UP, 1));
        teleporter.teleportWithMount(entity);
        return true;
    }

    public static boolean isDestinationSafe(Entity entity, DimPos destination) {
        ServerWorld world = TeleportUtil.getServerWorld(entity, destination);
        if (world == null) {
            return false;
        }
        BlockPos headLevel = destination.getPos().func_177981_b(Math.round(entity.func_70047_e()));
        return !world.func_180495_p(headLevel).func_215696_m((IBlockReader)world, destination.getPos());
    }

    @Nullable
    private static ServerWorld getServerWorld(Entity entity, DimPos pos) {
        MinecraftServer server = entity.func_184102_h();
        if (server == null) {
            return null;
        }
        DimensionType dimensionType = DimensionType.func_186069_a((int)pos.getDimension());
        if (dimensionType == null) {
            return null;
        }
        return server.func_71218_a(dimensionType);
    }
}

