/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.FluffyPuffPlant;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsEntities;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.world.feature.GemGeodeFeature;
import net.silentchaos512.gems.world.feature.GemGeodeFeatureConfig;
import net.silentchaos512.gems.world.feature.GlowroseFeature;
import net.silentchaos512.gems.world.feature.RegionalGemsFeature;
import net.silentchaos512.gems.world.feature.RegionalGemsFeatureConfig;
import net.silentchaos512.gems.world.feature.SGOreFeature;
import net.silentchaos512.gems.world.feature.SGOreFeatureConfig;
import net.silentchaos512.gems.world.placement.NetherFloorWithExtra;
import net.silentchaos512.gems.world.placement.NetherFloorWithExtraConfig;
import net.silentchaos512.lib.world.feature.PlantFeature;
import net.silentchaos512.utils.MathUtils;

public final class GemsWorldFeatures {
    private static final EnumMap<Gems, Set<ResourceLocation>> GEM_BIOMES = new EnumMap(Gems.class);

    private GemsWorldFeatures() {
    }

    public static void addFeaturesToBiomes() {
        int i;
        EnumSet<Gems> selected = EnumSet.noneOf(Gems.class);
        for (Biome biome : ForgeRegistries.BIOMES) {
            long seed = GemsWorldFeatures.getBiomeSeed(biome);
            Random random = new Random(seed);
            if (biome.func_201856_r() == Biome.Category.NETHER) {
                GemsWorldFeatures.addNetherFeatures(biome);
                continue;
            }
            if (biome.func_201856_r() == Biome.Category.THEEND) {
                GemsWorldFeatures.addTheEndFeatures(biome, random);
                continue;
            }
            EnumSet<Gems> toAdd = EnumSet.noneOf(Gems.class);
            for (i = 0; (long)toAdd.size() < Math.abs(seed % 3L) + 3L && i < 100; ++i) {
                toAdd.add(Gems.Set.CLASSIC.selectRandom(random));
            }
            for (Gems gem2 : toAdd) {
                GemsWorldFeatures.addGemOre(biome, gem2, random, DimensionType.field_223227_a_);
                selected.add(gem2);
            }
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new GlowroseFeature(toAdd), (IFeatureConfig)NoFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(2)));
            GemsWorldFeatures.addChaosOre(biome, random);
            GemsWorldFeatures.addSilverOre(biome, random);
            if (biome.func_76727_i() > 0.4f) {
                GemsWorldFeatures.addWildFluffyPuffs(biome);
            }
            for (Gems.Set gemSet : Gems.Set.values()) {
                GemsWorldFeatures.addGemGeode(biome, gemSet, random);
            }
            int regionSize = (Integer)GemsConfig.COMMON.worldGenOtherDimensionGemsRegionSize.get();
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)RegionalGemsFeature.INSTANCE, (IFeatureConfig)new RegionalGemsFeatureConfig(Gems.Set.CLASSIC, 8, regionSize, state -> state.func_203425_a(Tags.Blocks.STONE), d -> d.func_186068_a() != DimensionType.field_223227_a_.func_186068_a()), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 10, 0, 50)));
        }
        EnumSet<Gems> notSelected = EnumSet.complementOf(selected);
        notSelected.removeIf(gem -> gem.getSet() != Gems.Set.CLASSIC);
        if (!notSelected.isEmpty()) {
            SilentGems.LOGGER.debug("Some gems were not selected, adding to random biomes.");
            Random random = new Random(GemsWorldFeatures.getBaseSeed());
            Biome[] biomes = ForgeRegistries.BIOMES.getValues().toArray(new Biome[0]);
            for (Gems gem3 : notSelected) {
                int count = MathHelper.func_76136_a((Random)random, (int)2, (int)4);
                for (i = 0; i < count; ++i) {
                    int biomeIndex = random.nextInt(biomes.length);
                    Biome biome = biomes[biomeIndex];
                    if (biome.func_201856_r() == Biome.Category.NETHER || biome.func_201856_r() == Biome.Category.THEEND) continue;
                    GemsWorldFeatures.addGemOre(biome, gem3, random, DimensionType.field_223227_a_);
                }
            }
        }
        GemsWorldFeatures.logGemBiomes();
    }

    private static void addNetherFeatures(Biome biome) {
        int regionSize = (Integer)GemsConfig.COMMON.worldGenNetherGemsRegionSize.get();
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)RegionalGemsFeature.INSTANCE, (IFeatureConfig)new RegionalGemsFeatureConfig(Gems.Set.DARK, 10, regionSize, state -> state.func_177230_c() == Blocks.field_150424_aL, DimensionType.field_223228_b_), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(12, 25, 0, 95)));
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new GlowroseFeature(Gems.Set.DARK), (IFeatureConfig)NoFeatureConfig.field_202429_e, (Placement)NetherFloorWithExtra.INSTANCE, (IPlacementConfig)new NetherFloorWithExtraConfig(0, 0.25f, 1, 32, 96)));
    }

    private static void addTheEndFeatures(Biome biome, Random random) {
        int regionSize = (Integer)GemsConfig.COMMON.worldGenEndGemsRegionSize.get();
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)RegionalGemsFeature.INSTANCE, (IFeatureConfig)new RegionalGemsFeatureConfig(Gems.Set.LIGHT, 10, regionSize, state -> state.func_177230_c() == Blocks.field_150377_bs, DimensionType.field_223229_c_), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(12, 16, 0, 72)));
        GemsWorldFeatures.addEnderOre(biome, random);
        GemsWorldFeatures.addEnderSlimeSpawns(biome);
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new GlowroseFeature(Gems.Set.LIGHT), (IFeatureConfig)NoFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    private static void logGemBiomes() {
        SilentGems.LOGGER.info("Your base biome seed is {}", (Object)GemsWorldFeatures.getBaseSeed());
        for (Gems gem : Gems.values()) {
            Set<ResourceLocation> biomes = GEM_BIOMES.get((Object)gem);
            if (biomes == null) continue;
            String biomeList = biomes.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            SilentGems.LOGGER.info("{}: {}", (Object)gem, (Object)biomeList);
        }
    }

    private static void addChaosOre(Biome biome, Random random) {
        int count = MathUtils.nextIntInclusive((Random)random, (int)1, (int)2);
        int size = MathUtils.nextIntInclusive((Random)random, (int)12, (int)18);
        int maxHeight = MathUtils.nextIntInclusive((Random)random, (int)15, (int)25);
        GemsWorldFeatures.addOre(biome, MiscOres.CHAOS.asBlock(), size, count, 5, maxHeight, d -> true);
    }

    private static void addEnderOre(Biome biome, Random random) {
        GemsWorldFeatures.addOre(biome, MiscOres.ENDER.asBlock(), 32, 1, 10, 70, state -> state.func_177230_c() == Blocks.field_150377_bs, d -> true);
    }

    private static void addSilverOre(Biome biome, Random random) {
        GemsWorldFeatures.addOre(biome, MiscOres.SILVER.asBlock(), 6, 2, 6, 28, d -> true);
    }

    private static void addGemOre(Biome biome, Gems gem, Random random, DimensionType dimension) {
        int size = MathHelper.func_76136_a((Random)random, (int)6, (int)8);
        int count = MathHelper.func_76136_a((Random)random, (int)2, (int)4);
        int minHeight = random.nextInt(8);
        int maxHeight = random.nextInt(40) + 30;
        GemsWorldFeatures.addOre(biome, (Block)gem.getOre(), size, count, minHeight, maxHeight, d -> d.func_186068_a() == dimension.func_186068_a());
        GEM_BIOMES.computeIfAbsent(gem, g -> new HashSet()).add(biome.getRegistryName());
    }

    private static void addOre(Biome biome, Block block, int size, int count, int minHeight, int maxHeight, Predicate<DimensionType> dimension) {
        GemsWorldFeatures.addOre(biome, block, size, count, minHeight, maxHeight, s -> s.func_203425_a(Tags.Blocks.STONE), dimension);
    }

    private static void addOre(Biome biome, Block block, int size, int count, int minHeight, int maxHeight, Predicate<BlockState> blockToReplace, Predicate<DimensionType> dimension) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)SGOreFeature.INSTANCE, (IFeatureConfig)new SGOreFeatureConfig(block.func_176223_P(), size, blockToReplace, dimension), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(count, minHeight, 0, maxHeight)));
    }

    private static void addGemGeode(Biome biome, Gems.Set gemSet, Random random) {
        float chance = 0.05f + 0.0025f * (float)random.nextGaussian();
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)GemGeodeFeature.INSTANCE, (IFeatureConfig)new GemGeodeFeatureConfig(gemSet, gemSet.getGeodeShell().asBlockState(), s -> s.func_203425_a(Tags.Blocks.STONE)), (Placement)Placement.field_215032_r, (IPlacementConfig)new ChanceRangeConfig(chance, 20, 0, 40)));
    }

    private static void addWildFluffyPuffs(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new PlantFeature(((FluffyPuffPlant)((Object)FluffyPuffPlant.WILD.get())).getMaturePlant(), 32, 6), (IFeatureConfig)NoFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    private static void addEnderSlimeSpawns(Biome biome) {
        EntityType<?> type = GemsEntities.ENDER_SLIME.type();
        biome.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(type, ((Integer)GemsConfig.COMMON.enderSlimeSpawnWeight.get()).intValue(), ((Integer)GemsConfig.COMMON.enderSlimeGroupSizeMin.get()).intValue(), ((Integer)GemsConfig.COMMON.enderSlimeGroupSizeMax.get()).intValue()));
    }

    private static long getBaseSeed() {
        String overrideValue = (String)GemsConfig.COMMON.baseBiomeSeedOverride.get();
        if (!overrideValue.isEmpty()) {
            return overrideValue.hashCode();
        }
        String username = System.getProperty("user.name");
        if (username == null || username.isEmpty()) {
            return ModList.get().size() * 10000;
        }
        return username.hashCode();
    }

    private static long getBiomeSeed(Biome biome) {
        return GemsWorldFeatures.getBaseSeed() + (long)Objects.requireNonNull(biome.getRegistryName()).toString().hashCode() + (long)(biome.func_201856_r().ordinal() * 100) + (long)(biome.func_201851_b().ordinal() * 10) + (long)biome.func_150561_m().ordinal();
    }
}

