/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.world.feature.GemGeodeFeatureConfig;

public class GemGeodeFeature
extends Feature<GemGeodeFeatureConfig> {
    public static final GemGeodeFeature INSTANCE = new GemGeodeFeature(GemGeodeFeatureConfig::deserialize);

    public GemGeodeFeature(Function<Dynamic<?>, ? extends GemGeodeFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, GemGeodeFeatureConfig config) {
        if (config.target.test(worldIn.func_180495_p(pos))) {
            float diameterXZ = 2.0f * random.nextFloat() + 5.0f;
            float diameterY = 3.0f * random.nextFloat() + 7.0f;
            this.generateShell(worldIn, random, pos, diameterXZ, diameterY, config);
            this.generateGems(worldIn, random, pos, diameterXZ, diameterY, config);
            return true;
        }
        return false;
    }

    private void generateShell(IWorld worldIn, Random rand, BlockPos position, float diameterXZ, float diameterY, GemGeodeFeatureConfig config) {
        int xMin = (int)((float)position.func_177958_n() - diameterXZ / 2.0f);
        int xMax = (int)((float)position.func_177958_n() + diameterXZ / 2.0f);
        int yMin = (int)((float)position.func_177956_o() - diameterY / 2.0f);
        int yMax = (int)((float)position.func_177956_o() + diameterY / 2.0f);
        int zMin = (int)((float)position.func_177952_p() - diameterXZ / 2.0f);
        int zMax = (int)((float)position.func_177952_p() + diameterXZ / 2.0f);
        for (int x = xMin; x <= xMax; ++x) {
            float dx = x - position.func_177958_n();
            for (int y = yMin; y <= yMax; ++y) {
                float dy = y - position.func_177956_o();
                for (int z = zMin; z <= zMax; ++z) {
                    float dz = z - position.func_177952_p();
                    if (!(dx * dx / (diameterXZ * diameterXZ) + dy * dy / (diameterY * diameterY) + dz * dz / (diameterXZ * diameterXZ) <= 0.25f)) continue;
                    BlockPos blockpos = new BlockPos(x, y, z);
                    BlockState state = worldIn.func_180495_p(blockpos);
                    if (!config.target.test(state)) {
                        config.getClass();
                        if (!state.isAir((IBlockReader)worldIn, blockpos)) continue;
                    }
                    worldIn.func_180501_a(blockpos, config.shellBlock, 2);
                }
            }
        }
    }

    private void generateGems(IWorld worldIn, Random rand, BlockPos position, float diameterXZ, float diameterY, GemGeodeFeatureConfig config) {
        int xmin = (int)((float)position.func_177958_n() - (diameterXZ *= 0.6f) / 2.0f);
        int xmax = (int)((float)position.func_177958_n() + diameterXZ / 2.0f);
        int ymin = (int)((float)position.func_177956_o() - (diameterY *= 0.6f) / 2.0f);
        int ymax = (int)((float)position.func_177956_o() + diameterY / 2.0f);
        int zmin = (int)((float)position.func_177952_p() - diameterXZ / 2.0f);
        int zmax = (int)((float)position.func_177952_p() + diameterXZ / 2.0f);
        int count = 0;
        for (int x = xmin; x <= xmax; ++x) {
            float dx = x - position.func_177958_n();
            for (int y = ymin; y <= ymax; ++y) {
                float dy = y - position.func_177956_o();
                for (int z = zmin; z <= zmax; ++z) {
                    float dz = z - position.func_177952_p();
                    count = this.tryPlaceGem(worldIn, rand, position, diameterXZ, diameterY, config, count, x, dx, y, dy, z, dz);
                }
            }
        }
    }

    private int tryPlaceGem(IWorld worldIn, Random rand, BlockPos position, float diameterXZ, float diameterY, GemGeodeFeatureConfig config, int count, int x, float dx, int y, float dy, int z, float dz) {
        if (dx * dx / (diameterXZ * diameterXZ) + dy * dy / (diameterY * diameterY) + dz * dz / (diameterXZ * diameterXZ) <= 0.25f && rand.nextFloat() <= config.gemDensity) {
            ++count;
            BlockPos blockpos = new BlockPos(x, y, z);
            BlockState state = worldIn.func_180495_p(blockpos);
            if (state == config.shellBlock) {
                Gems gem = config.gemSet.selectRandom(rand);
                worldIn.func_180501_a(blockpos, gem.getOre().func_176223_P(), 2);
            }
        }
        return count;
    }
}

