/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.lib.Gems;

public class GlowroseFeature
extends FlowersFeature {
    private final List<Gems> gems = new ArrayList<Gems>();

    public GlowroseFeature(Collection<Gems> gems) {
        super(NoFeatureConfig::func_214639_a);
        this.gems.addAll(gems);
    }

    public GlowroseFeature(Gems.Set gemSet) {
        super(NoFeatureConfig::func_214639_a);
        gemSet.forEach(this.gems::add);
    }

    public boolean func_212245_a(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        BlockState flower = this.func_202355_a(random, pos);
        int numberPlaced = 0;
        int maxCount = (Integer)GemsConfig.COMMON.glowroseMaxPlaceCount.get();
        int tryCount = (Integer)GemsConfig.COMMON.glowroseSpawnTryCount.get();
        for (int j = 0; j < tryCount && numberPlaced < maxCount; ++j) {
            BlockPos pos1 = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(pos1) || pos1.func_177956_o() >= 255 || !flower.func_196955_c((IWorldReader)world, pos1)) continue;
            world.func_180501_a(pos1, flower, 2);
            ++numberPlaced;
        }
        return numberPlaced > 0;
    }

    public BlockState func_202355_a(Random random, BlockPos pos) {
        int index = random.nextInt(this.gems.size());
        Gems gem = this.gems.get(index);
        return gem.getGlowrose().func_176223_P();
    }
}

