/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.silentchaos512.gems.lib.Gems;

public class RegionalGemsFeatureConfig
implements IFeatureConfig {
    private final Gems.Set gemSet;
    public final int size;
    public final int regionSize;
    public final Predicate<BlockState> target;
    public final Predicate<DimensionType> dimension;

    public RegionalGemsFeatureConfig(Gems.Set gemSet, int size, int regionSize, Predicate<BlockState> target, DimensionType dimension) {
        this(gemSet, size, regionSize, target, (DimensionType d) -> d.func_186068_a() == dimension.func_186068_a());
    }

    public RegionalGemsFeatureConfig(Gems.Set gemSet, int size, int regionSize, Predicate<BlockState> target, Predicate<DimensionType> dimension) {
        this.gemSet = gemSet;
        this.size = size;
        this.regionSize = regionSize;
        this.target = target;
        this.dimension = dimension;
    }

    public Gems selectGem(IWorld world, BlockPos pos, Random random) {
        int regionX = pos.func_177958_n() / (16 * this.regionSize);
        int regionZ = pos.func_177952_p() / (16 * this.regionSize);
        long regionId = ((long)regionX << 32) + (long)regionZ;
        Random regionRand = new Random(regionId + world.func_72905_C());
        int gemCount = 2 + regionRand.nextInt(3);
        int index = random.nextInt(gemCount);
        Gems gem = this.gemSet.selectRandom(regionRand);
        for (int i = 0; i < index; ++i) {
            gem = this.gemSet.selectRandom(regionRand);
        }
        return gem;
    }

    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("gem_set"), (Object)ops.createString(this.gemSet.getName()), (Object)ops.createString("size"), (Object)ops.createInt(this.size), (Object)ops.createString("region_size"), (Object)ops.createInt(this.regionSize))));
    }

    public static RegionalGemsFeatureConfig deserialize(Dynamic<?> dynamic) {
        Gems.Set gemSet = Gems.Set.deserialize(dynamic);
        int size = dynamic.get("size").asInt(0);
        int regionSize = dynamic.get("region_size").asInt(0);
        int dimensionId = dynamic.get("dimension").asInt(0);
        return new RegionalGemsFeatureConfig(gemSet, size, regionSize, s -> s.func_177230_c() == Blocks.field_150348_b, d -> d.func_186068_a() == DimensionType.field_223227_a_.func_186068_a());
    }
}

