/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world.spawner;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.entity.AbstractWispEntity;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.utils.MathUtils;

public final class WispSpawner {
    private static final int MIN_GROUP_COUNT = 2;
    private static final int MAX_GROUP_COUNT = 4;

    private WispSpawner() {
    }

    public static boolean spawnWisps(Entity player, int chaos) {
        if (player.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        WispTypes type = WispTypes.selectRandom(SilentGems.random);
        int count = MathUtils.nextIntInclusive((Random)SilentGems.random, (int)2, (int)4);
        BlockPos pos = WispSpawner.getRandomHeight(player.field_70170_p, player.field_70170_p.func_217349_x(player.func_180425_c()));
        for (int i = 0; i < 4; ++i) {
            if (!WispSpawner.spawnWispGroup(type.getEntityType(), count, player.field_70170_p, player.func_180425_c())) continue;
            return true;
        }
        return false;
    }

    private static <T extends AbstractWispEntity> boolean spawnWispGroup(EntityType<T> type, int count, World world, BlockPos pos) {
        int areaX = pos.func_177958_n() + 16 * MathUtils.nextIntInclusive((int)-2, (int)2);
        int areaZ = pos.func_177952_p() + 16 * MathUtils.nextIntInclusive((int)-2, (int)2);
        if (areaX == pos.func_177958_n() || areaZ == pos.func_177952_p()) {
            areaX = pos.func_177958_n() + 24;
            areaZ = pos.func_177952_p() + 24;
        }
        int spawned = 0;
        for (int i = 0; i < count; ++i) {
            AbstractWispEntity wisp;
            int posX = areaX + MathUtils.nextIntInclusive((int)-8, (int)8);
            int posZ = areaZ + MathUtils.nextIntInclusive((int)-8, (int)8);
            int posY = world.func_212866_a_(posX, posZ).func_201576_a(Heightmap.Type.WORLD_SURFACE, posX, posZ) + 1;
            BlockPos blockPos = new BlockPos(posX, posY, posZ);
            SilentGems.LOGGER.debug("{}: {}", (Object)type.getRegistryName(), (Object)blockPos);
            DifficultyInstance difficultyInstance = world.func_175649_E(blockPos);
            if (!WispSpawner.canSpawnAt(world, blockPos) || (wisp = (AbstractWispEntity)type.func_200721_a(world)) == null) continue;
            wisp.func_174828_a(blockPos, 0.0f, 0.0f);
            wisp.func_213386_a((IWorld)world, difficultyInstance, SpawnReason.NATURAL, null, null);
            world.func_217376_c((Entity)wisp);
            ++spawned;
        }
        return spawned > 0;
    }

    private static boolean canSpawnAt(World world, BlockPos pos) {
        boolean isSpawnableSpace = WorldEntitySpawner.func_222266_a((IBlockReader)world, (BlockPos)pos, (BlockState)world.func_180495_p(pos), (IFluidState)world.func_204610_c(pos));
        return isSpawnableSpace && (world.func_175642_b(LightType.BLOCK, pos) < 9 || world.func_175710_j(pos));
    }

    private static BlockPos getRandomHeight(World worldIn, IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int x = chunkpos.func_180334_c() + worldIn.field_73012_v.nextInt(16);
        int z = chunkpos.func_180333_d() + worldIn.field_73012_v.nextInt(16);
        int top = chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE, x, z) + 1;
        int y = worldIn.field_73012_v.nextInt(top + 1);
        return new BlockPos(x, y, z);
    }
}

