/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.VLEleContainerFixed;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.ui.theme.client.ThemeRegistry;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;

public abstract class VLElement
extends Screen
implements IElementContainer,
IElementInput,
IElementDraw {
    private ElementContainer container;
    private ThemeRegistry themeRegistryClient;
    private ThemeID themeID;
    private Theme theme;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int xSize = 0;
    private int ySize = 0;
    private boolean initialized = false;
    private int mx = 0;
    private int my = 0;

    public VLElement(ITextComponent title, ThemeRegistry themeRegistry, ThemeID themeID) {
        super(title);
        this.themeRegistryClient = themeRegistry;
        this.themeID = themeID;
        this.theme = this.themeRegistryClient.getTheme(this.themeID);
    }

    protected void init() {
        if (!this.initialized) {
            this.initContainer();
            this.initialized = true;
        }
        this.guiLeft = (int)Math.floor((double)this.width / 2.0) - this.xSize / 2;
        this.guiTop = (int)Math.floor((double)this.height / 2.0) - this.ySize / 2;
        super.init();
    }

    protected abstract void addElements();

    @Override
    public final void initContainer() {
        this.container = new ElementContainer(this, "screen", this.getSizeX(), this.getSizeY());
        this.container.initContainer();
    }

    public void setSize(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
    }

    protected void addElement(IElement ele, int x, int y) {
        if (ele == null) {
            return;
        }
        this.container.addElement(ele, x, y);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void tick() {
        super.tick();
        this.update();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.drawBackground(mouseX, mouseY, partialTicks);
        this.mx = mouseX;
        this.my = mouseY;
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackground(mouseX, mouseY, partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawForeground(mouseX, mouseY);
        GlStateManager.popMatrix();
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public Screen getGui() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        return 0;
    }

    @Override
    public int getActualX() {
        return this.guiLeft;
    }

    @Override
    public int getActualY() {
        return this.guiTop;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    @Override
    public void update() {
        this.container.update();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isBackgroundVisible() {
        return true;
    }

    @Override
    public boolean isForegroundVisible() {
        return true;
    }

    @Override
    public final void drawBackground(int mouseX, int mouseY, float partialTicks) {
        this.container.drawBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    public final void drawForeground(int mouseX, int mouseY) {
        this.container.drawForeground(mouseX, mouseY);
    }

    @Override
    public final boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.container.mouseClicked(mouseX, mouseY, mouseButton);
        return false;
    }

    @Override
    public final boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.container.mouseReleased(mouseX, mouseY, mouseButton);
        return false;
    }

    @Override
    public final boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        this.container.mouseDragged(mouseX, mouseY, mouseButton, mouseX, mouseY);
        return false;
    }

    @Override
    public final boolean mouseScrolled(double scrolled) {
        this.container.mouseScrolled(scrolled);
        return false;
    }

    @Override
    public final boolean keyPressed(int key, int scanCode, int modifiers) {
        this.container.keyPressed(key, scanCode, modifiers);
        if (key == 256 && this.shouldCloseOnEsc()) {
            this.closeGui();
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public void closeGui() {
        super.onClose();
    }

    public final boolean func_223281_a_(int key, int scanCode, int modifiers) {
        this.container.keyReleased(key, scanCode, modifiers);
        return false;
    }

    @Override
    public final boolean charTyped(char ch, int modifiers) {
        this.container.charTyped(ch, modifiers);
        return false;
    }

    @Override
    public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
    }

    @Override
    public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
    }

    @Override
    public void mouseScrolledResponse(IElement element, double scrolled) {
    }

    @Override
    public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
    }

    @Override
    public void charTypedResponse(IElement element, char ch, int modifiers) {
    }

    private static class ElementContainer
    extends VLEleContainerFixed {
        private VLElement screen;

        public ElementContainer(VLElement gui, String id, int xSize, int ySize) {
            super(gui, id, xSize, ySize);
            this.screen = gui;
        }

        @Override
        public Theme getTheme() {
            return this.screen.getTheme();
        }

        @Override
        public void addElements() {
            this.screen.addElements();
        }

        @Override
        public void mouseClickedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
            this.screen.mouseClickedResponse(element, mouseX, mouseY, mouseButton);
        }

        @Override
        public void mouseReleasedResponse(IElement element, double mouseX, double mouseY, int mouseButton) {
            this.screen.mouseReleasedResponse(element, mouseX, mouseY, mouseButton);
        }

        @Override
        public void mouseDraggedResponse(IElement element, double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
            this.screen.mouseDraggedResponse(element, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
        }

        @Override
        public void mouseScrolledResponse(IElement element, double scrolled) {
            this.screen.mouseScrolledResponse(element, scrolled);
        }

        @Override
        public void keyPressedResponse(IElement element, int key, int scanCode, int modifiers) {
            this.screen.keyPressedResponse(element, key, scanCode, modifiers);
        }

        @Override
        public void keyReleasedResponse(IElement element, int key, int scanCode, int modifiers) {
            this.screen.keyReleasedResponse(element, key, scanCode, modifiers);
        }

        @Override
        public void charTypedResponse(IElement element, char ch, int modifiers) {
            this.charTypedResponse(element, ch, modifiers);
        }
    }
}

