/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class VLEleIndex
extends VLElement
implements IElementContainer,
IElementDraw,
IElementInput {
    private Map<String, IElement> indices = Maps.newHashMap();
    private Map<String, Integer> idToNum = Maps.newHashMap();
    private Map<Integer, String> numToId = Maps.newHashMap();
    private int totalIndices = 0;
    private String currentIndex;

    public VLEleIndex(IElementContainer owner, String id) {
        super(owner, id);
    }

    @Override
    public final void load(CompoundNBT nbt) {
        CompoundNBT tn = nbt.func_74775_l(this.getID());
        this.setIndex(tn.func_74779_i("index"));
        this.getCurrentIndex().load(nbt);
    }

    @Override
    public final CompoundNBT save(CompoundNBT nbt) {
        CompoundNBT tn = new CompoundNBT();
        tn.func_74778_a("index", this.currentIndex);
        this.getCurrentIndex().save(tn);
        nbt.func_218657_a(this.getID(), (INBT)tn);
        return nbt;
    }

    @Override
    public int getSizeX() {
        IElement ele = this.indices.get(this.currentIndex);
        return ele != null ? ele.getSizeX() : 0;
    }

    @Override
    public int getSizeY() {
        IElement ele = this.indices.get(this.currentIndex);
        return ele != null ? ele.getSizeY() : 0;
    }

    @Override
    public Screen getGui() {
        return this.getContainer().getGui();
    }

    @Override
    public Theme getTheme() {
        return this.getContainer().getTheme();
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        return 0;
    }

    @Override
    public void update() {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele != null && ele instanceof IElementUpdate) {
            ((IElementUpdate)((Object)ele)).update();
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isBackgroundVisible()) {
            ((IElementDraw)((Object)ele)).drawBackground(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementDraw && ((IElementDraw)((Object)ele)).isForegroundVisible()) {
            ((IElementDraw)((Object)ele)).drawForeground(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).mouseClicked(mouseX, mouseY, mouseButton)) {
            this.mouseClickedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).mouseReleased(mouseX, mouseY, mouseButton)) {
            this.mouseReleasedResponse(ele, mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).mouseDragged(mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd)) {
            this.mouseDraggedResponse(ele, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd);
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double scrolled) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).mouseScrolled(scrolled)) {
            this.mouseScrolledResponse(ele, scrolled);
        }
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).keyPressed(key, scanCode, modifiers)) {
            this.keyPressedResponse(ele, key, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean keyReleased(int key, int scanCode, int modifiers) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).keyReleased(key, scanCode, modifiers)) {
            this.keyReleasedResponse(ele, key, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean charTyped(char ch, int modifiers) {
        IElement ele = this.indices.get(this.currentIndex);
        if (ele instanceof IElementInput && ((IElementInput)((Object)ele)).charTyped(ch, modifiers)) {
            this.charTypedResponse(ele, ch, modifiers);
        }
        return false;
    }

    public void addIndex(VLElement index) {
        if (index != null) {
            this.indices.put(index.getID(), index);
            this.idToNum.put(index.getID(), this.totalIndices);
            this.numToId.put(this.totalIndices, index.getID());
            ++this.totalIndices;
            if (StringUtils.isNullOrEmpty(this.currentIndex)) {
                this.currentIndex = index.getID();
            }
            if (index instanceof IElementContainer) {
                ((IElementContainer)((Object)index)).initContainer();
            }
        }
    }

    public boolean hasIndex(String indexID) {
        if (StringUtils.isNullOrEmpty(indexID)) {
            return false;
        }
        return this.indices.containsKey(indexID);
    }

    public boolean setIndex(String indexID) {
        if (this.hasIndex(indexID)) {
            this.currentIndex = indexID;
            return true;
        }
        return false;
    }

    public IElement getCurrentIndex() {
        return this.indices.get(this.currentIndex);
    }

    public IElement getIndex(String index) {
        if (!this.indices.containsKey(index)) {
            return null;
        }
        return this.indices.get(index);
    }

    public boolean setIndex(int index) {
        return false;
    }

    public String getNextIndex() {
        int next = this.idToNum.get(this.currentIndex) + 1;
        if (next < this.indices.size()) {
            return this.numToId.get(next);
        }
        return this.numToId.get(0);
    }

    public String getPrevIndex() {
        int prev = this.idToNum.get(this.currentIndex) - 1;
        if (prev >= 0) {
            return this.numToId.get(prev);
        }
        return this.numToId.get(this.indices.size() - 1);
    }

    public boolean hasNextIndex() {
        return this.idToNum.get(this.currentIndex) < this.indices.size() - 1;
    }

    public boolean hasPrevIndex() {
        return this.idToNum.get(this.currentIndex) > 0;
    }

    public boolean isCurrentIndex(String index) {
        return index != null ? index.equals(this.currentIndex) : false;
    }
}

