/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.VLEleContainerBase;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.VLElePosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;

public abstract class VLEleContainerFixed
extends VLEleContainerBase {
    protected Map<IElement, VLElePosition> elements;
    protected List<IElement> elementsList;
    private VLElePosition size;

    public VLEleContainerFixed(IElementContainer owner, String id, int xSize, int ySize) {
        super(owner, id);
        this.size = new VLElePosition(xSize, ySize);
        this.elements = new HashMap<IElement, VLElePosition>();
        this.elementsList = new ArrayList<IElement>();
    }

    public final void addElement(IElement ele, int x, int y) {
        if (ele != null) {
            VLElePosition pos = new VLElePosition(x, y);
            this.elements.put(ele, pos);
            this.elementsList.add(ele);
        }
    }

    @Override
    @NotNull
    protected List<IElement> getElementList() {
        return this.elementsList;
    }

    @Override
    public Screen getGui() {
        return this.owner.getGui();
    }

    @Override
    public Theme getTheme() {
        return this.owner.getTheme();
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getX();
        }
        return 0;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return this.elements.get(ele).getY();
        }
        return 0;
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return null;
    }

    @Override
    public int getSizeX() {
        return this.size.getX();
    }

    @Override
    public int getSizeY() {
        return this.size.getX();
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawBackground(this.elementsList, mouseX, mouseY, partialTicks, this);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GuiUtils.drawForeground(this.elementsList, mouseX, mouseY, this);
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elementsList);
    }

    @Override
    public void onThemeChanged(Theme current) {
        GuiUtils.onThemeChangedAll(this.elementsList, current);
    }
}

