/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.theme.client;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeID;
import com.valkyrieofnight.vlib.core.util.NamespaceLocation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ThemeSaver {
    private static ThemeSaver INSTANCE;
    public static final ThemeID NONE;
    protected Gson gson;
    protected File file;
    private Map<NamespaceLocation, ThemeID> preferences = Maps.newHashMap();

    public ThemeSaver(File location) {
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.file = location;
    }

    public boolean hasPreference(NamespaceLocation saveID) {
        return this.preferences.containsKey(saveID);
    }

    public ThemeID getPreference(NamespaceLocation saveID) {
        ThemeID r = this.preferences.get(saveID);
        return r != null ? r : NONE;
    }

    private Map<String, String> getAsStringMap() {
        HashMap r = Maps.newHashMap();
        this.preferences.forEach((namespace, themeID) -> r.put(namespace.toString(), themeID.toString()));
        return r;
    }

    public void load() {
        Map sm = null;
        try {
            BufferedReader r = new BufferedReader(new FileReader(this.file));
            if (r.ready()) {
                Type to = new TypeToken<Map<String, String>>(){}.getType();
                sm = (Map)this.gson.fromJson((Reader)r, to);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sm != null) {
            sm.forEach((namespace, themeID) -> {
                NamespaceLocation nl = NamespaceLocation.fromString(namespace);
                NamespaceLocation nltid = NamespaceLocation.fromString(themeID);
                ThemeID tid = new ThemeID(nltid.getNamespace(), nltid.getLocation());
            });
        }
    }

    public void save() {
        try {
            this.file.getParentFile().mkdirs();
            FileWriter w = new FileWriter(this.file);
            w.write(this.gson.toJson(this.getAsStringMap()));
            w.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        NONE = new ThemeID("none", "none");
    }
}

