/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.modloader.forge;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.debug.SimpleDebugger;
import com.valkyrieofnight.vlib.core.util.modloader.IMCRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ForgeRegEvents
implements IMCRegistry {
    private SimpleDebugger db;
    private List<Block> blocks = Lists.newArrayList();
    private List<TileEntityType<?>> tileTypes = Lists.newArrayList();
    private List<Item> items = Lists.newArrayList();
    private List<Fluid> fluids = Lists.newArrayList();
    private List<EntityType<?>> entityTypes = Lists.newArrayList();
    private List<Potion> potions = Lists.newArrayList();
    private List<DimensionType> dimensionTypes = Lists.newArrayList();
    private List<Effect> effects = Lists.newArrayList();
    private List<Enchantment> enchants = Lists.newArrayList();
    private List<ContainerType<?>> containerTypes = Lists.newArrayList();
    private List<IRecipeType<?>> recipeTypes = Lists.newArrayList();
    private List<IRecipeSerializer<?>> recipeSerializers = Lists.newArrayList();
    private List<SoundEvent> soundEvents = Lists.newArrayList();

    public ForgeRegEvents(SimpleDebugger debugger) {
        this.db = debugger;
    }

    @SubscribeEvent
    public void eBlock(RegistryEvent.Register<Block> e) {
        this.db.log("Registering Blocks:");
        this.blocks.forEach(block -> {
            this.db.log("  " + block.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)block);
        });
    }

    @SubscribeEvent
    public void eTileType(RegistryEvent.Register<TileEntityType<?>> e) {
        this.db.log("Registering TileEntityTypes:");
        this.tileTypes.forEach(tileType -> {
            this.db.log("  " + tileType.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)tileType);
        });
    }

    @SubscribeEvent
    public void eItem(RegistryEvent.Register<Item> e) {
        this.db.log("Registering Itmes:");
        this.items.forEach(item -> {
            this.db.log("  " + item.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)item);
        });
    }

    @SubscribeEvent
    public void eFluid(RegistryEvent.Register<Fluid> e) {
        this.db.log("Registering Fluids:");
        this.fluids.forEach(fluid -> {
            this.db.log("  " + fluid.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)fluid);
        });
    }

    @SubscribeEvent
    public void eEntityType(RegistryEvent.Register<EntityType<?>> e) {
        this.db.log("Registering EntityTypes:");
        this.entityTypes.forEach(entityType -> {
            this.db.log("  " + entityType.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)entityType);
        });
    }

    @SubscribeEvent
    public void ePotion(RegistryEvent.Register<Potion> e) {
        this.db.log("Registering Potions:");
        this.potions.forEach(potion -> {
            this.db.log("  " + potion.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)potion);
        });
    }

    @SubscribeEvent
    public void eDimention(RegistryEvent.Register<DimensionType> e) {
        this.db.log("Registering DimentionTypes:");
        this.dimensionTypes.forEach(dimensionType -> {
            this.db.log("  " + dimensionType.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)dimensionType);
        });
    }

    @SubscribeEvent
    public void eEffect(RegistryEvent.Register<Effect> e) {
        this.db.log("Registering Effects:");
        this.effects.forEach(effect -> {
            this.db.log("  " + effect.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)effect);
        });
    }

    @SubscribeEvent
    public void eSoundEvent(RegistryEvent.Register<SoundEvent> e) {
        this.db.log("Registering SoundEvents:");
        this.soundEvents.forEach(soundEvent -> {
            this.db.log("  " + soundEvent.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)soundEvent);
        });
    }

    @SubscribeEvent
    public void eEnchantment(RegistryEvent.Register<Enchantment> e) {
        this.db.log("Registering Enchantments: ");
        this.enchants.forEach(enchantment -> {
            this.db.log("  " + enchantment.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)enchantment);
        });
    }

    @SubscribeEvent
    public void eContainerType(RegistryEvent.Register<ContainerType<?>> e) {
        this.db.log("Registering ContainerTypes: ");
        this.containerTypes.forEach(containerType -> {
            this.db.log("  " + containerType.getRegistryName());
            e.getRegistry().register((IForgeRegistryEntry)containerType);
        });
    }

    @Override
    public void registerBlock(@NotNull Block block) {
        this.blocks.add(block);
    }

    @Override
    public void registerTileType(@NotNull TileEntityType<?> tile) {
        this.tileTypes.add(tile);
    }

    @Override
    public void registerItem(@NotNull Item item) {
        this.items.add(item);
    }

    @Override
    public void registerFluid(@NotNull Fluid fluid) {
        this.fluids.add(fluid);
    }

    @Override
    public void registerEntityType(@NotNull EntityType<?> entity) {
        this.entityTypes.add(entity);
    }

    @Override
    public void registerPotion(@NotNull Potion potion) {
        this.potions.add(potion);
    }

    @Override
    public void registerDimensionType(@NotNull DimensionType dimension) {
        this.dimensionTypes.add(dimension);
    }

    @Override
    public void registerEffect(@NotNull Effect effect) {
        this.effects.add(effect);
    }

    @Override
    public void registerEnchantment(@NotNull Enchantment enchant) {
        this.enchants.add(enchant);
    }

    @Override
    public void registerContainerType(@NotNull ContainerType<?> container) {
        this.containerTypes.add(container);
    }

    @Override
    public void registerRecipeType(@NotNull IRecipeType<?> recipeType) {
        this.recipeTypes.add(recipeType);
    }

    @Override
    public void registerRecipeSerializer(@NotNull IRecipeSerializer<?> recipeSerializer) {
        this.recipeSerializers.add(recipeSerializer);
    }
}

