/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.player;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class PlayerUtil {
    public static boolean doesPlayerExist(World world, UUID player) {
        if (world == null || player == null) {
            return false;
        }
        if (world.func_73046_m() == null) {
            return false;
        }
        return world.func_73046_m().func_184103_al().func_177451_a(player) != null;
    }

    public static PlayerEntity getPlayerFromWorld(World world, UUID player) {
        if (world == null || player == null) {
            return null;
        }
        if (world.func_73046_m() == null) {
            return null;
        }
        return world.func_73046_m().func_184103_al().func_177451_a(player);
    }

    public static boolean doesPlayerExistClient(World world, UUID player) {
        if (player == null) {
            return false;
        }
        List players = world.func_217369_A();
        for (PlayerEntity entityPlayer : players) {
            if (entityPlayer.func_110124_au().compareTo(player) != 0) continue;
            return true;
        }
        return false;
    }

    public static PlayerEntity getPlayerFromWorldClient(World world, UUID player) {
        if (player == null) {
            return null;
        }
        List players = world.func_217369_A();
        for (PlayerEntity entityPlayer : players) {
            if (entityPlayer.func_110124_au().compareTo(player) != 0) continue;
            return entityPlayer;
        }
        return null;
    }

    public static CompoundNBT profileToNBT(GameProfile profile) {
        NBTBuilder nbt = NBTBuilder.create();
        UUID id = profile.getId();
        if (id != null) {
            nbt.putLong("UUIDL", id.getLeastSignificantBits());
            nbt.putLong("UUIDU", id.getMostSignificantBits());
        }
        return nbt.build();
    }

    public static void writeProfileToNBT(GameProfile profile, CompoundNBT tag) {
        tag.func_74778_a("Name", profile.getName());
        UUID id = profile.getId();
        PlayerUtil.writeUUID(id, tag);
    }

    public static GameProfile profileFromNBT(CompoundNBT tag) {
        String name = tag.func_74779_i("Name");
        UUID uuid = PlayerUtil.readUUID(tag);
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return new GameProfile(uuid, name);
    }

    public static CompoundNBT writeUUID(UUID id, CompoundNBT tag) {
        if (id != null) {
            tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
            tag.func_74772_a("UUIDU", id.getMostSignificantBits());
        }
        return tag;
    }

    public static UUID readUUID(CompoundNBT tag) {
        if (tag.func_74764_b("UUIDL")) {
            return new UUID(tag.func_74763_f("UUIDU"), tag.func_74763_f("UUIDL"));
        }
        return null;
    }
}

