/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.base;

import com.valkyrieofnight.vlib.core.debug.SimpleDebugger;
import com.valkyrieofnight.vlib.core.ui.theme.common.ThemeIDRegistry;
import com.valkyrieofnight.vlib.core.util.modloader.SideUtil;
import com.valkyrieofnight.vlib.core.util.wrapped.VLRegistry;
import com.valkyrieofnight.vlib.module.base.VLModule;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.core.VLMainModule;
import com.valkyrieofnight.vlib.module.interfaces.IInit;
import com.valkyrieofnight.vlib.module.interfaces.IInitClient;
import com.valkyrieofnight.vlib.module.interfaces.IInitServer;
import com.valkyrieofnight.vlib.module.proxy.ProxyClient;
import com.valkyrieofnight.vlib.module.proxy.ProxyCommon;
import com.valkyrieofnight.vlib.module.proxy.ProxyServer;

public abstract class VLMod {
    private final String modid;
    private SimpleDebugger debugger;
    private VLMainModule mainModule;
    private ProxyCommon proxy;
    private String configBaseDirectory;
    private VLRegistry registry;

    public VLMod(String modid) {
        this.modid = modid;
        this.debugger = new SimpleDebugger("config/" + modid + "/log.log");
        this.debugger.log("Mod ID: " + modid);
        this.mainModule = new VLMainModule(this, modid, this.debugger){

            @Override
            public void init(IConfig config) {
                VLMod.this._init(config);
            }

            @Override
            public void initServer(IConfig config) {
                VLMod.this._initServer(config);
            }

            @Override
            public void initClient(IConfig config) {
                VLMod.this._initClient(config);
            }

            @Override
            public void setupModule() {
                VLMod.this.setupMod();
            }

            @Override
            public boolean createUniqueThemeRegistry() {
                return VLMod.this.createThemeRegistry();
            }
        };
        this.configBaseDirectory = "config/";
        this.setup2();
    }

    public VLMod(String suite, String member) {
        this.modid = suite + member;
        this.setup1(suite, member);
        this.setup2();
    }

    public VLMod(String suite, String member, String modid) {
        this.modid = modid;
        this.setup1(suite, member);
        this.setup2();
    }

    private void setup1(String suite, String member) {
        this.debugger = new SimpleDebugger("config/" + suite + "/" + member + ".log");
        this.debugger.log("Suite ID: " + suite);
        this.debugger.log("Member ID: " + member);
        this.debugger.log("Mod ID: " + this.modid);
        this.mainModule = new VLMainModule(this, member, this.debugger){

            @Override
            public void init(IConfig config) {
                VLMod.this._init(config);
            }

            @Override
            public void initServer(IConfig config) {
                VLMod.this._initServer(config);
            }

            @Override
            public void initClient(IConfig config) {
                VLMod.this._initClient(config);
            }

            @Override
            public void setupModule() {
                VLMod.this.setupMod();
            }

            @Override
            public boolean createUniqueThemeRegistry() {
                return VLMod.this.createThemeRegistry();
            }
        };
        this.configBaseDirectory = "config/" + suite + "/";
    }

    private void setup2() {
        this.proxy = SideUtil.isClient() ? new ProxyClient(this, this.debugger) : new ProxyServer(this, this.debugger);
        this.registry = this.proxy.getRegistry();
        this.mainModule._0moduleSetup();
        this.mainModule._1moduleConfigurationSetup(this.configBaseDirectory);
        this.mainModule._2registerAssets(this.registry);
        this.debugger.log("Setup Complete");
    }

    public abstract void setupMod();

    public final void initMod() {
        this.mainModule._3init();
        this.proxy.init();
        this.mainModule._5saveConfigs();
    }

    public void addChild(VLModule module) {
        if (module != null) {
            this.mainModule.addChild(module);
        }
    }

    private void _init(IConfig config) {
        if (this instanceof IInit) {
            ((IInit)((Object)this)).init(config);
        }
        this.proxy.init();
    }

    private void _initServer(IConfig config) {
        if (this instanceof IInitServer) {
            ((IInitServer)((Object)this)).initServer(config);
        }
    }

    private void _initClient(IConfig config) {
        if (this instanceof IInitClient) {
            ((IInitClient)((Object)this)).initClient(config);
        }
    }

    public final VLMainModule getMainModule() {
        return this.mainModule;
    }

    public boolean createThemeRegistry() {
        return false;
    }

    public ThemeIDRegistry getThemeIDRegistry() {
        return this.registry.getThemeIDRegistry();
    }
}

