/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module.base;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.debug.SimpleDebugger;
import com.valkyrieofnight.vlib.core.io.json.config.JsonConfig;
import com.valkyrieofnight.vlib.core.util.wrapped.VLRegistry;
import com.valkyrieofnight.vlib.core.util.wrapped.VLRegistryClient;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.config.PropMapWrapper;
import com.valkyrieofnight.vlib.module.interfaces.IInit;
import com.valkyrieofnight.vlib.module.interfaces.IInitClient;
import com.valkyrieofnight.vlib.module.interfaces.IInitServer;
import com.valkyrieofnight.vlib.module.interfaces.IRegisterAssets;
import com.valkyrieofnight.vlib.module.interfaces.IRegisterAssetsClient;
import com.valkyrieofnight.vlib.module.proxy.ProxyClient;
import com.valkyrieofnight.vlib.module.proxy.ProxyServer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VLModule {
    private final String id;
    private boolean enabled;
    private VLModule parent;
    private JsonConfig config;
    private IConfig iConfig;
    private File configLocation;
    private List<VLModule> children = Lists.newArrayList();

    public VLModule(@NotNull String id) {
        this.id = id.toLowerCase();
    }

    public SimpleDebugger getDebugger() {
        return this.parent.getDebugger();
    }

    public final void _0moduleSetup() {
        this.setupModule();
        for (VLModule m : this.children) {
            m._0moduleSetup();
        }
    }

    public final void _1moduleConfigurationSetup(String baseDirectory, IConfig parentConfig) {
        String str = baseDirectory + this.getLocation() + this.getID() + ".json";
        this.configLocation = new File(str);
        this.config = new JsonConfig(str);
        this.config.setId(this.id);
        if (this.configLocation.exists()) {
            this.config.loadConfig();
        }
        this.iConfig = new PropMapWrapper(this.config);
        for (VLModule m : this.children) {
            m._1moduleConfigurationSetup(baseDirectory, this.iConfig);
        }
        this.enabled = this.canDisable() ? this.iConfig.getBoolean("enabled", this.isEnabledByDefault(), "valkyrielib.module.enabled") : true;
    }

    public final void _2registerAssets(VLRegistry registry) {
        if (this instanceof IRegisterAssets) {
            ((IRegisterAssets)((Object)this)).registerAssets(this.iConfig, registry);
        }
        for (VLModule m : this.children) {
            if (!m.isEnabled()) continue;
            m._2registerAssets(registry);
        }
    }

    public final void _registerAssetsClient(VLRegistryClient registry) {
        if (this instanceof IRegisterAssetsClient) {
            ((IRegisterAssetsClient)((Object)this)).registerAssetsClient(this.iConfig, registry);
        }
        for (VLModule m : this.children) {
            if (!m.isEnabled()) continue;
            m._registerAssetsClient(registry);
        }
    }

    public final void _3init() {
        if (this instanceof IInit) {
            ((IInit)((Object)this)).init(this.iConfig);
        }
        for (VLModule m : this.children) {
            if (!m.isEnabled()) continue;
            m._3init();
        }
    }

    public final void _4clientInit(ProxyClient proxy) {
        if (this instanceof IInitClient) {
            ((IInitClient)((Object)this)).initClient(this.iConfig);
        }
        for (VLModule m : this.children) {
            if (!m.isEnabled()) continue;
            m._4clientInit(proxy);
        }
    }

    public final void _4serverInit(ProxyServer proxy) {
        if (this instanceof IInitServer) {
            ((IInitServer)((Object)this)).initServer(this.iConfig);
        }
        for (VLModule m : this.children) {
            if (!m.isEnabled()) continue;
            m._4serverInit(proxy);
        }
    }

    public final void _5saveConfigs() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.config != null) {
            List<String> data = this.config.dumpData();
            for (String string : data) {
            }
            this.config.saveConfig();
        }
        for (VLModule m : this.children) {
            m._5saveConfigs();
        }
    }

    public final void _5saveDocumentation() {
        if (this.getGlobalConfig().getBoolean("generate_documentation", true, "valkyrielib.documentation.version")) {
            this.config.saveDocumentation();
        }
        for (VLModule m : this.children) {
            m._5saveDocumentation();
        }
    }

    protected final boolean hasParent() {
        return this.parent != null;
    }

    public final IConfig getConfig() {
        return this.iConfig;
    }

    public IConfig getGlobalConfig() {
        if (this.parent == null) {
            return this.iConfig;
        }
        return this.parent.getGlobalConfig();
    }

    public final String getID() {
        return this.id;
    }

    public final String getLocation() {
        if (this.parent != null) {
            return this.parent.getLocation() + this.id + "/";
        }
        return this.id + "/";
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean canDisable() {
        return true;
    }

    public final void addChild(VLModule module) {
        if (module != null && !module.hasParent()) {
            module.setParent(this);
            this.children.add(module);
        }
    }

    private void setParent(VLModule parent) {
        if (parent != null && !this.hasParent()) {
            this.parent = parent;
        }
    }

    public abstract void setupModule();
}

