/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ReconfigurableHelper;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.item.ItemAugment;
import cofh.thermalfoundation.item.ItemBait;
import cofh.thermalfoundation.item.ItemFertilizer;
import cofh.thermalfoundation.item.ItemUpgrade;
import com.arcaratus.virtualmachines.VirtualMachines;
import com.arcaratus.virtualmachines.block.machine.ItemBlockVirtualMachine;
import com.arcaratus.virtualmachines.block.machine.TileAnimalFarm;
import com.arcaratus.virtualmachines.block.machine.TileDarkRoom;
import com.arcaratus.virtualmachines.block.machine.TileFarm;
import com.arcaratus.virtualmachines.block.machine.TileFishery;
import com.arcaratus.virtualmachines.block.machine.TileMobFarm;
import com.arcaratus.virtualmachines.block.machine.TileMobSpawner;
import com.arcaratus.virtualmachines.block.machine.TileVirtualMachine;
import com.arcaratus.virtualmachines.init.VMConstants;
import com.arcaratus.virtualmachines.init.VMTextures;
import com.arcaratus.virtualmachines.item.ItemMaterial;
import com.arcaratus.virtualmachines.render.BakeryVirtualMachine;
import com.arcaratus.virtualmachines.virtual.VirtualFarm;
import com.arcaratus.virtualmachines.virtual.VirtualFishery;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockVirtualMachine
extends BlockTEBase
implements IModelRegister,
IBakeryProvider,
IWorldBlockTextureProvider {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static boolean[] enable = new boolean[Type.values().length];
    public static ItemStack virtual_farm;
    public static ItemStack virtual_fishery;
    public static ItemStack virtual_dark_room;
    public static ItemStack virtual_animal_farm;
    public static ItemStack virtual_mob_spawner;
    public static ItemStack virtual_mob_farm;
    public static ItemBlockVirtualMachine itemBlock;

    public BlockVirtualMachine() {
        super(Material.field_151573_f);
        this.modName = "virtualmachines";
        this.func_149663_c("virtual_machine");
        this.func_149647_a(VirtualMachines.TAB_VIRTUAL_MACHINES);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.FARM)));
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{VARIANT});
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{VMConstants.TILE_VIRTUAL_MACHINE});
        builder.add(new IUnlistedProperty[]{TEProps.BAKERY_WORLD});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values().length; ++i) {
            if (!enable[i]) continue;
            if (TEProps.creativeTabShowAllBlockLevels) {
                for (int j = 0; j <= 4; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), TEProps.creativeTabLevel));
            }
            if (!TEProps.creativeTabShowCreative) continue;
            items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this, 1, i)));
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        return "tile.virtualmachines." + Type.values()[ItemHelper.getItemDamage((ItemStack)stack)].func_176610_l() + ".name";
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        if (meta >= Type.values().length) {
            return null;
        }
        switch (Type.values()[meta]) {
            case FARM: {
                return new TileFarm();
            }
            case FISHERY: {
                return new TileFishery();
            }
            case DARK_ROOM: {
                return new TileDarkRoom();
            }
            case ANIMAL_FARM: {
                return new TileAnimalFarm();
            }
            case MOB_SPAWNER: {
                return new TileMobSpawner();
            }
            case MOB_FARM: {
                return new TileMobFarm();
            }
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileVirtualMachine tile = (TileVirtualMachine)world.func_175625_s(pos);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            tile.readAugmentsFromNBT(stack.func_77978_p());
            tile.updateAugmentStatus();
            tile.setEnergyStored(stack.func_77978_p().func_74762_e("Energy"));
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = ReconfigurableHelper.getFacing((ItemStack)stack);
            byte[] sideCache = ReconfigurableHelper.getSideCache((ItemStack)stack, (byte[])tile.getDefaultSides());
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = 0;
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileVirtualMachine tile = (TileVirtualMachine)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerAccess(player)) {
            return false;
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            ItemStack heldItem = player.func_184586_b(hand);
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (FluidHelper.isFluidHandler((ItemStack)heldItem)) {
                FluidHelper.drainItemToHandler((ItemStack)heldItem, (IFluidHandler)handler, (EntityPlayer)player, (EnumHand)hand);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    public IBakery getBakery() {
        return BakeryVirtualMachine.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, ItemStack stack) {
        if (side == EnumFacing.DOWN) {
            return TETextures.MACHINE_BOTTOM;
        }
        if (side == EnumFacing.UP) {
            return TETextures.MACHINE_TOP;
        }
        return side != EnumFacing.NORTH ? TETextures.MACHINE_SIDE : VMTextures.MACHINE_FACE[stack.func_77960_j() % Type.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, IBlockState state, BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileVirtualMachine) {
            int i;
            TileVirtualMachine tile = (TileVirtualMachine)tileEntity;
            TextureAtlasSprite texture = tile.getTexture(side.ordinal(), layer == BlockRenderLayer.SOLID ? 0 : 1);
            for (i = 0; i < TETextures.MACHINE_ACTIVE.length; ++i) {
                if (texture != TETextures.MACHINE_ACTIVE[i]) continue;
                return VMTextures.MACHINE_ACTIVE[i];
            }
            for (i = 0; i < TETextures.MACHINE_FACE.length; ++i) {
                if (texture != TETextures.MACHINE_FACE[i]) continue;
                return VMTextures.MACHINE_FACE[i];
            }
            return texture;
        }
        return TextureUtils.getMissingSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMap.Builder stateMap = new StateMap.Builder();
        stateMap.func_178442_a(new IProperty[]{VARIANT});
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)stateMap.func_178441_a());
        ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "normal");
        for (Type type : Type.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMetadata(), (ModelResourceLocation)location);
        }
        ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            TileVirtualMachine tile = (TileVirtualMachine)((Object)((Object)state.getValue(VMConstants.TILE_VIRTUAL_MACHINE)));
            StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName() + "|" + state.func_177230_c().func_176201_c((IBlockState)state));
            builder.append(",creative=").append(tile.isCreative);
            builder.append(",level=").append(tile.getLevel());
            builder.append(",facing=").append(tile.getFacing());
            builder.append(",active=").append(tile.isActive);
            builder.append(",side_config={");
            for (byte i : tile.sideCache) {
                builder.append(",").append(i);
            }
            builder.append("}");
            if (tile.hasFluidUnderlay() && tile.isActive) {
                FluidStack stack = tile.getRenderFluid();
                builder.append(",fluid=").append(stack != null ? Integer.valueOf(FluidHelper.getFluidHash((FluidStack)stack)) : tile.getTexture(tile.getFacing(), 0).func_94215_i());
            }
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack));
    }

    public boolean preInit() {
        this.setRegistryName("virtual_machine");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockVirtualMachine((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileVirtualMachine.config();
        TileFarm.init();
        VirtualFarm.init();
        TileFishery.init();
        VirtualFishery.init();
        TileDarkRoom.init();
        TileAnimalFarm.init();
        TileMobSpawner.init();
        TileMobFarm.init();
        VirtualMachines.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        virtual_farm = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.FARM.getMetadata()));
        virtual_fishery = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.FISHERY.getMetadata()));
        virtual_dark_room = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.DARK_ROOM.getMetadata()));
        virtual_animal_farm = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.ANIMAL_FARM.getMetadata()));
        virtual_mob_spawner = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.MOB_SPAWNER.getMetadata()));
        virtual_mob_farm = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, Type.MOB_FARM.getMetadata()));
        this.addRecipes();
        this.addUpgradeRecipes();
        this.addClassicRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable[Type.FARM.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)virtual_farm, (Object[])new Object[]{"PAP", "FIF", "EVE", Character.valueOf('P'), "plateLumium", Character.valueOf('A'), ItemAugment.machineInsolatorTree, Character.valueOf('F'), ItemFertilizer.fertilizerFlux, Character.valueOf('I'), BlockMachine.machineInsolator, Character.valueOf('E'), "gearEnderium", Character.valueOf('V'), ItemMaterial.virtual_machine_core_flux});
        }
        if (enable[Type.FISHERY.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)virtual_fishery, (Object[])new Object[]{"PAP", "FIF", "EVE", Character.valueOf('P'), "plateInvar", Character.valueOf('A'), "blockGlassHardened", Character.valueOf('F'), ItemBait.baitFlux, Character.valueOf('I'), BlockDevice.deviceFisher, Character.valueOf('E'), "gearSignalum", Character.valueOf('V'), ItemMaterial.virtual_machine_core_flux});
        }
        if (enable[Type.DARK_ROOM.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)virtual_dark_room, (Object[])new Object[]{"PAP", "FIF", "EVE", Character.valueOf('P'), "plateConstantan", Character.valueOf('A'), ItemAugment.machineCentrifugeMobs, Character.valueOf('F'), "blockGlassBlack", Character.valueOf('I'), BlockMachine.machinePulverizer, Character.valueOf('E'), "gearInvar", Character.valueOf('V'), ItemMaterial.virtual_machine_core_flux});
        }
        if (enable[Type.ANIMAL_FARM.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)virtual_animal_farm, (Object[])new Object[]{"PAP", "FIF", "EVE", Character.valueOf('P'), "plateSilver", Character.valueOf('A'), ItemAugment.machineCentrifugeMobs, Character.valueOf('F'), Blocks.field_150407_cf, Character.valueOf('I'), BlockMachine.machinePulverizer, Character.valueOf('E'), "gearTin", Character.valueOf('V'), ItemMaterial.virtual_machine_core_flux});
        }
        if (enable[Type.MOB_SPAWNER.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)virtual_mob_spawner, (Object[])new Object[]{"PAP", "FIF", "EVE", Character.valueOf('P'), "plateElectrum", Character.valueOf('A'), virtual_dark_room, Character.valueOf('F'), Blocks.field_150461_bJ, Character.valueOf('I'), virtual_animal_farm, Character.valueOf('E'), "gearLumium", Character.valueOf('V'), ItemMaterial.virtual_machine_core_flux});
        }
        if (enable[Type.MOB_FARM.getMetadata()]) {
            RecipeHelper.addShapedRecipe((ItemStack)virtual_mob_farm, (Object[])new Object[]{"SBS", "SFS", "STS", Character.valueOf('S'), virtual_mob_spawner, Character.valueOf('B'), Blocks.field_150461_bJ, Character.valueOf('F'), Items.field_185157_bK, Character.valueOf('T'), Items.field_190929_cY});
        }
    }

    private void addUpgradeRecipes() {
        if (!BlockMachine.enableUpgradeKitCrafting) {
            return;
        }
        for (int i = 0; i < Type.values().length; ++i) {
            int j;
            if (!enable[i]) continue;
            ItemStack[] block = new ItemStack[5];
            for (j = 0; j < 5; ++j) {
                block[j] = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j);
            }
            for (j = 0; j < 4; ++j) {
                RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)block[j + 1], (Object[])new Object[]{block[j], ItemUpgrade.upgradeIncremental[j]});
            }
            for (j = 1; j < 4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)block[j + 1], (Object[])new Object[]{block[k], ItemUpgrade.upgradeFull[j]});
                }
            }
        }
    }

    private void addClassicRecipes() {
        if (!BlockMachine.enableClassicRecipes) {
            return;
        }
        for (int i = 0; i < Type.values().length; ++i) {
            if (!enable[i]) continue;
            ItemStack[] machine = new ItemStack[5];
            for (int j = 0; j < 5; ++j) {
                machine[j] = itemBlock.setDefaultTag(new ItemStack((Block)this, 1, i), j);
            }
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[1], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), machine[0], Character.valueOf('I'), "ingotInvar"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[2], (Object[])new Object[]{"YIY", "ICI", "YIY", Character.valueOf('C'), machine[1], Character.valueOf('I'), "ingotElectrum", Character.valueOf('Y'), "blockGlassHardened"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[3], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), machine[2], Character.valueOf('I'), "ingotSignalum"});
            RecipeHelper.addShapedUpgradeRecipe((ItemStack)machine[4], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), machine[3], Character.valueOf('I'), "ingotEnderium"});
        }
    }

    public static enum Type implements IStringSerializable
    {
        FARM(0, "farm"),
        FISHERY(1, "fishery"),
        DARK_ROOM(2, "dark_room"),
        ANIMAL_FARM(3, "animal_farm"),
        MOB_SPAWNER(4, "mob_spawner"),
        MOB_FARM(5, "mob_farm");

        private final int metadata;
        private final String name;

        private Type(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

