/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.block.machine;

import cofh.api.item.IAugmentItem;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.init.TEItems;
import cofh.thermalexpansion.item.ItemMorb;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalfoundation.init.TFFluids;
import com.arcaratus.virtualmachines.VirtualMachines;
import com.arcaratus.virtualmachines.block.BlockVirtualMachine;
import com.arcaratus.virtualmachines.block.machine.TileVirtualMachine;
import com.arcaratus.virtualmachines.gui.client.machine.GuiAnimalFarm;
import com.arcaratus.virtualmachines.gui.container.machine.ContainerAnimalFarm;
import com.arcaratus.virtualmachines.utils.Utils;
import com.arcaratus.virtualmachines.virtual.IVirtualMachine;
import com.arcaratus.virtualmachines.virtual.VirtualAnimalFarm;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileAnimalFarm
extends TileVirtualMachine {
    private static final int TYPE = BlockVirtualMachine.Type.ANIMAL_FARM.getMetadata();
    public static int basePower = 80;
    public static int SLOT_TOOLS_START = 0;
    public static int SLOT_ANIMAL_MORB = 4;
    public static int SLOT_OUTPUT_START = 5;
    public static final int EXPERIENCE_MOD = 40;
    public static final int RANCHER_MOD = 40;
    public static final int PERMAMORB_MOD = 220;
    public static final int EXPERIENCE = 50;
    public static final List<String> ANIMAL_LIST = Lists.newArrayList((Object[])new String[]{"minecraft:chicken", "minecraft:pig", "minecraft:cow", "minecraft:sheep", "minecraft:rabbit", "minecraft:squid", "minecraft:mooshroom", "minecraft:horse", "minecraft:llama"});
    public static final List<String> RANCHABLE_ANIMAL_LIST = Lists.newArrayList((Object[])new String[]{"minecraft:chicken", "minecraft:cow", "minecraft:sheep", "minecraft:mooshroom"});
    private int inputTrackerPrimary;
    private int inputTrackerSecondary;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(10000);
    private boolean updateOutputs = true;
    public VirtualAnimalFarm virtualAnimalFarm = new VirtualAnimalFarm();
    protected boolean augmentExperience;
    protected boolean flagExperience;
    protected boolean augmentRancher;
    protected boolean augmentPermamorb;

    public static void init() {
        TileAnimalFarm.SIDE_CONFIGS[TileAnimalFarm.TYPE] = new SideConfig();
        TileAnimalFarm.SIDE_CONFIGS[TileAnimalFarm.TYPE].numConfig = 7;
        TileAnimalFarm.SIDE_CONFIGS[TileAnimalFarm.TYPE].slotGroups = new int[][]{new int[0], IntStream.range(SLOT_TOOLS_START, SLOT_ANIMAL_MORB + 1).toArray(), IntStream.range(SLOT_OUTPUT_START, SLOT_OUTPUT_START + 9).toArray(), {SLOT_ANIMAL_MORB}, IntStream.range(SLOT_TOOLS_START, SLOT_TOOLS_START + 4).toArray(), new int[0], IntStream.range(0, 15).toArray()};
        TileAnimalFarm.SIDE_CONFIGS[TileAnimalFarm.TYPE].sideTypes = new int[]{0, 1, 4, 5, 6, 7, 8};
        TileAnimalFarm.SIDE_CONFIGS[TileAnimalFarm.TYPE].defaultSides = new byte[]{5, 1, 2, 2, 2, 2};
        TileAnimalFarm.ALT_SIDE_CONFIGS[TileAnimalFarm.TYPE] = new SideConfig();
        TileAnimalFarm.ALT_SIDE_CONFIGS[TileAnimalFarm.TYPE].numConfig = 2;
        TileAnimalFarm.ALT_SIDE_CONFIGS[TileAnimalFarm.TYPE].slotGroups = new int[][]{new int[0], IntStream.range(SLOT_TOOLS_START, SLOT_ANIMAL_MORB + 1).toArray(), IntStream.range(SLOT_OUTPUT_START, SLOT_OUTPUT_START + 9).toArray(), {SLOT_ANIMAL_MORB}, IntStream.range(SLOT_TOOLS_START, SLOT_TOOLS_START + 4).toArray(), new int[0], IntStream.range(0, 15).toArray()};
        TileAnimalFarm.ALT_SIDE_CONFIGS[TileAnimalFarm.TYPE].sideTypes = new int[]{0, 7};
        TileAnimalFarm.ALT_SIDE_CONFIGS[TileAnimalFarm.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileAnimalFarm.SLOT_CONFIGS[TileAnimalFarm.TYPE] = new SlotConfig();
        TileAnimalFarm.SLOT_CONFIGS[TileAnimalFarm.TYPE].allowInsertionSlot = new boolean[]{true, true, true, true, true, false, false, false, false, false, false, false, false, false};
        TileAnimalFarm.SLOT_CONFIGS[TileAnimalFarm.TYPE].allowExtractionSlot = new boolean[]{false, false, false, false, false, true, true, true, true, true, true, true, true, true};
        TileAnimalFarm.VALID_AUGMENTS[TileAnimalFarm.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineExperience");
        VALID_AUGMENTS[TYPE].add("machineRancher");
        VALID_AUGMENTS[TYPE].add("machinePermamorb");
        TileAnimalFarm.LIGHT_VALUES[TileAnimalFarm.TYPE] = 14;
        GameRegistry.registerTileEntity(TileAnimalFarm.class, (String)"virtualmachines:virtual_animal_farm");
        TileAnimalFarm.config();
    }

    public static void config() {
        String category = "VirtualMachine.AnimalFarm";
        BlockVirtualMachine.enable[TileAnimalFarm.TYPE] = VirtualMachines.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Virtual Animal Farm. This base value will scale with block level and Augments.";
        basePower = VirtualMachines.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileAnimalFarm.ENERGY_CONFIGS[TileAnimalFarm.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileAnimalFarm() {
        this.inventory = new ItemStack[15];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidExperience);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    protected int calcEnergy() {
        return super.calcEnergy();
    }

    @Override
    protected boolean canStart() {
        if (this.func_70301_a(SLOT_ANIMAL_MORB).func_190926_b() || this.func_70301_a(SLOT_ANIMAL_MORB).func_77973_b() != TEItems.itemMorb) {
            return false;
        }
        List<ItemStack> tools = Utils.arrayToListWithRange(this.inventory, SLOT_TOOLS_START, SLOT_TOOLS_START + 4);
        if (tools.stream().allMatch(ItemStack::func_190926_b)) {
            return false;
        }
        ItemStack morbStack = this.func_70301_a(SLOT_ANIMAL_MORB).func_77946_l();
        List<ItemStack> outputs = this.virtualAnimalFarm.getOutputs();
        if (this.updateOutputs) {
            outputs.clear();
            if (!morbStack.func_77942_o() || !ANIMAL_LIST.contains(morbStack.func_77978_p().func_74779_i("id"))) {
                return false;
            }
            if (this.augmentRancher) {
                if (RANCHABLE_ANIMAL_LIST.contains(morbStack.func_77978_p().func_74779_i("id"))) {
                    int damage;
                    ItemStack s2;
                    int itx;
                    String id = morbStack.func_77978_p().func_74779_i("id");
                    if (id.equals("minecraft:chicken")) {
                        for (itx = SLOT_TOOLS_START; itx < SLOT_TOOLS_START + 4; ++itx) {
                            s2 = this.func_70301_a(itx);
                            if (!Utils.checkTool(s2, "shears")) continue;
                            damage = this.field_145850_b.field_73012_v.nextInt(3);
                            outputs.add(new ItemStack(Items.field_151008_G, damage));
                            s2 = Utils.damageItem(s2, damage, this.field_145850_b.field_73012_v);
                            this.func_70299_a(itx, s2);
                        }
                    }
                    if (id.equals("minecraft:cow")) {
                        for (itx = SLOT_TOOLS_START; itx < SLOT_TOOLS_START + 4; ++itx) {
                            s2 = this.func_70301_a(itx);
                            if (s2.func_77973_b() != Items.field_151133_ar) continue;
                            s2.func_190918_g(1);
                            this.func_70299_a(itx, s2);
                            outputs.add(new ItemStack(Items.field_151117_aB));
                        }
                    }
                    if (id.equals("minecraft:sheep")) {
                        for (itx = SLOT_TOOLS_START; itx < SLOT_TOOLS_START + 4; ++itx) {
                            s2 = this.func_70301_a(itx);
                            if (!Utils.checkTool(s2, "shears")) continue;
                            damage = this.field_145850_b.field_73012_v.nextInt(2) + 1;
                            outputs.add(new ItemStack(Blocks.field_150325_L, damage));
                            s2 = Utils.damageItem(s2, damage, this.field_145850_b.field_73012_v);
                            this.func_70299_a(itx, s2);
                        }
                    }
                    if (id.equals("minecraft:mooshroom")) {
                        for (itx = SLOT_TOOLS_START; itx < SLOT_TOOLS_START + 4; ++itx) {
                            s2 = this.func_70301_a(itx);
                            if (s2.func_77973_b() != Items.field_151054_z) continue;
                            s2.func_190918_g(1);
                            this.func_70299_a(itx, s2);
                            outputs.add(new ItemStack(Items.field_151009_A));
                        }
                    }
                }
            } else {
                if (!tools.stream().findAny().filter(s -> Utils.checkTool(s, "sword")).isPresent()) {
                    return false;
                }
                CentrifugeManager.CentrifugeRecipe recipe = CentrifugeManager.getRecipeMob((ItemStack)morbStack);
                List recipeOutputs = recipe.getOutput();
                List chances = recipe.getChance();
                for (int i = 0; i < recipeOutputs.size(); ++i) {
                    for (int j = 0; j < ((ItemStack)recipeOutputs.get(i)).func_190916_E(); ++j) {
                        if (this.field_145850_b.field_73012_v.nextInt(this.secondaryChance + j * 10) >= (Integer)chances.get(i)) continue;
                        int itx = i;
                        if (outputs.stream().findFirst().filter(s -> s.func_77973_b() == ((ItemStack)recipeOutputs.get(itx)).func_77973_b()).isPresent()) {
                            outputs.stream().findFirst().filter(s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)((ItemStack)recipeOutputs.get(itx)))).ifPresent(s -> s.func_190917_f(1));
                            continue;
                        }
                        outputs.add(ItemHelper.cloneStack((ItemStack)((ItemStack)recipeOutputs.get(i)), (int)1));
                    }
                }
                outputs.removeIf(s -> s.func_77973_b() == TEItems.itemMorb);
            }
        }
        if (!this.augmentPermamorb) {
            ItemStack morbOutput = ItemStack.func_179545_c((ItemStack)this.func_70301_a(SLOT_ANIMAL_MORB), (ItemStack)ItemMorb.morbStandard) ? ItemMorb.morbStandard.func_77946_l() : ItemMorb.morbReusable.func_77946_l();
            outputs.add(morbOutput);
            this.func_70301_a(SLOT_ANIMAL_MORB).func_190918_g(1);
        }
        for (int itx = SLOT_TOOLS_START; itx < SLOT_TOOLS_START + 4; ++itx) {
            if (!Utils.checkTool(this.func_70301_a(itx), "sword")) continue;
            int it = itx;
            outputs.forEach(stack -> {
                float f = (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)this.func_70301_a(it)) * this.field_145850_b.field_73012_v.nextFloat();
                stack.func_190917_f(Math.round(f));
            });
            break;
        }
        this.virtualAnimalFarm.setOutputs(outputs);
        this.updateOutputs = false;
        return !outputs.isEmpty() && Utils.canFitOutputs((IInventory)this, outputs, SLOT_OUTPUT_START, SLOT_OUTPUT_START + 9);
    }

    @Override
    protected boolean hasValidInput() {
        if (this.augmentRancher) {
            return true;
        }
        List<ItemStack> tools = Utils.arrayToListWithRange(this.inventory, SLOT_TOOLS_START, SLOT_TOOLS_START + 4);
        return !tools.stream().allMatch(ItemStack::func_190926_b);
    }

    @Override
    protected void processStart() {
        double maxProcess = 24000.0;
        this.processRem = this.processMax = (int)maxProcess;
    }

    @Override
    protected void processFinish() {
        List<ItemStack> outputs = this.virtualAnimalFarm.getOutputs();
        int damage = 0;
        for (ItemStack itemStack : outputs) {
            Utils.distributeOutput((IInventory)this, itemStack, SLOT_OUTPUT_START, SLOT_OUTPUT_START + 9);
            ++damage;
        }
        for (int itx = SLOT_TOOLS_START; itx < SLOT_TOOLS_START + 4; ++itx) {
            ItemStack damagedSwordStack = this.func_70301_a(itx);
            if (!Utils.checkTool(damagedSwordStack, "sword")) continue;
            damagedSwordStack = Utils.damageItem(damagedSwordStack, damage, this.field_145850_b.field_73012_v);
            this.func_70299_a(itx, damagedSwordStack);
            break;
        }
        if (this.augmentExperience && damage > 0) {
            this.tank.fill(new FluidStack(TFFluids.fluidExperience, (int)Math.round(this.field_145850_b.field_73012_v.nextGaussian() * 25.0 + 50.0)), true);
        }
        this.updateOutputs = true;
    }

    @Override
    protected void transferInput() {
        int side;
        int i;
        if (!this.enableAutoInput) {
            return;
        }
        block0: for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            for (int slot = SLOT_TOOLS_START; slot < SLOT_TOOLS_START + 4; ++slot) {
                if (!this.extractItem(SLOT_TOOLS_START, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.inputTrackerPrimary = side;
                continue block0;
            }
        }
        for (i = this.inputTrackerSecondary + 1; i <= this.inputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!this.extractItem(SLOT_ANIMAL_MORB, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.augmentExperience) {
            this.transferOutputFluid();
        }
        if (Utils.checkItemStackRange(this.inventory, SLOT_OUTPUT_START, SLOT_OUTPUT_START + 9, ItemStack::func_190926_b)) {
            return;
        }
        block0: for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            for (int slot = SLOT_OUTPUT_START; slot < SLOT_OUTPUT_START + 9; ++slot) {
                if (!this.transferItem(slot, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTracker = side;
                continue block0;
            }
        }
    }

    private void transferOutputFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiAnimalFarm(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerAnimalFarm(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentExperience() {
        return this.augmentExperience && this.flagExperience;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTrackerPrimary = nbt.func_74762_e("TrackIn1");
        this.inputTrackerSecondary = nbt.func_74762_e("TrackIn2");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOutFluid");
        this.updateOutputs = nbt.func_74767_n("UpdateOutputs");
        this.tank.readFromNBT(nbt);
        this.virtualAnimalFarm.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn1", this.inputTrackerPrimary);
        nbt.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("TrackOutFluid", this.outputTrackerFluid);
        nbt.func_74757_a("UpdateOutputs", this.updateOutputs);
        this.tank.writeToNBT(nbt);
        this.virtualAnimalFarm.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        return super.getModePacket();
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentExperience);
        payload.addBool(this.augmentRancher);
        payload.addBool(this.augmentPermamorb);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.augmentExperience = payload.getBool();
        this.augmentRancher = payload.getBool();
        this.augmentPermamorb = payload.getBool();
        this.flagExperience = this.augmentExperience;
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentExperience = false;
        this.augmentRancher = false;
        this.augmentPermamorb = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentExperience) {
            this.tank.clearLocked();
            this.tank.setFluid(null);
        }
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (this.augmentExperience && "machineExperience".equals(id)) {
            return false;
        }
        if (this.augmentRancher && "machineRancher".equals(id)) {
            return false;
        }
        if (this.augmentPermamorb && "machinePermamorb".equals(id)) {
            return false;
        }
        return super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentExperience && "machineExperience".equals(id)) {
            this.augmentExperience = true;
            this.hasModeAugment = true;
            this.energyMod += 40;
            return true;
        }
        if (!this.augmentRancher && "machineRancher".equals(id)) {
            this.augmentRancher = true;
            this.hasModeAugment = true;
            this.energyMod += 40;
            return true;
        }
        if (!this.augmentPermamorb && "machinePermamorb".equals(id)) {
            this.augmentPermamorb = true;
            this.energyMod += 220;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == SLOT_ANIMAL_MORB) {
            return stack.func_77973_b() == TEItems.itemMorb;
        }
        if (Utils.isSlotInRange(slot, SLOT_TOOLS_START, SLOT_TOOLS_START + 4)) {
            return Utils.checkTool(stack, "sword") || stack.func_77973_b() instanceof ItemShears || stack.func_77973_b() == Items.field_151054_z || stack.func_77973_b() == Items.field_151133_ar;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentExperience && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentExperience && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileAnimalFarm.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !SideConfig.allowInsertion((int)((TileAnimalFarm)TileAnimalFarm.this).sideConfig.sideTypes[TileAnimalFarm.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    return TileAnimalFarm.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileAnimalFarm.this.isActive) {
                        return null;
                    }
                    return TileAnimalFarm.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileAnimalFarm.this.isActive) {
                        return null;
                    }
                    return TileAnimalFarm.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack stack) {
        this.updateOutputs = true;
    }

    @Override
    public IVirtualMachine getVirtualMachine() {
        return this.virtualAnimalFarm;
    }
}

