/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.block.machine;

import cofh.api.item.IAugmentItem;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import com.arcaratus.virtualmachines.VirtualMachines;
import com.arcaratus.virtualmachines.block.BlockVirtualMachine;
import com.arcaratus.virtualmachines.block.machine.TileVirtualMachine;
import com.arcaratus.virtualmachines.gui.client.machine.GuiFarm;
import com.arcaratus.virtualmachines.gui.container.machine.ContainerFarm;
import com.arcaratus.virtualmachines.utils.ComparableItemStack;
import com.arcaratus.virtualmachines.utils.Distribution;
import com.arcaratus.virtualmachines.utils.Utils;
import com.arcaratus.virtualmachines.virtual.IVirtualMachine;
import com.arcaratus.virtualmachines.virtual.VirtualFarm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class TileFarm
extends TileVirtualMachine {
    private static final int TYPE = BlockVirtualMachine.Type.FARM.getMetadata();
    public static int basePower = 40;
    public static final int SLOT_TOOLS_START = 18;
    public static final int SLOT_FARM_START = 23;
    public static final int SLOT_FERTILIZER = 22;
    public static final int SOIL_ENERGY_MOD = 10;
    public static final int MONOCULTURE_ENERGY_MOD = 40;
    private int inputTrackerPrimary;
    private int inputTrackerSecondary;
    private int outputTracker;
    public boolean lockPrimary = false;
    private List<ItemStack> itemLocks = new ArrayList<ItemStack>();
    private FluidTankCore tank = new FluidTankCore(25000);
    protected boolean augmentSoil;
    protected boolean augmentMonoculture;
    private VirtualFarm virtualFarm = new VirtualFarm();

    public static void init() {
        TileFarm.SIDE_CONFIGS[TileFarm.TYPE] = new SideConfig();
        TileFarm.SIDE_CONFIGS[TileFarm.TYPE].numConfig = 7;
        TileFarm.SIDE_CONFIGS[TileFarm.TYPE].slotGroups = new int[][]{new int[0], IntStream.range(18, 33).toArray(), IntStream.range(0, 18).toArray(), new int[0], IntStream.range(23, 33).toArray(), IntStream.range(18, 23).toArray(), IntStream.range(0, 33).toArray()};
        TileFarm.SIDE_CONFIGS[TileFarm.TYPE].sideTypes = new int[]{0, 1, 4, 7, 5, 6, 8};
        TileFarm.SIDE_CONFIGS[TileFarm.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileFarm.ALT_SIDE_CONFIGS[TileFarm.TYPE] = new SideConfig();
        TileFarm.ALT_SIDE_CONFIGS[TileFarm.TYPE].numConfig = 2;
        TileFarm.ALT_SIDE_CONFIGS[TileFarm.TYPE].slotGroups = new int[][]{new int[0], IntStream.range(18, 33).toArray(), IntStream.range(0, 18).toArray(), new int[0], IntStream.range(23, 33).toArray(), IntStream.range(18, 23).toArray(), IntStream.range(0, 33).toArray()};
        TileFarm.ALT_SIDE_CONFIGS[TileFarm.TYPE].sideTypes = new int[]{0, 7};
        TileFarm.ALT_SIDE_CONFIGS[TileFarm.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileFarm.SLOT_CONFIGS[TileFarm.TYPE] = new SlotConfig();
        TileFarm.SLOT_CONFIGS[TileFarm.TYPE].allowInsertionSlot = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        TileFarm.SLOT_CONFIGS[TileFarm.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false};
        TileFarm.VALID_AUGMENTS[TileFarm.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineFarmSoil");
        VALID_AUGMENTS[TYPE].add("machineInsolatorFertilizer");
        VALID_AUGMENTS[TYPE].add("machineInsolatorMonoculture");
        TileFarm.LIGHT_VALUES[TileFarm.TYPE] = 14;
        GameRegistry.registerTileEntity(TileFarm.class, (String)"virtualmachines:virtual_farm");
        TileFarm.config();
    }

    public static void config() {
        String category = "VirtualMachine.Farm";
        BlockVirtualMachine.enable[TileFarm.TYPE] = VirtualMachines.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Virtual Farm. This base value will scale with block level and Augments.";
        basePower = VirtualMachines.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileFarm.ENERGY_CONFIGS[TileFarm.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileFarm() {
        this.inventory = new ItemStack[33];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(FluidRegistry.WATER);
        for (int i = 0; i < 9; ++i) {
            this.itemLocks.add(ItemStack.field_190927_a);
        }
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    protected int calcEnergy() {
        return super.calcEnergy();
    }

    @Override
    protected boolean canStart() {
        if (!this.virtualFarm.getCurrentSeeds().stream().allMatch(ItemStack::func_190926_b)) {
            return true;
        }
        if (Utils.checkItemStackRange(this.inventory, 23, 32, ItemStack::func_190926_b)) {
            return false;
        }
        List<ItemStack> farm = Utils.arrayToListWithRange(this.inventory, 23, 32);
        List<VirtualFarm.IPlantHandler> currentPlantHandlers = this.virtualFarm.getPlantHandlers(farm);
        List<ItemStack> farmTools = Utils.arrayToListWithRange(this.inventory, 18, 22);
        if (farmTools.stream().allMatch(ItemStack::func_190926_b)) {
            return false;
        }
        ArrayList<ItemStack> lol = new ArrayList<ItemStack>();
        ArrayList<List<ItemStack>> omegaLUL = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < 9; ++i) {
            omegaLUL.add(i, new ArrayList());
            for (int j = 0; j < 4; ++j) {
                ((List)omegaLUL.get(i)).add(j, ItemStack.field_190927_a);
            }
            lol.add(i, ItemStack.field_190927_a);
            VirtualFarm.IPlantHandler plantHandler = currentPlantHandlers.get(i);
            ItemStack seed = farm.get(i);
            if (seed.func_190926_b() || plantHandler == null || !this.augmentSoil && !plantHandler.requiresDirt(seed)) continue;
            if (this.tank.getFluidAmount() < plantHandler.waterRequired(seed) || this.energyStorage.getEnergyStored() < plantHandler.energyRequired(seed)) {
                return false;
            }
            List<Pair<Distribution, ItemStack>> outputs = plantHandler.getOutput(seed, farmTools);
            if (outputs.isEmpty() || !Utils.canFitOutputs((IInventory)this, outputs.stream().map(Pair::getRight).collect(Collectors.toList()), 0, 18)) {
                return false;
            }
            ItemStack seedCopy = seed.func_77946_l();
            lol.set(i, seedCopy);
            ArrayList<ItemStack> OMEGALUL = new ArrayList<ItemStack>();
            for (int j = 0; j < 4; ++j) {
                if (j < plantHandler.getTools().size()) {
                    OMEGALUL.add(j, plantHandler.getTools().get(j).func_77946_l());
                    continue;
                }
                OMEGALUL.add(j, ItemStack.field_190927_a);
            }
            omegaLUL.add(i, OMEGALUL);
            if (this.augmentMonoculture) continue;
            seed.func_190918_g(1);
        }
        this.virtualFarm.setCurrentSeeds(lol);
        this.virtualFarm.setCurrentTools(omegaLUL);
        return true;
    }

    @Override
    protected boolean hasValidInput() {
        List<ItemStack> farmTools = Utils.arrayToListWithRange(this.inventory, 18, 22);
        return !farmTools.stream().allMatch(ItemStack::func_190926_b);
    }

    @Override
    protected void processStart() {
        VirtualFarm.IItemFertilizerHandler fertilizerHandler;
        double maxProcess = 8000.0;
        for (int i = 0; i < 9; ++i) {
            VirtualFarm.IPlantHandler plantHandler = this.virtualFarm.getCurrentPlantHandlers().get(i);
            ItemStack seed = this.virtualFarm.getCurrentSeeds().get(i);
            if (seed.func_190926_b() || plantHandler == null) continue;
            maxProcess += (double)plantHandler.energyRequired(seed);
            if (!this.augmentMonoculture) continue;
            this.energyMod += 40;
        }
        maxProcess *= (double)this.energyMod;
        maxProcess /= 100.0;
        ItemStack fertilizerStack = this.func_70301_a(22);
        if (!fertilizerStack.func_190926_b() && (fertilizerHandler = VirtualFarm.getItemFertilizerHandler(fertilizerStack)) != null) {
            maxProcess /= (double)fertilizerHandler.getGrowthMultiplier(fertilizerStack);
            if (this.reuseChance > 0) {
                if (this.field_145850_b.field_73012_v.nextInt(100) >= this.reuseChance) {
                    fertilizerStack.func_190918_g(1);
                }
            } else {
                fertilizerStack.func_190918_g(1);
            }
        }
        this.processRem = this.processMax = (int)maxProcess;
    }

    @Override
    protected void processFinish() {
        List<ItemStack> farm = this.virtualFarm.getCurrentSeeds();
        List<VirtualFarm.IPlantHandler> currentPlantHandlers = this.virtualFarm.getCurrentPlantHandlers();
        List<ItemStack> farmTools = Utils.arrayToListWithRange(this.inventory, 18, 22);
        for (int i = 0; i < 9; ++i) {
            VirtualFarm.IPlantHandler plantHandler = currentPlantHandlers.get(i);
            ItemStack seed = farm.get(i);
            if (seed.func_190926_b() || plantHandler == null) continue;
            List<Pair<Distribution, ItemStack>> outputs = plantHandler.getOutput(seed, farmTools);
            if (!outputs.isEmpty()) {
                for (Pair<Distribution, ItemStack> p : outputs) {
                    ItemStack output = new ItemStack(((ItemStack)p.getRight()).func_77973_b(), ((Distribution)p.getLeft()).getOutput(), ((ItemStack)p.getRight()).func_77960_j());
                    if (this.augmentMonoculture && output.func_77969_a(seed)) {
                        output.func_190918_g(2);
                    }
                    if (output.func_190926_b()) continue;
                    List<ItemStack> tools = this.virtualFarm.getCurrentTools().get(i);
                    for (int itx = 18; itx < 22; ++itx) {
                        if (tools.get(itx - 18).func_190926_b() || !tools.get(itx - 18).func_185136_b(this.func_70301_a(itx))) continue;
                        boolean isLeaves = new ComparableItemStack(output).equals(new ComparableItemStack(new ItemStack((Block)Blocks.field_150362_t)));
                        ItemStack tool = this.func_70301_a(itx);
                        if (isLeaves && !Utils.checkTool(tool, "shears") || this.func_70301_a(itx).func_77973_b() != tool.func_77973_b()) continue;
                        ItemStack s = tool.func_77946_l();
                        s = Utils.damageItem(s, Utils.checkTool(s, "hoe", "sickle") ? 1 : output.func_190916_E(), this.field_145850_b.field_73012_v);
                        this.func_70299_a(itx, s);
                        tools.remove(tool);
                    }
                    Utils.distributeOutput((IInventory)this, output, 0, 18);
                }
                this.tank.modifyFluidStored(-plantHandler.waterRequired(seed));
            }
            plantHandler.clearTools();
        }
        this.virtualFarm.clear();
    }

    @Override
    protected void transferInput() {
        int slot;
        int side;
        int i;
        if (!this.enableAutoInput) {
            return;
        }
        block0: for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            for (slot = 23; slot < 32; ++slot) {
                if (!this.extractItem(slot, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.inputTrackerPrimary = side;
                continue block0;
            }
        }
        block2: for (i = this.inputTrackerSecondary + 1; i <= this.inputTrackerSecondary + 6; ++i) {
            side = i % 6;
            for (slot = 18; slot < 23; ++slot) {
                if (!this.extractItem(slot, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.inputTrackerSecondary = side;
                continue block2;
            }
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (Utils.checkItemStackRange(this.inventory, 0, 18, ItemStack::func_190926_b)) {
            return;
        }
        block0: for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            for (int slot = 0; slot < 18; ++slot) {
                if (!this.transferItem(slot, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTracker = side;
                continue block0;
            }
        }
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        this.lockPrimary = tag.func_74767_n("SlotLock");
        NBTTagList list = tag.func_150295_c("ItemLocks", 10);
        for (int i = 0; i < 9; ++i) {
            this.itemLocks.set(i, new ItemStack(list.func_150305_b(i)));
        }
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74757_a("SlotLock", this.lockPrimary);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound t = new NBTTagCompound();
            this.itemLocks.get(i).func_77955_b(t);
            list.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("ItemLocks", (NBTBase)list);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFarm(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerFarm(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void setMode(boolean mode) {
        boolean lastMode = this.lockPrimary;
        this.lockPrimary = mode;
        if (mode) {
            for (int i = 23; i < 32; ++i) {
                this.itemLocks.set(i - 23, this.func_70301_a(i));
            }
        } else {
            this.itemLocks = this.itemLocks.stream().map(s -> {
                s = ItemStack.field_190927_a;
                return s;
            }).collect(Collectors.toList());
        }
        this.sendModePacket();
        this.lockPrimary = lastMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTrackerPrimary = nbt.func_74762_e("TrackIn1");
        this.inputTrackerSecondary = nbt.func_74762_e("TrackIn2");
        this.outputTracker = nbt.func_74762_e("TrackOut1");
        this.lockPrimary = nbt.func_74767_n("SlotLock");
        NBTTagList list = nbt.func_150295_c("ItemLocks", 10);
        for (int i = 0; i < 9; ++i) {
            this.itemLocks.set(i, new ItemStack(list.func_150305_b(i)));
        }
        this.tank.readFromNBT(nbt);
        this.virtualFarm.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn1", this.inputTrackerPrimary);
        nbt.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nbt.func_74768_a("TrackOut1", this.outputTracker);
        nbt.func_74757_a("SlotLock", this.lockPrimary);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            this.itemLocks.get(i).func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ItemLocks", (NBTBase)list);
        this.tank.writeToNBT(nbt);
        this.virtualFarm.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addBool(this.lockPrimary);
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            this.itemLocks.get(i).func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ItemLocks", (NBTBase)list);
        try {
            payload.writeNBT(nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.lockPrimary = payload.getBool();
        try {
            NBTTagCompound nbt = payload.readNBT();
            NBTTagList list = nbt.func_150295_c("ItemLocks", 10);
            for (int i = 0; i < 9; ++i) {
                this.itemLocks.set(i, new ItemStack(list.func_150305_b(i)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.callNeighborTileChange();
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.lockPrimary);
        payload.addFluidStack(this.tank.getFluid());
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            this.itemLocks.get(i).func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ItemLocks", (NBTBase)list);
        try {
            payload.writeNBT(nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.lockPrimary = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
        try {
            NBTTagCompound nbt = payload.readNBT();
            NBTTagList list = nbt.func_150295_c("ItemLocks", 10);
            for (int i = 0; i < 9; ++i) {
                this.itemLocks.set(i, new ItemStack(list.func_150305_b(i)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentSoil = false;
        this.augmentMonoculture = false;
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (this.augmentSoil && "machineFarmSoil".equals(id)) {
            return false;
        }
        if (this.augmentMonoculture && "machineInsolatorMonoculture".equals(id)) {
            return false;
        }
        return super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("machineInsolatorFertilizer".equals(id)) {
            this.reuseChance += 20;
            this.energyMod += 10;
        }
        if (!this.augmentSoil && "machineFarmSoil".equals(id)) {
            this.augmentSoil = true;
            this.energyMod += 10;
            return true;
        }
        if (!this.augmentMonoculture && "machineInsolatorMonoculture".equals(id)) {
            this.augmentMonoculture = true;
            this.hasModeAugment = true;
            this.reuseChance += 10;
            this.energyMod += 10;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (Utils.isSlotInRange(slot, 18, 22)) {
            return Utils.checkTool(stack, "axe", "shears", "hoe", "sickle");
        }
        if (slot == 22) {
            return VirtualFarm.isFertilizer(stack);
        }
        if (Utils.isSlotInRange(slot, 23, 32)) {
            return InsolatorManager.isItemValid((ItemStack)stack) && (!this.lockPrimary || stack.func_77969_a(this.itemLocks.get(slot - 23)));
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileFarm.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !SideConfig.allowInsertion((int)((TileFarm)TileFarm.this).sideConfig.sideTypes[TileFarm.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    return TileFarm.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileFarm.this.isActive) {
                        return null;
                    }
                    return TileFarm.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileFarm.this.isActive) {
                        return null;
                    }
                    return TileFarm.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack stack) {
        if (this.lockPrimary && Utils.isSlotInRange(slot, 23, 32) && this.itemLocks.get(slot - 23).func_190926_b()) {
            this.itemLocks.set(slot - 23, stack);
            this.sendModePacket();
        }
    }

    @Override
    public IVirtualMachine getVirtualMachine() {
        return this.virtualFarm;
    }

    public List<ItemStack> getItemLocks() {
        return this.itemLocks;
    }
}

