/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.thermalexpansion.util.managers.device.FisherManager;
import com.arcaratus.virtualmachines.VirtualMachines;
import com.arcaratus.virtualmachines.block.BlockVirtualMachine;
import com.arcaratus.virtualmachines.block.machine.TileVirtualMachine;
import com.arcaratus.virtualmachines.gui.client.machine.GuiFishery;
import com.arcaratus.virtualmachines.gui.container.machine.ContainerFishery;
import com.arcaratus.virtualmachines.utils.Utils;
import com.arcaratus.virtualmachines.virtual.IVirtualMachine;
import com.arcaratus.virtualmachines.virtual.VirtualFishery;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileFishery
extends TileVirtualMachine {
    private static final int TYPE = BlockVirtualMachine.Type.FISHERY.getMetadata();
    public static int basePower = 50;
    public static int baseFluid = 1000;
    public static final int SLOT_FISHING_ROD = 0;
    public static final int SLOT_BAIT = 1;
    public static final int SLOT_OUTPUT_START = 2;
    private int inputTracker;
    private int outputTracker;
    private FluidTankCore tank = new FluidTankCore(10000);
    private boolean updateOutputs = true;
    private VirtualFishery virtualFishery = new VirtualFishery();

    public static void init() {
        TileFishery.SIDE_CONFIGS[TileFishery.TYPE] = new SideConfig();
        TileFishery.SIDE_CONFIGS[TileFishery.TYPE].numConfig = 5;
        TileFishery.SIDE_CONFIGS[TileFishery.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, IntStream.range(2, 11).toArray(), {0}, {1}, new int[0], IntStream.range(0, 12).toArray()};
        TileFishery.SIDE_CONFIGS[TileFishery.TYPE].sideTypes = new int[]{0, 1, 4, 5, 6, 7, 8};
        TileFishery.SIDE_CONFIGS[TileFishery.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileFishery.ALT_SIDE_CONFIGS[TileFishery.TYPE] = new SideConfig();
        TileFishery.ALT_SIDE_CONFIGS[TileFishery.TYPE].numConfig = 2;
        TileFishery.ALT_SIDE_CONFIGS[TileFishery.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, IntStream.range(2, 11).toArray(), {0}, {1}, new int[0], IntStream.range(0, 12).toArray()};
        TileFishery.ALT_SIDE_CONFIGS[TileFishery.TYPE].sideTypes = new int[]{0, 7};
        TileFishery.ALT_SIDE_CONFIGS[TileFishery.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileFishery.SLOT_CONFIGS[TileFishery.TYPE] = new SlotConfig();
        TileFishery.SLOT_CONFIGS[TileFishery.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false, false, false, false, false, false, false, false};
        TileFishery.SLOT_CONFIGS[TileFishery.TYPE].allowExtractionSlot = new boolean[]{false, false, true, true, true, true, true, true, true, true, true};
        TileFishery.VALID_AUGMENTS[TileFishery.TYPE] = new HashSet();
        TileFishery.LIGHT_VALUES[TileFishery.TYPE] = 14;
        GameRegistry.registerTileEntity(TileFishery.class, (String)"virtualmachines:virtual_fishery");
        TileFishery.config();
    }

    public static void config() {
        String category = "VirtualMachine.Fishery";
        BlockVirtualMachine.enable[TileFishery.TYPE] = VirtualMachines.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Virtual Fishery. This base value will scale with block level and Augments.";
        basePower = VirtualMachines.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileFishery.ENERGY_CONFIGS[TileFishery.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileFishery() {
        this.inventory = new ItemStack[12];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    protected int calcEnergy() {
        return super.calcEnergy();
    }

    @Override
    protected boolean canStart() {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        List outputs = this.virtualFishery.getOutputs();
        if (this.updateOutputs) {
            outputs.clear();
            ItemStack rodStack = this.func_70301_a(0);
            LootContext.Builder lootContext = new LootContext.Builder((WorldServer)this.field_145850_b);
            lootContext.func_186469_a((float)EnchantmentHelper.func_191529_b((ItemStack)rodStack));
            outputs = this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_145850_b.field_73012_v, lootContext.func_186471_a());
            this.virtualFishery.setOutputs(outputs);
            this.updateOutputs = false;
        }
        return !outputs.isEmpty() && Utils.canFitOutputs((IInventory)this, outputs, 2, 11);
    }

    @Override
    protected boolean hasValidInput() {
        return true;
    }

    @Override
    protected void processStart() {
        double maxProcess = 18000.0;
        ItemStack baitStack = this.func_70301_a(1);
        if (!baitStack.func_190926_b()) {
            maxProcess /= (double)FisherManager.getBaitMultiplier((ItemStack)baitStack);
            baitStack.func_190918_g(1);
        }
        this.processRem = this.processMax = (int)maxProcess;
    }

    @Override
    protected void processFinish() {
        ItemStack rodStack = this.func_70301_a(0);
        List<ItemStack> outputs = this.virtualFishery.getOutputs();
        for (ItemStack itemStack : outputs) {
            ItemStack damagedRodStack = rodStack;
            damagedRodStack = Utils.damageItem(damagedRodStack, 1, this.field_145850_b.field_73012_v);
            this.func_70299_a(0, damagedRodStack);
            Utils.distributeOutput((IInventory)this, itemStack, 2, 11);
        }
        this.tank.modifyFluidStored(-baseFluid);
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) {
                this.inputTracker = side;
                break;
            }
            if (!this.extractItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (Utils.checkItemStackRange(this.inventory, 2, 11, ItemStack::func_190926_b)) {
            return;
        }
        block0: for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            for (int slot = 2; slot < 11; ++slot) {
                if (!this.transferItem(slot, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTracker = side;
                continue block0;
            }
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFishery(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerFishery(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.updateOutputs = nbt.func_74767_n("UpdateOutputs");
        this.tank.readFromNBT(nbt);
        this.virtualFishery.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74757_a("UpdateOutputs", this.updateOutputs);
        this.tank.writeToNBT(nbt);
        this.virtualFishery.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        return super.getModePacket();
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 ? Utils.checkTool(stack, "fishing_rod") : slot != 1 || FisherManager.isValidBait((ItemStack)stack);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileFishery.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !SideConfig.allowInsertion((int)((TileFishery)TileFishery.this).sideConfig.sideTypes[TileFishery.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    return TileFishery.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileFishery.this.isActive) {
                        return null;
                    }
                    return TileFishery.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileFishery.this.isActive) {
                        return null;
                    }
                    return TileFishery.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack stack) {
        this.updateOutputs = true;
    }

    @Override
    public IVirtualMachine getVirtualMachine() {
        return this.virtualFishery;
    }
}

