/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.block.machine;

import cofh.api.item.IAugmentItem;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.init.TEItems;
import cofh.thermalexpansion.item.ItemMorb;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalfoundation.init.TFFluids;
import com.arcaratus.virtualmachines.VirtualMachines;
import com.arcaratus.virtualmachines.block.BlockVirtualMachine;
import com.arcaratus.virtualmachines.block.machine.TileVirtualMachine;
import com.arcaratus.virtualmachines.gui.client.machine.GuiMobFarm;
import com.arcaratus.virtualmachines.gui.container.machine.ContainerMobFarm;
import com.arcaratus.virtualmachines.utils.Utils;
import com.arcaratus.virtualmachines.virtual.IVirtualMachine;
import com.arcaratus.virtualmachines.virtual.VirtualMobFarm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileMobFarm
extends TileVirtualMachine {
    private static final int TYPE = BlockVirtualMachine.Type.MOB_FARM.getMetadata();
    public static int basePower = 200;
    public static int SLOT_SWORD = 0;
    public static int SLOT_MORB_START = 1;
    public static int SLOT_OUTPUT_START = 10;
    public static final int EXPERIENCE_MOD = 80;
    public static final int PERMAMORB_MOD = 220;
    public static final int EXPERIENCE = 50;
    private int inputTracker;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(50000);
    private boolean updateOutputs = true;
    public VirtualMobFarm virtualMobFarm = new VirtualMobFarm();
    protected boolean augmentExperience;
    protected boolean flagExperience;
    protected boolean augmentPermamorb;

    public static void init() {
        TileMobFarm.SIDE_CONFIGS[TileMobFarm.TYPE] = new SideConfig();
        TileMobFarm.SIDE_CONFIGS[TileMobFarm.TYPE].numConfig = 5;
        TileMobFarm.SIDE_CONFIGS[TileMobFarm.TYPE].slotGroups = new int[][]{new int[0], IntStream.range(SLOT_SWORD, SLOT_MORB_START + 9).toArray(), IntStream.range(SLOT_OUTPUT_START, SLOT_OUTPUT_START + 18).toArray(), {SLOT_SWORD}, IntStream.range(SLOT_MORB_START, SLOT_MORB_START + 9).toArray(), new int[0], IntStream.range(SLOT_SWORD, SLOT_OUTPUT_START + 18).toArray()};
        TileMobFarm.SIDE_CONFIGS[TileMobFarm.TYPE].sideTypes = new int[]{0, 1, 4, 5, 6, 7, 8};
        TileMobFarm.SIDE_CONFIGS[TileMobFarm.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileMobFarm.ALT_SIDE_CONFIGS[TileMobFarm.TYPE] = new SideConfig();
        TileMobFarm.ALT_SIDE_CONFIGS[TileMobFarm.TYPE].numConfig = 2;
        TileMobFarm.ALT_SIDE_CONFIGS[TileMobFarm.TYPE].slotGroups = new int[][]{new int[0], IntStream.range(SLOT_SWORD, SLOT_MORB_START + 9).toArray(), IntStream.range(SLOT_OUTPUT_START, SLOT_OUTPUT_START + 18).toArray(), {SLOT_SWORD}, IntStream.range(SLOT_MORB_START, SLOT_MORB_START + 9).toArray(), new int[0], IntStream.range(SLOT_SWORD, SLOT_OUTPUT_START + 18).toArray()};
        TileMobFarm.ALT_SIDE_CONFIGS[TileMobFarm.TYPE].sideTypes = new int[]{0, 7};
        TileMobFarm.ALT_SIDE_CONFIGS[TileMobFarm.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileMobFarm.SLOT_CONFIGS[TileMobFarm.TYPE] = new SlotConfig();
        TileMobFarm.SLOT_CONFIGS[TileMobFarm.TYPE].allowInsertionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false};
        TileMobFarm.SLOT_CONFIGS[TileMobFarm.TYPE].allowExtractionSlot = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        TileMobFarm.VALID_AUGMENTS[TileMobFarm.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineExperience");
        VALID_AUGMENTS[TYPE].add("machinePermamorb");
        TileMobFarm.LIGHT_VALUES[TileMobFarm.TYPE] = 14;
        GameRegistry.registerTileEntity(TileMobFarm.class, (String)"virtualmachines:virtual_mob_farm");
        TileMobFarm.config();
    }

    public static void config() {
        String category = "VirtualMachine.MobFarm";
        BlockVirtualMachine.enable[TileMobFarm.TYPE] = VirtualMachines.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Virtual Mob Farm. This base value will scale with block level and Augments.";
        basePower = VirtualMachines.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileMobFarm.ENERGY_CONFIGS[TileMobFarm.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileMobFarm() {
        this.inventory = new ItemStack[29];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidExperience);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
    }

    @Override
    protected int calcEnergy() {
        return super.calcEnergy();
    }

    @Override
    protected boolean canStart() {
        if (this.func_70301_a(SLOT_SWORD).func_190926_b()) {
            return false;
        }
        if (Utils.checkItemStackRange(this.inventory, SLOT_MORB_START, SLOT_MORB_START + 9, ItemStack::func_190926_b)) {
            return false;
        }
        List<ItemStack> outputs = this.virtualMobFarm.getOutputs();
        if (this.updateOutputs) {
            outputs.clear();
            for (int slot = SLOT_MORB_START; slot < SLOT_MORB_START + 9; ++slot) {
                ItemStack morbStack = this.func_70301_a(slot);
                CentrifugeManager.CentrifugeRecipe recipe = CentrifugeManager.getRecipeMob((ItemStack)morbStack);
                if (recipe == null) {
                    if (slot != SLOT_MORB_START + 9) continue;
                    return false;
                }
                List recipeOutputs = recipe.getOutput();
                List chances = recipe.getChance();
                ArrayList<ItemStack> tempOutputs = new ArrayList<ItemStack>();
                for (int i = 0; i < recipeOutputs.size(); ++i) {
                    for (int j = 0; j < ((ItemStack)recipeOutputs.get(i)).func_190916_E(); ++j) {
                        if (this.field_145850_b.field_73012_v.nextInt(this.secondaryChance + j * 10) >= (Integer)chances.get(i)) continue;
                        int itx = i;
                        if (tempOutputs.stream().findFirst().filter(s -> s.func_77973_b() == ((ItemStack)recipeOutputs.get(itx)).func_77973_b()).isPresent()) {
                            tempOutputs.stream().findFirst().filter(s -> ItemStack.func_179545_c((ItemStack)s, (ItemStack)((ItemStack)recipeOutputs.get(itx)))).ifPresent(s -> s.func_190917_f(1));
                            continue;
                        }
                        tempOutputs.add(ItemHelper.cloneStack((ItemStack)((ItemStack)recipeOutputs.get(i)), (int)1));
                    }
                }
                if (!this.augmentPermamorb) {
                    ItemStack morbOutput = ItemStack.func_179545_c((ItemStack)this.func_70301_a(slot), (ItemStack)ItemMorb.morbStandard) ? ItemMorb.morbStandard.func_77946_l() : ItemMorb.morbReusable.func_77946_l();
                    this.func_70299_a(slot, morbOutput);
                }
                tempOutputs.removeIf(s -> s.func_77973_b() == TEItems.itemMorb);
                tempOutputs.forEach(stack -> {
                    float f = (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)this.func_70301_a(SLOT_SWORD)) * this.field_145850_b.field_73012_v.nextFloat();
                    stack.func_190917_f(Math.round(f));
                });
                outputs.addAll(tempOutputs);
            }
            this.virtualMobFarm.setOutputs(outputs);
            this.updateOutputs = false;
        }
        return !outputs.isEmpty() && Utils.canFitOutputs((IInventory)this, outputs, SLOT_OUTPUT_START, SLOT_OUTPUT_START + 9);
    }

    @Override
    protected boolean hasValidInput() {
        return Utils.checkTool(this.func_70301_a(SLOT_SWORD), "sword");
    }

    @Override
    protected void processStart() {
        double maxProcess = 32000.0;
        for (int i = SLOT_MORB_START; i < SLOT_MORB_START + 9; ++i) {
            ItemStack morbStack = this.func_70301_a(i);
            if (morbStack.func_190926_b() || CentrifugeManager.getRecipeMob((ItemStack)morbStack) == null) continue;
            maxProcess += 4000.0;
        }
        this.processRem = this.processMax = (int)maxProcess;
    }

    @Override
    protected void processFinish() {
        List<ItemStack> outputs = this.virtualMobFarm.getOutputs();
        int damage = 0;
        for (ItemStack itemStack : outputs) {
            Utils.distributeOutput((IInventory)this, itemStack, SLOT_OUTPUT_START, SLOT_OUTPUT_START + 9);
            ++damage;
        }
        ItemStack damagedSwordStack = this.func_70301_a(SLOT_SWORD);
        damagedSwordStack = Utils.damageItem(damagedSwordStack, damage, this.field_145850_b.field_73012_v);
        this.func_70299_a(SLOT_SWORD, damagedSwordStack);
        if (this.augmentExperience && damage > 0) {
            this.tank.fill(new FluidStack(TFFluids.fluidExperience, (int)((double)Math.round(this.field_145850_b.field_73012_v.nextGaussian() * 25.0 + 50.0) * (double)outputs.size() / 3.0)), true);
        }
        this.updateOutputs = true;
    }

    @Override
    protected void transferInput() {
        if (!this.enableAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.extractItem(SLOT_SWORD, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.augmentExperience) {
            this.transferOutputFluid();
        }
        if (Utils.checkItemStackRange(this.inventory, SLOT_OUTPUT_START, SLOT_OUTPUT_START + 18, ItemStack::func_190926_b)) {
            return;
        }
        block0: for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            for (int slot = SLOT_OUTPUT_START; slot < SLOT_OUTPUT_START + 18; ++slot) {
                if (!this.transferItem(slot, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTracker = side;
                continue block0;
            }
        }
    }

    private void transferOutputFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiMobFarm(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerMobFarm(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentExperience() {
        return this.augmentExperience && this.flagExperience;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOutFluid");
        this.updateOutputs = nbt.func_74767_n("UpdateOutputs");
        this.tank.readFromNBT(nbt);
        this.virtualMobFarm.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("TrackOutFluid", this.outputTrackerFluid);
        nbt.func_74757_a("UpdateOutputs", this.updateOutputs);
        this.tank.writeToNBT(nbt);
        this.virtualMobFarm.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        return super.getModePacket();
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentExperience);
        payload.addFluidStack(this.tank.getFluid());
        payload.addBool(this.augmentPermamorb);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.flagExperience = this.augmentExperience = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
        this.augmentPermamorb = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentExperience = false;
        this.augmentPermamorb = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentExperience) {
            this.tank.clearLocked();
            this.tank.setFluid(null);
        }
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (this.augmentExperience && "machineExperience".equals(id)) {
            return false;
        }
        if (this.augmentPermamorb && "machinePermamorb".equals(id)) {
            return false;
        }
        return super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentExperience && "machineExperience".equals(id)) {
            this.augmentExperience = true;
            this.hasModeAugment = true;
            this.energyMod += 80;
            return true;
        }
        if (!this.augmentPermamorb && "machinePermamorb".equals(id)) {
            this.augmentPermamorb = true;
            this.energyMod += 220;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == SLOT_SWORD) {
            return Utils.checkTool(stack, "sword");
        }
        if (Utils.isSlotInRange(slot, SLOT_MORB_START, SLOT_MORB_START + 9)) {
            return stack.func_77973_b() == TEItems.itemMorb;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentExperience && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentExperience && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileMobFarm.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !SideConfig.allowInsertion((int)((TileMobFarm)TileMobFarm.this).sideConfig.sideTypes[TileMobFarm.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    return TileMobFarm.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileMobFarm.this.isActive) {
                        return null;
                    }
                    return TileMobFarm.this.tank.drain(resource, doDrain);
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileMobFarm.this.isActive) {
                        return null;
                    }
                    return TileMobFarm.this.tank.drain(maxDrain, doDrain);
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack stack) {
        this.updateOutputs = true;
    }

    @Override
    public IVirtualMachine getVirtualMachine() {
        return this.virtualMobFarm;
    }
}

