/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.gui.client;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GhostItemRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private RenderItem render;
    private final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private final ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
    private float zLevel = 0.0f;

    public GhostItemRenderer(RenderItem render) {
        this.render = render;
    }

    public static void renderItemInGui(RenderItem render, ItemStack stack, int x, int y, float alpha) {
        new GhostItemRenderer(render).renderItemInGui(stack, x, y, alpha);
    }

    public void renderItemInGui(ItemStack stack, int x, int y, float alpha) {
        if (!stack.func_190926_b()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.zLevel += 50.0f;
            try {
                this.renderItemModelIntoGUI(stack, x, y, this.getItemModelWithOverrides(stack, null, (EntityLivingBase)player), alpha);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.zLevel -= 50.0f;
        }
    }

    public IBakedModel getItemModelWithOverrides(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entitylivingbaseIn) {
        IBakedModel ibakedmodel = this.render.func_175037_a().func_178089_a(stack);
        return ibakedmodel.func_188617_f().handleItemState(ibakedmodel, stack, worldIn, entitylivingbaseIn);
    }

    public void renderItemModelIntoGUI(ItemStack stack, int x, int y, IBakedModel bakedModel, float alpha) {
        GlStateManager.func_179094_E();
        this.textureManager.func_110577_a(TextureMap.field_110575_b);
        this.textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.setupGuiTransform(x, y, bakedModel.func_177556_c());
        IBakedModel finalModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        this.renderItem(stack, finalModel, alpha);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        this.textureManager.func_110577_a(TextureMap.field_110575_b);
        this.textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    public void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d) {
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)(100.0f + this.zLevel));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    public void renderItem(ItemStack stack, IBakedModel model, float alpha) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179091_B();
                TileEntityItemStackRenderer.field_147719_a.func_179022_a(stack);
            } else {
                this.renderModel(model, stack, alpha);
                if (stack.func_77962_s()) {
                    this.renderEffect(model);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private void renderEffect(IBakedModel model) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020, 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020, 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        this.textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    private void renderModel(IBakedModel model, ItemStack stack, float alpha) {
        this.renderModel(model, ((int)(alpha * 255.0f) << 24) + 0xFFFFFF, stack, alpha);
    }

    private void renderModel(IBakedModel model, int color, float alpha) {
        this.renderModel(model, color, ItemStack.field_190927_a, alpha);
    }

    private void renderModel(IBakedModel model, int color, ItemStack stack, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(bufferbuilder, model.func_188616_a(null, enumfacing, 0L), color, stack, alpha);
        }
        this.renderQuads(bufferbuilder, model.func_188616_a(null, null, 0L), color, stack, alpha);
        tessellator.func_78381_a();
    }

    private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack, float alpha) {
        boolean flag = !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = this.itemColors.func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k = ((int)(alpha * 255.0f) << 24) + (k | 0xFF000000);
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }
}

