/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.item;

import cofh.api.core.IAugmentable;
import cofh.api.core.ISecurable;
import cofh.api.item.IAugmentItem;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.item.ItemMorb;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.tome.ItemTomeExperience;
import com.arcaratus.virtualmachines.VirtualMachines;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemAugment
extends ItemMulti
implements IInitializer,
IAugmentItem {
    private TIntObjectHashMap<AugmentEntry> augmentMap = new TIntObjectHashMap();
    public static ItemStack machine_farm_soil;
    public static ItemStack machine_experience;
    public static ItemStack machine_nether;
    public static ItemStack machine_rancher;
    public static ItemStack machine_permamorb;
    public static ItemStack machine_morb_capture;

    public ItemAugment() {
        super("virtualmachines");
        this.func_77655_b("augment");
        this.func_77637_a(VirtualMachines.TAB_VIRTUAL_MACHINES);
    }

    public String func_77653_i(ItemStack stack) {
        return StringHelper.localize((String)"info.thermalexpansion.augment.0") + ": " + super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        IAugmentItem.AugmentType type = this.getAugmentType(stack);
        String id = this.getAugmentIdentifier(stack);
        if (id.isEmpty()) {
            return;
        }
        int i = 0;
        String line = "info.virtualmachines.augment." + id + "." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add(StringHelper.localize((String)line));
            line = "info.virtualmachines.augment." + id + "." + ++i;
        }
        i = 0;
        line = "info.virtualmachines.augment." + id + ".a." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a7a" + StringHelper.localize((String)line));
            line = "info.virtualmachines.augment." + id + ".a." + ++i;
        }
        i = 0;
        line = "info.virtualmachines.augment." + id + ".b." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a74" + StringHelper.localize((String)line));
            line = "info.virtualmachines.augment." + id + ".b." + ++i;
        }
        i = 0;
        line = "info.virtualmachines.augment." + id + ".c." + i;
        while (StringHelper.canLocalize((String)line)) {
            tooltip.add("\u00a7e" + StringHelper.localize((String)line));
            line = "info.virtualmachines.augment." + id + ".c." + ++i;
        }
        switch (type) {
            case ADVANCED: {
                break;
            }
            case MODE: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeMode"));
                break;
            }
            case ENDER: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeEnder"));
                break;
            }
            case CREATIVE: {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.augment.noticeCreative"));
                break;
            }
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.hasTileEntity(state)) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return EnumActionResult.PASS;
        }
        if (tile instanceof IAugmentable) {
            if (((IAugmentable)tile).getAugmentSlots().length <= 0) {
                return EnumActionResult.PASS;
            }
            if (ServerHelper.isServerWorld((World)world)) {
                if (((IAugmentable)tile).installAugment(stack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.4f, 0.8f);
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalfoundation.augment.install.success", new Object[0]));
                } else {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalfoundation.augment.install.failure", new Object[0]));
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public IAugmentItem.AugmentType getAugmentType(ItemStack stack) {
        if (!this.augmentMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return IAugmentItem.AugmentType.CREATIVE;
        }
        return ((AugmentEntry)this.augmentMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).type;
    }

    public String getAugmentIdentifier(ItemStack stack) {
        if (!this.augmentMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return "";
        }
        return ((AugmentEntry)this.augmentMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).identifier;
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("augment"));
        VirtualMachines.proxy.addIModelRegister((IModelRegister)this);
        int metadata = 1024;
        machine_farm_soil = this.addAugmentItem(metadata++, "machineFarmSoil", IAugmentItem.AugmentType.ADVANCED);
        machine_experience = this.addAugmentItem(metadata++, "machineExperience", IAugmentItem.AugmentType.MODE);
        machine_nether = this.addAugmentItem(metadata++, "machineNether", IAugmentItem.AugmentType.ADVANCED);
        machine_rancher = this.addAugmentItem(metadata++, "machineRancher", IAugmentItem.AugmentType.MODE);
        machine_permamorb = this.addAugmentItem(metadata++, "machinePermamorb", IAugmentItem.AugmentType.ADVANCED);
        machine_morb_capture = this.addAugmentItem(metadata++, "machineMorbCapture", IAugmentItem.AugmentType.MODE);
        return true;
    }

    public boolean initialize() {
        String category = "Item.Augment";
        String comment = "If TRUE, the recipe for the Virtual Farm's Soil Virtualization is enabled.";
        boolean enableAugmentFarmSoil = VirtualMachines.CONFIG.getConfiguration().getBoolean("AugmentFarmSoil", category, true, comment);
        comment = "If TRUE, the recipe for the Experience Accumulator is enabled.";
        boolean enableAugmentExp = VirtualMachines.CONFIG.getConfiguration().getBoolean("AugmentExpAccumulator", category, true, comment);
        comment = "If TRUE, the recipe for the Nether Simulator is enabled.";
        boolean enableAugmentNether = VirtualMachines.CONFIG.getConfiguration().getBoolean("AugmentNether", category, true, comment);
        comment = "If TRUE, the recipe for the Industrialized Rancher is enabled.";
        boolean enableAugmentRancher = VirtualMachines.CONFIG.getConfiguration().getBoolean("AugmentRancher", category, true, comment);
        comment = "If TRUE, the recipe for the Perma-Morb Inducer is enabled.";
        boolean enableAugmentPermamorb = VirtualMachines.CONFIG.getConfiguration().getBoolean("AugmentPermamorb", category, true, comment);
        comment = "If TRUE, the recipe for the Morb Capture is enabled.";
        boolean enableAugmentMorbCapture = VirtualMachines.CONFIG.getConfiguration().getBoolean("AugmentMorbCapture", category, true, comment);
        if (enableAugmentFarmSoil) {
            RecipeHelper.addShapedRecipe((ItemStack)machine_farm_soil, (Object[])new Object[]{" G ", "PCP", "DSE", Character.valueOf('G'), "gearConstantan", Character.valueOf('P'), "plateInvar", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('D'), "dirt", Character.valueOf('S'), "sand", Character.valueOf('E'), Blocks.field_150377_bs});
        }
        if (enableAugmentExp) {
            RecipeHelper.addShapedRecipe((ItemStack)machine_experience, (Object[])new Object[]{" G ", "PCP", "SLS", Character.valueOf('G'), "gearSignalum", Character.valueOf('P'), "plateLumium", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('S'), FluidUtil.getFilledBucket((FluidStack)new FluidStack(TFFluids.fluidExperience, 1000)), Character.valueOf('L'), ItemTomeExperience.tomeExperience});
        }
        if (enableAugmentNether) {
            RecipeHelper.addShapedRecipe((ItemStack)machine_nether, (Object[])new Object[]{" G ", "PCP", "NBN", Character.valueOf('G'), "gearBronze", Character.valueOf('P'), "plateSilver", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('N'), "netherrack", Character.valueOf('B'), Items.field_151072_bj});
        }
        if (enableAugmentRancher) {
            RecipeHelper.addShapedRecipe((ItemStack)machine_rancher, (Object[])new Object[]{" G ", "PCP", "BSB", Character.valueOf('G'), "gearGold", Character.valueOf('P'), "plateAluminum", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('S'), Items.field_151097_aZ});
        }
        if (enableAugmentPermamorb) {
            RecipeHelper.addShapedRecipe((ItemStack)machine_permamorb, (Object[])new Object[]{" G ", "PCP", "SMS", Character.valueOf('G'), "gearEnderium", Character.valueOf('P'), "plateSteel", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('S'), Items.field_151156_bN, Character.valueOf('M'), ItemMorb.morbReusable});
        }
        if (enableAugmentMorbCapture) {
            RecipeHelper.addShapedRecipe((ItemStack)machine_morb_capture, (Object[])new Object[]{" G ", "PCP", "SMS", Character.valueOf('G'), "gearLumium", Character.valueOf('P'), "plateElectrum", Character.valueOf('C'), ItemMaterial.powerCoilElectrum, Character.valueOf('S'), "blockSlime", Character.valueOf('M'), ItemMorb.morbReusable});
        }
        return true;
    }

    private void addAugmentEntry(int metadata, IAugmentItem.AugmentType type, String identifier) {
        this.augmentMap.put(metadata, (Object)new AugmentEntry(type, identifier));
    }

    private ItemStack addAugmentItem(int metadata, String name) {
        this.addAugmentEntry(metadata, IAugmentItem.AugmentType.BASIC, name);
        return this.addItem(metadata, name);
    }

    private ItemStack addAugmentItem(int metadata, String name, EnumRarity rarity) {
        this.addAugmentEntry(metadata, IAugmentItem.AugmentType.BASIC, name);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addAugmentItem(int metadata, String name, IAugmentItem.AugmentType type) {
        EnumRarity rarity;
        switch (type) {
            case ADVANCED: 
            case MODE: {
                rarity = EnumRarity.UNCOMMON;
                break;
            }
            case ENDER: {
                rarity = EnumRarity.RARE;
                break;
            }
            case CREATIVE: {
                rarity = EnumRarity.EPIC;
                break;
            }
            default: {
                rarity = EnumRarity.COMMON;
            }
        }
        return this.addAugmentItem(metadata, name, type, rarity);
    }

    private ItemStack addAugmentItem(int metadata, String name, IAugmentItem.AugmentType type, EnumRarity rarity) {
        this.addAugmentEntry(metadata, type, name);
        return this.addItem(metadata, name, rarity);
    }

    public class AugmentEntry {
        public final IAugmentItem.AugmentType type;
        public final String identifier;

        AugmentEntry(IAugmentItem.AugmentType type, String identifier) {
            this.type = type;
            this.identifier = identifier;
        }
    }
}

