/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.render;

import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.render.CubeBakeryBase;
import com.arcaratus.virtualmachines.block.BlockVirtualMachine;
import com.arcaratus.virtualmachines.block.machine.TileVirtualMachine;
import com.arcaratus.virtualmachines.init.VMBlocks;
import com.arcaratus.virtualmachines.init.VMConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BakeryVirtualMachine
extends CubeBakeryBase {
    public static BakeryVirtualMachine INSTANCE = new BakeryVirtualMachine();

    private static TextureAtlasSprite getOverlaySprite(EnumFacing face, int level) {
        if (level == 0) {
            return null;
        }
        return TETextures.MACHINE_OVERLAY[level];
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        TileVirtualMachine machineBase = (TileVirtualMachine)world.func_175625_s(pos);
        if (machineBase == null) {
            return state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.of((String)"Null tile. Position: %s", (Object[])new Object[]{pos}));
        }
        state = state.withProperty((IUnlistedProperty)ModelErrorStateProperty.ERROR_STATE, (Object)ModelErrorStateProperty.ErrorState.OK);
        state = state.withProperty(VMConstants.TILE_VIRTUAL_MACHINE, (Object)machineBase);
        return state;
    }

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && !stack.func_190926_b()) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            CCRenderState ccrs = CCRenderState.instance();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            boolean creative = BlockVirtualMachine.itemBlock.isCreative(stack);
            int level = BlockVirtualMachine.itemBlock.getLevel(stack);
            BlockVirtualMachine provider = VMBlocks.virtual_machine;
            this.renderFace(ccrs, face, provider.getTexture(face, stack), -1);
            if (level > 0) {
                this.renderFaceOverlay(ccrs, face, creative ? TETextures.MACHINE_OVERLAY_C : BakeryVirtualMachine.getOverlaySprite(face, level), -1);
            }
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }

    public List<BakedQuad> bakeLayerFace(EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face != null && state != null) {
            Block block = state.func_177230_c();
            IWorldBlockTextureProvider provider = (IWorldBlockTextureProvider)block;
            TileVirtualMachine tile = (TileVirtualMachine)((Object)state.getValue(VMConstants.TILE_VIRTUAL_MACHINE));
            boolean creative = tile.isCreative;
            int level = tile.getLevel();
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            this.renderFace(ccrs, face, provider.getTexture(face, (IBlockState)state, layer, (IBlockAccess)tile.func_145831_w(), tile.func_174877_v()), tile.getColorMask(layer, face));
            if (layer == BlockRenderLayer.CUTOUT && level > 0) {
                this.renderFace(ccrs, face, creative ? TETextures.MACHINE_OVERLAY_C : BakeryVirtualMachine.getOverlaySprite(face, level), -1);
            }
            buffer.func_178977_d();
            quads.addAll(buffer.bake());
        }
        return quads;
    }
}

