/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.utils;

import cofh.core.util.helpers.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static double[] emptyDoubleArray(int size) {
        double[] array = new double[size];
        Arrays.fill(array, 0.0);
        return array;
    }

    public static double[] joinArrays(double[] ... arrays) {
        int size = Arrays.stream(arrays).mapToInt(d -> ((double[])d).length).sum();
        ArrayList list = new ArrayList(size);
        Arrays.stream(arrays).forEach(d -> Arrays.stream(d).forEach(list::add));
        return list.stream().mapToDouble(d -> d).toArray();
    }

    public static double[] applyToArray(double[] array, DoubleUnaryOperator operator) {
        return Arrays.stream(array).map(operator).toArray();
    }

    public static <T> List<T> arrayToListWithRange(T[] array, int startInclusive, int endExclusive) {
        return Arrays.stream(Arrays.copyOfRange(array, startInclusive, endExclusive)).collect(Collectors.toList());
    }

    public static boolean checkItemStackRange(ItemStack[] inventory, int startInclusive, int endExclusive, Predicate<ItemStack> checkeroo) {
        return Arrays.stream(Arrays.copyOfRange(inventory, startInclusive, endExclusive)).allMatch(checkeroo);
    }

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!Utils.isExistingOreName(oreName)) {
            return false;
        }
        NonNullList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!OreDictionary.itemMatches((ItemStack)st, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static ItemStack getPreferredOreStack(String oreName) {
        return Utils.isExistingOreName(oreName) ? Utils.getPreferredStackByMod((List<ItemStack>)OreDictionary.getOres((String)oreName)) : ItemStack.field_190927_a;
    }

    public static ItemStack getPreferredStackByMod(List<ItemStack> list) {
        ItemStack preferredStack = ItemStack.field_190927_a;
        for (ItemStack stack : list) {
            if (stack.func_190926_b()) continue;
            return stack.func_77946_l();
        }
        return preferredStack;
    }

    public static boolean checkTool(ItemStack itemStack, String ... names) {
        return Arrays.stream(names).anyMatch(s -> Utils.checkTool(itemStack, s));
    }

    public static boolean checkTool(ItemStack itemStack, String name) {
        switch (name) {
            case "axe": {
                return itemStack.func_77973_b() instanceof ItemAxe || itemStack.func_77973_b().getToolClasses(itemStack).contains("axe");
            }
            case "pickaxe": {
                return itemStack.func_77973_b() instanceof ItemPickaxe || itemStack.func_77973_b().getToolClasses(itemStack).contains("pickaxe");
            }
            case "fishing_rod": {
                return itemStack.func_77973_b() instanceof ItemFishingRod;
            }
            case "hoe": {
                return itemStack.func_77973_b() instanceof ItemHoe;
            }
            case "shears": {
                return itemStack.func_77973_b() instanceof ItemShears;
            }
            case "shovel": {
                return itemStack.func_77973_b() instanceof ItemSpade || itemStack.func_77973_b().getToolClasses(itemStack).contains("shovel");
            }
            case "sickle": {
                return itemStack.func_77973_b().getToolClasses(itemStack).contains("sickle");
            }
            case "sword": {
                return itemStack.func_77973_b() instanceof ItemSword;
            }
        }
        return false;
    }

    public static boolean isSlotInRange(int slot, int startInclusive, int endExclusive) {
        return slot >= startInclusive && slot < endExclusive;
    }

    public static boolean canFitOutputs(IInventory inventory, List<ItemStack> outputs, int start, int end) {
        ArrayList<Integer> skipSlots = new ArrayList<Integer>();
        block0: for (ItemStack stack : outputs) {
            for (int i = start; i < end; ++i) {
                if (skipSlots.contains(i)) continue;
                if (inventory.func_70301_a(i).func_190926_b()) {
                    skipSlots.add(i);
                    continue block0;
                }
                if (inventory.func_70301_a(i).func_77969_a(stack)) {
                    if (inventory.func_70301_a(i).func_190916_E() + stack.func_190916_E() <= 64) continue block0;
                    if (i != end - 1) continue;
                    return false;
                }
                if (i != end - 1) continue;
                return false;
            }
        }
        return true;
    }

    public static void distributeOutput(IInventory inventory, ItemStack output, int start, int end) {
        if (!output.func_190926_b() && output.func_190916_E() > 0) {
            for (int slot = start; slot < end; ++slot) {
                ItemStack s = inventory.func_70301_a(slot);
                if (s.func_190926_b()) {
                    inventory.func_70299_a(slot, ItemHelper.cloneStack((ItemStack)output));
                    break;
                }
                if (!s.func_77969_a(output) || s.func_190916_E() >= 64) continue;
                int count = output.func_190916_E();
                int grow = Math.min(count, 64 - s.func_190916_E());
                s.func_190917_f(grow);
                inventory.func_70299_a(slot, s);
                output.func_190920_e(count - grow);
                if (output.func_190916_E() <= 0) break;
            }
        }
    }

    public static ItemStack damageItem(ItemStack itemStack, int amount, Random random) {
        ItemStack result = itemStack.func_96631_a(amount, random, null) ? ItemStack.field_190927_a : itemStack.func_77946_l();
        return result;
    }
}

