/*
 * Decompiled with CFR 0.152.
 */
package com.arcaratus.virtualmachines.virtual;

import cofh.thermalfoundation.item.ItemFertilizer;
import com.arcaratus.virtualmachines.utils.ComparableItemStack;
import com.arcaratus.virtualmachines.utils.Distribution;
import com.arcaratus.virtualmachines.utils.Utils;
import com.arcaratus.virtualmachines.virtual.IVirtualMachine;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class VirtualFarm
implements IVirtualMachine {
    private static HashSet<IPlantHandler> plantHandlers = new HashSet();
    private static HashSet<IItemFertilizerHandler> itemFertilizers = new HashSet();
    private static HashSet<Predicate<ItemStack>> fertilizers = new HashSet();
    public static float solidFertilizerModifier = 1.0f;
    private static HashMap<ComparableItemStack, Boolean> seedSoilMap = new HashMap();
    private static HashMap<ComparableItemStack, List<Pair<Distribution, ItemStack>>> seedOutputMap = new HashMap();
    private static Table<ComparableItemStack, Predicate<ItemStack>, List<Pair<Distribution, ItemStack>>> saplingOutputTable = HashBasedTable.create();
    public static DefaultPlantHandler defaultHandler = new DefaultPlantHandler(){
        private Map<ComparableItemStack, Pair<Integer, Integer>> validSeeds = new THashMap();

        @Override
        protected Map<ComparableItemStack, Pair<Integer, Integer>> getSeedMap() {
            return this.validSeeds;
        }

        @Override
        public String getName() {
            return "defaultHandler";
        }
    };
    public static DefaultPlantHandler saplingHandler = new DefaultPlantHandler(){
        private Map<ComparableItemStack, Pair<Integer, Integer>> validSaplings = new THashMap();

        @Override
        protected Map<ComparableItemStack, Pair<Integer, Integer>> getSeedMap() {
            return this.validSaplings;
        }

        @Override
        public List<Pair<Distribution, ItemStack>> getOutput(ItemStack seed, List<ItemStack> tools) {
            if (!this.isValid(seed)) {
                return super.getOutput(seed, tools);
            }
            ArrayList<Predicate> p = new ArrayList<Predicate>();
            ComparableItemStack comp = new ComparableItemStack(seed, false);
            block0: for (Predicate pp : saplingOutputTable.row((Object)comp).keySet()) {
                for (ItemStack t : tools) {
                    if (!pp.test(t) || !saplingOutputTable.contains((Object)comp, (Object)pp)) continue;
                    p.add(pp);
                    if (this.usableTools.contains(t)) continue block0;
                    this.usableTools.add(t);
                    continue block0;
                }
            }
            if (p.isEmpty()) {
                return Lists.newArrayList();
            }
            ArrayList<Pair<Distribution, ItemStack>> outputs = new ArrayList<Pair<Distribution, ItemStack>>();
            for (Predicate pp : p) {
                outputs.addAll((Collection)saplingOutputTable.get((Object)comp, (Object)pp));
            }
            return outputs;
        }

        @Override
        public String getName() {
            return "saplingHandler";
        }
    };
    private List<IPlantHandler> currentPlantHandlers;
    private List<ItemStack> currentSeeds = new ArrayList<ItemStack>();
    private List<List<ItemStack>> currentTools = new ArrayList<List<ItemStack>>();

    public static void registerHandler(IPlantHandler handler) {
        plantHandlers.add(handler);
    }

    public static IPlantHandler getHandler(ItemStack seed) {
        if (seed.func_190926_b()) {
            return null;
        }
        for (IPlantHandler handler : plantHandlers) {
            if (!handler.isValid(seed)) continue;
            return handler;
        }
        return null;
    }

    public static void registerItemFertilizer(IItemFertilizerHandler handler) {
        itemFertilizers.add(handler);
        fertilizers.add(handler::isValid);
    }

    public static IItemFertilizerHandler getItemFertilizerHandler(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        for (IItemFertilizerHandler handler : itemFertilizers) {
            if (!handler.isValid(itemStack)) continue;
            return handler;
        }
        return null;
    }

    public static boolean isFertilizer(ItemStack itemStack) {
        return fertilizers.stream().anyMatch(p -> p.test(itemStack));
    }

    public static void registerBasicItemFertilizer(final ItemStack stack, final float growthMultiplier) {
        VirtualFarm.registerItemFertilizer(new IItemFertilizerHandler(){

            @Override
            public boolean isValid(ItemStack fertilizer) {
                return OreDictionary.itemMatches((ItemStack)stack, (ItemStack)fertilizer, (boolean)false);
            }

            @Override
            public float getGrowthMultiplier(ItemStack fertilizer) {
                return solidFertilizerModifier * growthMultiplier;
            }
        });
    }

    public static void init() {
        VirtualFarm.registerHandler(defaultHandler);
        VirtualFarm.registerHandler(saplingHandler);
        double[] standardCropDrops = new double[]{0.079, 0.315, 0.42, 0.186};
        double[] simpleDrop = new double[]{0.0, 1.0};
        double[] doubleDrop = new double[]{0.0, 0.0, 1.0};
        int defaultWater = 200;
        int defaultEnergy = 2400;
        defaultHandler.register(new ItemStack(Items.field_151014_N), VirtualFarm.ezPairs(new double[][]{standardCropDrops, simpleDrop}, new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O)), defaultWater, defaultEnergy);
        defaultHandler.register(new ItemStack(Items.field_151174_bG), VirtualFarm.ezPairs(new double[][]{standardCropDrops, {0.98, 0.02}}, new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151170_bI)), defaultWater, defaultEnergy);
        defaultHandler.register(new ItemStack(Items.field_151172_bF), VirtualFarm.ezPairs(new double[][]{standardCropDrops}, new ItemStack(Items.field_151172_bF)), defaultWater, defaultEnergy);
        defaultHandler.register(new ItemStack(Items.field_185163_cU), VirtualFarm.ezPairs(new double[][]{standardCropDrops, simpleDrop}, new ItemStack(Items.field_185163_cU), new ItemStack(Items.field_185164_cV)), defaultWater, defaultEnergy);
        defaultHandler.register(new ItemStack(Items.field_151075_bm), VirtualFarm.ezPairs(new double[][]{{0.0, 0.0, 0.3333, 0.3334, 0.3333}}, new ItemStack(Items.field_151075_bm)), 0, 3000, false);
        defaultHandler.register(new ItemStack((Block)Blocks.field_150337_Q), VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(3, 0.001, 0.0026, 0.0055, 0.0105, 0.0177, 0.0273, 0.0389, 0.052, 0.064, 0.0749, 0.083, 0.087, 0.087, 0.083, 0.0756, 0.0666, 0.056, 0.0455, 0.0356, 0.027, 0.02, 0.015, 0.0096, 0.0064, 0.0041, 0.0026, 0.0016)}, new ItemStack((Block)Blocks.field_150337_Q)), 500, 6000, false);
        defaultHandler.register(new ItemStack((Block)Blocks.field_150338_P), VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(3, 0.001, 0.0026, 0.0055, 0.0105, 0.0177, 0.0273, 0.0389, 0.052, 0.064, 0.0749, 0.083, 0.087, 0.087, 0.083, 0.0756, 0.0666, 0.056, 0.0455, 0.0356, 0.027, 0.02, 0.015, 0.0096, 0.0064, 0.0041, 0.0026, 0.0016)}, new ItemStack((Block)Blocks.field_150338_P)), 500, 6000, false);
        defaultWater = 500;
        defaultEnergy = 3600;
        defaultHandler.register(new ItemStack(Items.field_151080_bb), VirtualFarm.ezPairs(new double[][]{simpleDrop}, new ItemStack(Blocks.field_150423_aK)), defaultWater, defaultEnergy);
        defaultHandler.register(new ItemStack(Items.field_151081_bc), VirtualFarm.ezPairs(new double[][]{simpleDrop}, new ItemStack(Blocks.field_150440_ba)), defaultWater, defaultEnergy);
        defaultWater = 400;
        defaultEnergy = 3000;
        defaultHandler.register(new ItemStack(Items.field_151120_aE), VirtualFarm.ezPairs(new double[][]{doubleDrop}, new ItemStack(Items.field_151120_aE)), defaultWater, defaultEnergy, false);
        defaultHandler.register(new ItemStack((Block)Blocks.field_150434_aF), VirtualFarm.ezPairs(new double[][]{doubleDrop}, new ItemStack((Block)Blocks.field_150434_aF)), defaultWater, defaultEnergy, false);
        defaultHandler.register(new ItemStack(Blocks.field_185766_cS), VirtualFarm.ezPairs(new double[][]{simpleDrop}, new ItemStack(Items.field_185161_cS)), 0, defaultEnergy, false);
        defaultWater = 1000;
        defaultEnergy = 6000;
        double[] saplingDrops = new double[]{0.0629, 0.1798, 0.2483, 0.2265, 0.1517, 0.08, 0.0345, 0.0127};
        saplingHandler.registerSapling(new ItemStack(Blocks.field_150345_g), VirtualFarm.ezPredicates(s -> Utils.checkTool(s, "axe"), s -> Utils.checkTool(s, "shears")), VirtualFarm.ezLists(VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(4, 0.3333, 0.3333, 0.3334), saplingDrops}, new ItemStack(Blocks.field_150364_r), new ItemStack(Blocks.field_150345_g)), VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(47, 2.0E-4, 0.003, 0.0162, 0.0539, 0.1208, 0.1936, 0.2254, 0.1933, 0.1207, 0.0537, 0.0161, 0.0029, 2.0E-4)}, new ItemStack((Block)Blocks.field_150362_t))), defaultWater, defaultEnergy);
        saplingHandler.registerSapling(new ItemStack(Blocks.field_150345_g, 1, 1), VirtualFarm.ezPredicates(s -> Utils.checkTool(s, "axe"), s -> Utils.checkTool(s, "shears")), VirtualFarm.ezLists(VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(4, 0.0833, 0.167, 0.25, 0.25, 0.1665, 0.0832), {0.0, 0.25, 0.25, 0.125, 0.125, 0.2189, 0.0311}}, new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Blocks.field_150345_g, 1, 1)), VirtualFarm.ezPairs(new double[][]{Utils.joinArrays(VirtualFarm.ezDArray(33, 0.09375), VirtualFarm.ezDArray(3, 0.09375, 0.20833), VirtualFarm.ezDArray(19, 0.20834, 0.20833), VirtualFarm.ezDArray(3, 0.09375, 0.09375))}, new ItemStack((Block)Blocks.field_150362_t, 1, 1))), defaultWater, defaultEnergy);
        saplingHandler.registerSapling(new ItemStack(Blocks.field_150345_g, 1, 2), VirtualFarm.ezPredicates(s -> Utils.checkTool(s, "axe"), s -> Utils.checkTool(s, "shears")), VirtualFarm.ezLists(VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(5, 0.3334, 0.3333, 0.3333), saplingDrops}, new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Blocks.field_150345_g, 1, 2)), VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(52, 2.0E-4, 0.003, 0.0162, 0.0537, 0.121, 0.1933, 0.2254, 0.1933, 0.1207, 0.0538, 0.0162, 0.003, 2.0E-4)}, new ItemStack((Block)Blocks.field_150362_t, 1, 2))), defaultWater, defaultEnergy);
        saplingHandler.registerSapling(new ItemStack(Blocks.field_150345_g, 1, 3), VirtualFarm.ezPredicates(s -> Utils.checkTool(s, "axe"), s -> Utils.checkTool(s, "shears")), VirtualFarm.ezLists(VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(4, 0.0475, 0.095, 0.143, 0.143, 0.143, 0.143, 0.143, 0.095, 0.0475), {0.051, 0.157, 0.2335, 0.2293, 0.166, 0.0945, 0.044, 0.0173, 0.0058, 0.0016}}, new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Blocks.field_150345_g, 1, 3)), VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(52, 2.0E-4, 0.003, 0.0162, 0.0537, 0.121, 0.1933, 0.2254, 0.1933, 0.1207, 0.0538, 0.0162, 0.003, 2.0E-4)}, new ItemStack((Block)Blocks.field_150362_t, 1, 3))), defaultWater, defaultEnergy);
        saplingHandler.registerSapling(new ItemStack(Blocks.field_150345_g, 1, 4), VirtualFarm.ezPredicates(s -> Utils.checkTool(s, "axe"), s -> Utils.checkTool(s, "shears")), VirtualFarm.ezLists(VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(5, 0.0416, 0.0902, 0.1667, 0.2152, 0.219, 0.163, 0.08, 0.0243), {0.0213, 0.0791, 0.148, 0.19, 0.19, 0.1518, 0.1042, 0.0612, 0.0319, 0.0145, 0.006, 0.002}}, new ItemStack(Blocks.field_150363_s), new ItemStack(Blocks.field_150345_g, 1, 4)), VirtualFarm.ezPairs(new double[][]{Utils.joinArrays(VirtualFarm.ezDArray(58, 0.2706), VirtualFarm.ezDArray(29, 0.7294))}, new ItemStack((Block)Blocks.field_150361_u))), defaultWater, defaultEnergy);
        saplingHandler.registerSapling(new ItemStack(Blocks.field_150345_g, 1, 5), VirtualFarm.ezPredicates(s -> Utils.checkTool(s, "axe"), s -> Utils.checkTool(s, "shears")), VirtualFarm.ezLists(VirtualFarm.ezPairs(new double[][]{VirtualFarm.ezDArray(6, 0.0064, 0.0395, 0.1132, 0.2, 0.24, 0.204, 0.1234, 0.0536, 0.0164, 0.0035), {0.0592, 0.161, 0.2255, 0.2155, 0.1582, 0.0958, 0.0493, 0.0222, 0.0089, 0.0033, 0.0011}}, new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack(Blocks.field_150345_g, 1, 5)), VirtualFarm.ezPairs(new double[][]{Utils.joinArrays(VirtualFarm.ezDArray(28, 0.003, 0.003), VirtualFarm.ezDArray(6, 0.0232, 0.0232), VirtualFarm.ezDArray(5, 0.064, 0.064), VirtualFarm.ezDArray(6, 0.106, 0.106), VirtualFarm.ezDArray(5, 0.12, 0.12), VirtualFarm.ezDArray(6, 0.0954, 0.0954), VirtualFarm.ezDArray(5, 0.0556), VirtualFarm.ezDArray(6, 0.0237, 0.0237), VirtualFarm.ezDArray(5, 0.0075, 0.0075), VirtualFarm.ezDArray(6, 0.0016, 0.0016))}, new ItemStack((Block)Blocks.field_150361_u, 1, 1))), defaultWater, defaultEnergy);
        VirtualFarm.registerItemFertilizer(new IItemFertilizerHandler(){
            final ItemStack bonemeal = new ItemStack(Items.field_151100_aR, 1, 15);

            @Override
            public boolean isValid(ItemStack fertilizer) {
                return !fertilizer.func_190926_b() && OreDictionary.itemMatches((ItemStack)this.bonemeal, (ItemStack)fertilizer, (boolean)true);
            }

            @Override
            public float getGrowthMultiplier(ItemStack fertilizer) {
                return solidFertilizerModifier * 1.25f;
            }
        });
        VirtualFarm.registerBasicItemFertilizer(ItemFertilizer.fertilizerBasic, 1.25f);
        VirtualFarm.registerBasicItemFertilizer(ItemFertilizer.fertilizerRich, 1.5f);
        VirtualFarm.registerBasicItemFertilizer(ItemFertilizer.fertilizerFlux, 2.0f);
    }

    public static List<Pair<Distribution, ItemStack>> ezPairs(double[][] probabilities, ItemStack ... outputs) {
        ArrayList<Pair<Distribution, ItemStack>> ezList = new ArrayList<Pair<Distribution, ItemStack>>();
        for (int i = 0; i < probabilities.length; ++i) {
            ezList.add((Pair<Distribution, ItemStack>)Pair.of((Object)new Distribution(probabilities[i]), (Object)outputs[i]));
        }
        return ezList;
    }

    @SafeVarargs
    public static List<List<Pair<Distribution, ItemStack>>> ezLists(List<Pair<Distribution, ItemStack>> ... pairs) {
        return Arrays.asList(pairs);
    }

    @SafeVarargs
    public static List<Predicate<ItemStack>> ezPredicates(Predicate<ItemStack> ... predicates) {
        return Arrays.asList(predicates);
    }

    public static double[] ezDArray(int emptyArraySize, double ... probValues) {
        return ArrayUtils.addAll((double[])Utils.emptyDoubleArray(emptyArraySize), (double[])probValues);
    }

    public static IPlantHandler getHandlerFromName(String name) {
        for (IPlantHandler handler : plantHandlers) {
            if (!handler.getName().equals(name)) continue;
            return handler;
        }
        return null;
    }

    public VirtualFarm() {
        ArrayList<ItemStack> emptyList = new ArrayList<ItemStack>();
        for (int j = 0; j < 4; ++j) {
            emptyList.add(ItemStack.field_190927_a);
        }
        for (int i = 0; i < 9; ++i) {
            this.currentSeeds.add(i, ItemStack.field_190927_a);
            this.currentTools.add(i, emptyList);
        }
    }

    public List<ItemStack> getCurrentSeeds() {
        return this.currentSeeds;
    }

    public void setCurrentSeeds(List<ItemStack> currentSeeds) {
        this.currentSeeds = currentSeeds;
    }

    public List<List<ItemStack>> getCurrentTools() {
        return this.currentTools;
    }

    public void setCurrentTools(List<List<ItemStack>> currentTools) {
        this.currentTools = currentTools;
    }

    public List<IPlantHandler> getCurrentPlantHandlers() {
        return this.currentPlantHandlers;
    }

    public List<IPlantHandler> getPlantHandlers(List<ItemStack> inventory) {
        if (this.currentPlantHandlers == null || inventory.size() <= 0) {
            this.currentPlantHandlers = new ArrayList<IPlantHandler>(9);
            for (int i = 0; i < 9; ++i) {
                this.currentPlantHandlers.add(i, VirtualFarm.getHandler(inventory.get(i)));
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                if (this.currentPlantHandlers.get(i) != null && !this.currentPlantHandlers.get(i).isValid(inventory.get(i))) continue;
                this.currentPlantHandlers.set(i, VirtualFarm.getHandler(inventory.get(i)));
            }
        }
        return this.currentPlantHandlers;
    }

    public void clear() {
        this.currentTools.clear();
        ArrayList<ItemStack> emptyList = new ArrayList<ItemStack>();
        for (int j = 0; j < 4; ++j) {
            emptyList.add(ItemStack.field_190927_a);
        }
        for (int i = 0; i < 9; ++i) {
            this.currentSeeds.set(i, ItemStack.field_190927_a);
            this.currentPlantHandlers.set(i, null);
            this.currentTools.add(i, emptyList);
        }
    }

    @Override
    public IVirtualMachine readFromNBT(NBTTagCompound tag) {
        NBTTagList seedList = tag.func_150295_c("currentSeeds", 10);
        NBTTagList omegaLUL = tag.func_150295_c("currentTools", 9);
        for (int i = 0; i < 9; ++i) {
            int j;
            if (this.currentPlantHandlers == null) {
                this.currentPlantHandlers = new ArrayList<IPlantHandler>(9);
                for (j = 0; j < 9; ++j) {
                    this.currentPlantHandlers.add(j, VirtualFarm.getHandlerFromName(tag.func_150295_c("plantHandlers", 8).func_150307_f(j)));
                }
            } else {
                for (j = 0; j < 9; ++j) {
                    if (this.currentPlantHandlers.get(i) != null) continue;
                    this.currentPlantHandlers.set(i, VirtualFarm.getHandlerFromName(tag.func_150295_c("plantHandlers", 8).func_150307_f(j)));
                }
            }
            this.currentSeeds.set(i, new ItemStack(seedList.func_150305_b(i)));
            NBTTagList toolsList = (NBTTagList)omegaLUL.func_179238_g(i);
            for (int j2 = 0; j2 < 4; ++j2) {
                this.currentTools.get(i).set(j2, new ItemStack(toolsList.func_150305_b(j2)));
            }
        }
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        NBTTagList seedList = new NBTTagList();
        NBTTagList omegaLul = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            if (this.currentPlantHandlers == null || this.currentPlantHandlers.get(i) == null) {
                list.func_74742_a((NBTBase)new NBTTagString());
            } else {
                list.func_74742_a((NBTBase)new NBTTagString(this.currentPlantHandlers.get(i).getName()));
            }
            NBTTagCompound nbt = new NBTTagCompound();
            this.currentSeeds.get(i).func_77955_b(nbt);
            seedList.func_74742_a((NBTBase)nbt);
            NBTTagList toolsList = new NBTTagList();
            for (int j = 0; j < 4; ++j) {
                nbt = new NBTTagCompound();
                this.currentTools.get(i).get(j).func_77955_b(nbt);
                toolsList.func_74742_a((NBTBase)nbt);
            }
            omegaLul.func_74742_a((NBTBase)toolsList);
        }
        tag.func_74782_a("plantHandlers", (NBTBase)list);
        tag.func_74782_a("currentSeeds", (NBTBase)seedList);
        tag.func_74782_a("currentTools", (NBTBase)omegaLul);
        return tag;
    }

    public static interface IItemFertilizerHandler {
        public boolean isValid(ItemStack var1);

        public float getGrowthMultiplier(ItemStack var1);
    }

    public static abstract class DefaultPlantHandler
    implements IPlantHandler {
        public List<ItemStack> usableTools = new ArrayList<ItemStack>();

        protected abstract Map<ComparableItemStack, Pair<Integer, Integer>> getSeedMap();

        @Override
        public boolean isValid(ItemStack seed) {
            return !seed.func_190926_b() && (this.getSeedMap().keySet().contains(new ComparableItemStack(seed, false)) || this.getSeedMap().keySet().stream().anyMatch(s -> s.equals(new ComparableItemStack(seed))));
        }

        @Override
        public boolean requiresDirt(ItemStack seed) {
            return (Boolean)seedSoilMap.get(new ComparableItemStack(seed, false));
        }

        @Override
        public List<Pair<Distribution, ItemStack>> getOutput(ItemStack seed, List<ItemStack> tools) {
            for (ItemStack t : tools) {
                if (!Utils.checkTool(t, "hoe", "sickle")) continue;
                this.usableTools.add(t);
            }
            if (seedOutputMap.get(new ComparableItemStack(seed, false)) == null) {
                return seedOutputMap.values().stream().filter(l -> l.stream().anyMatch(p -> ((ItemStack)p.getRight()).func_77969_a(seed))).findFirst().get();
            }
            return seedOutputMap.getOrDefault(new ComparableItemStack(seed, false), Lists.newArrayList());
        }

        @Override
        public int waterRequired(ItemStack seed) {
            return (Integer)this.getSeedMap().getOrDefault(new ComparableItemStack(seed, false), (Pair<Integer, Integer>)this.getSeedMap().entrySet().stream().filter(e -> ((ComparableItemStack)e.getKey()).equals(new ComparableItemStack(seed))).findFirst().get().getValue()).getLeft();
        }

        @Override
        public int energyRequired(ItemStack seed) {
            return (Integer)this.getSeedMap().getOrDefault(new ComparableItemStack(seed, false), (Pair<Integer, Integer>)this.getSeedMap().entrySet().stream().filter(e -> ((ComparableItemStack)e.getKey()).equals(new ComparableItemStack(seed))).findFirst().get().getValue()).getRight();
        }

        @Override
        public List<ItemStack> getTools() {
            return this.usableTools;
        }

        @Override
        public void clearTools() {
            this.usableTools.clear();
        }

        public void register(ItemStack seed, List<Pair<Distribution, ItemStack>> output, int waterRequired, int energyRequired) {
            this.register(seed, output, waterRequired, energyRequired, true);
        }

        public void register(ItemStack seed, List<Pair<Distribution, ItemStack>> output, int waterRequired, int energyRequired, boolean requiresDirt) {
            ComparableItemStack comp = new ComparableItemStack(seed, false);
            this.getSeedMap().put(comp, (Pair<Integer, Integer>)Pair.of((Object)waterRequired, (Object)energyRequired));
            seedSoilMap.put(comp, requiresDirt);
            seedOutputMap.put(comp, output);
        }

        public void registerSapling(ItemStack sapling, List<Predicate<ItemStack>> tools, List<List<Pair<Distribution, ItemStack>>> outputs, int waterRequired, int energyRequired) {
            ComparableItemStack comp = new ComparableItemStack(sapling, false);
            this.getSeedMap().put(comp, (Pair<Integer, Integer>)Pair.of((Object)waterRequired, (Object)energyRequired));
            seedSoilMap.put(comp, true);
            for (int i = 0; i < tools.size(); ++i) {
                saplingOutputTable.put((Object)comp, tools.get(i), outputs.get(i));
            }
        }
    }

    public static interface IPlantHandler {
        public boolean isValid(ItemStack var1);

        public boolean requiresDirt(ItemStack var1);

        public List<Pair<Distribution, ItemStack>> getOutput(ItemStack var1, List<ItemStack> var2);

        public String getName();

        public int waterRequired(ItemStack var1);

        public int energyRequired(ItemStack var1);

        default public List<ItemStack> getTools() {
            return Lists.newArrayList();
        }

        default public void clearTools() {
        }
    }
}

