/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.lex.yunomakegoodmap.YUNoMakeGoodMap;
import org.lwjgl.input.Mouse;

public class GuiCustomizeWorld
extends GuiScreen {
    private GuiCreateWorld createGUI;
    private ScrollList list;
    private GuiScrollingList info;
    private Map<ResourceLocation, StructInfo> structInfo = Maps.newHashMap();
    private static final Gson GSON = new Gson();
    private static final int LIST_WIDTH = 130;

    public GuiCustomizeWorld(GuiCreateWorld createGUI) {
        this.createGUI = createGUI;
    }

    public void func_73866_w_() {
        this.list = new ScrollList();
        this.collectPlatforms();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)this.createGUI);
        } else if (button.field_146127_k == 0) {
            this.createGUI.field_146334_a = ((ResourceLocation)this.list.list.get(this.list.selected)).toString();
            this.field_146297_k.func_147108_a((GuiScreen)this.createGUI);
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.list.handleMouseInput(mouseX, mouseY);
        if (this.info != null) {
            this.info.handleMouseInput(mouseX, mouseY);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.drawScreen(mouseX, mouseY, partialTicks);
        if (this.info != null) {
            this.info.drawScreen(mouseX, mouseY, partialTicks);
        }
        this.func_73732_a(this.field_146289_q, "Select Platform", this.field_146294_l / 2, 8, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void collectPlatforms() {
        List platforms = this.list.list;
        for (String domain : this.field_146297_k.func_110442_L().func_135055_a()) {
            try {
                for (IResource res : this.field_146297_k.func_110442_L().func_135056_b(new ResourceLocation(domain, "structures/SkyBlockPlatforms.txt"))) {
                    for (String name : CharStreams.readLines((Readable)new InputStreamReader(res.func_110527_b()))) {
                        try {
                            if (this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(domain, "structures/" + name + ".nbt")) == null) continue;
                            platforms.add(new ResourceLocation(domain, name));
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (IOException iOException) {
            }
        }
        for (File f : YUNoMakeGoodMap.instance.getStructFolder().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".nbt");
            }
        })) {
            platforms.add(new ResourceLocation("/config/", f.getName().substring(0, f.getName().length() - 4)));
        }
    }

    private StructInfo getInfo(ResourceLocation res) {
        StructInfo ret = this.structInfo.get(res);
        if (ret != null) {
            return ret;
        }
        try {
            IResource ir = this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(res.func_110624_b(), "structures/" + res.func_110623_a() + ".json"));
            ret = (StructInfo)GSON.fromJson((Reader)new InputStreamReader(ir.func_110527_b()), StructInfo.class);
            if (ret.logo != null && (ir = this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(res.func_110624_b(), "structures/" + ret.logo))) != null) {
                BufferedImage l = ImageIO.read(ir.func_110527_b());
                ret.logoPath = this.field_146297_k.func_110434_K().func_110578_a("platformlogo", new DynamicTexture(l));
                ret.logoSize = new Dimension(l.getWidth(), l.getHeight());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ret == null) {
            ret = new StructInfo();
        }
        if (ret.name == null) {
            ret.name = res.toString();
        }
        this.structInfo.put(res, ret);
        return ret;
    }

    private class Info
    extends GuiScrollingList {
        private ResourceLocation logoPath;
        private Dimension logoDims;
        private List<ITextComponent> lines;

        public Info(int width, List<String> lines, ResourceLocation logoPath, Dimension logoDims) {
            super(GuiCustomizeWorld.this.field_146297_k, width, GuiCustomizeWorld.this.field_146295_m, 32, GuiCustomizeWorld.this.field_146295_m - 68 + 4, 150, 60, GuiCustomizeWorld.this.field_146294_l, GuiCustomizeWorld.this.field_146295_m);
            this.lines = null;
            this.lines = this.resizeContent(lines);
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        protected int getSize() {
            return 0;
        }

        protected void elementClicked(int index, boolean doubleClick) {
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        }

        private List<ITextComponent> resizeContent(List<String> lines) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                ret.addAll(GuiUtilRenderComponents.func_178908_a((ITextComponent)chat, (int)(this.listWidth - 8), (FontRenderer)GuiCustomizeWorld.this.field_146289_q, (boolean)false, (boolean)true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = 0;
            if (this.logoPath != null) {
                double scaleX = (double)this.logoDims.width / 200.0;
                double scaleY = (double)this.logoDims.height / 65.0;
                double scale = 1.0;
                if (scaleX > 1.0 || scaleY > 1.0) {
                    scale = 1.0 / Math.max(scaleX, scaleY);
                }
                this.logoDims.width = (int)((double)this.logoDims.width * scale);
                this.logoDims.height = (int)((double)this.logoDims.height * scale);
                height += this.logoDims.height;
                height += 10;
            }
            if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
            int top = relativeY;
            if (this.logoPath != null) {
                GlStateManager.func_179147_l();
                GuiCustomizeWorld.this.field_146297_k.field_71446_o.func_110577_a(this.logoPath);
                VertexBuffer wr = tess.func_178180_c();
                int offset = this.left + this.listWidth / 2 - this.logoDims.width / 2;
                wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                wr.func_181662_b((double)offset, (double)(top + this.logoDims.height), (double)GuiCustomizeWorld.this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)(top + this.logoDims.height), (double)GuiCustomizeWorld.this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
                wr.func_181662_b((double)(offset + this.logoDims.width), (double)top, (double)GuiCustomizeWorld.this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
                wr.func_181662_b((double)offset, (double)top, (double)GuiCustomizeWorld.this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179084_k();
                top += this.logoDims.height + 10;
            }
            for (ITextComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.func_179147_l();
                    GuiCustomizeWorld.this.field_146289_q.func_175063_a(line.func_150254_d(), (float)(this.left + 4), (float)top, 0xFFFFFF);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                top += 10;
            }
        }

        protected void clickHeader(int x, int y) {
            int offset = y;
            if (this.logoPath != null) {
                offset -= this.logoDims.height + 10;
            }
            if (offset <= 0) {
                return;
            }
            int lineIdx = offset / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            ITextComponent line = this.lines.get(lineIdx);
            if (line != null) {
                int k = -4;
                for (ITextComponent part : line) {
                    if (!(part instanceof TextComponentString) || (k += GuiCustomizeWorld.this.field_146289_q.func_78256_a(((TextComponentString)part).func_150265_g())) < x) continue;
                    GuiCustomizeWorld.this.func_175276_a(part);
                    break;
                }
            }
        }
    }

    private static class StructInfo {
        public String name;
        public String logo;
        public String[] description;
        public ResourceLocation logoPath;
        public Dimension logoSize;

        private StructInfo() {
        }
    }

    private class ScrollList
    extends GuiScrollingList {
        private List<ResourceLocation> list;
        private int selected;

        public ScrollList() {
            super(GuiCustomizeWorld.this.field_146297_k, 130, GuiCustomizeWorld.this.field_146295_m, 32, GuiCustomizeWorld.this.field_146295_m - 68 + 4, 10, ((GuiCustomizeWorld)GuiCustomizeWorld.this).field_146289_q.field_78288_b + 6, GuiCustomizeWorld.this.field_146294_l, GuiCustomizeWorld.this.field_146295_m);
            this.list = Lists.newArrayList();
            this.selected = 0;
            this.elementClicked(0, false);
        }

        protected int getSize() {
            return this.list.size();
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (index == this.selected) {
                return;
            }
            this.selected = index;
            StructInfo info = GuiCustomizeWorld.this.getInfo(this.list.get(index));
            if (info != null) {
                ArrayList lines = Lists.newArrayList();
                if (info.description != null) {
                    for (String line : info.description) {
                        lines.add(line);
                    }
                } else {
                    lines.add(TextFormatting.RED + "NO INFORMATION FOUND");
                    lines.add(TextFormatting.RED + "Please add a jsonfile with description information.");
                }
                GuiCustomizeWorld.this.info = new Info(GuiCustomizeWorld.this.field_146294_l - 130 - 30, lines, info.logoPath, info.logoSize);
            }
        }

        protected boolean isSelected(int index) {
            return this.selected == index;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            ResourceLocation item = this.list.get(slotIdx);
            StructInfo info = GuiCustomizeWorld.this.getInfo(item);
            FontRenderer font = GuiCustomizeWorld.this.field_146289_q;
            font.func_78276_b(font.func_78269_a(info.name, this.listWidth - 10), this.left + 3, slotTop + 2, 0xFF2222);
        }
    }
}

