/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ForgeEventFactory {
    public static BlockEvent.MultiPlaceEvent onPlayerMultiBlockPlace(zs player, List<BlockSnapshot> blockSnapshots, ct direction) {
        BlockSnapshot snap = blockSnapshots.get(0);
        ars placedAgainst = snap.getWorld().o(snap.getPos().a(direction.d()));
        BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.PlaceEvent onPlayerBlockPlace(zs player, BlockSnapshot blockSnapshot, ct direction) {
        ars placedAgainst = blockSnapshot.getWorld().o(blockSnapshot.getPos().a(direction.d()));
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.NeighborNotifyEvent onNeighborNotify(aid world, cm pos, ars state, EnumSet<ct> notifiedSides) {
        BlockEvent.NeighborNotifyEvent event = new BlockEvent.NeighborNotifyEvent(world, pos, state, notifiedSides);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static boolean doPlayerHarvestCheck(zs player, ars state, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, state, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.canHarvest();
    }

    public static float getBreakSpeed(zs player, ars state, float original, cm pos) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, state, original, pos);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.getNewSpeed();
    }

    public static void onPlayerDestroyItem(zs player, adz stack, qr hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack, hand));
    }

    public static Event.Result canEntitySpawn(sg entity, aid world, float x, float y, float z) {
        if (entity == null) {
            return Event.Result.DEFAULT;
        }
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y, z);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean canEntitySpawnSpawner(sg entity, aid world, float x, float y, float z) {
        Event.Result result = ForgeEventFactory.canEntitySpawn(entity, world, x, y, z);
        if (result == Event.Result.DEFAULT) {
            return entity.cK() && entity.cL();
        }
        return result == Event.Result.ALLOW;
    }

    public static boolean doSpecialSpawn(sg entity, aid world, float x, float y, float z) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x, y, z));
    }

    public static Event.Result canEntityDespawn(sg entity) {
        LivingSpawnEvent.AllowDespawn event = new LivingSpawnEvent.AllowDespawn(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static int getExperienceDrop(sf entity, zs attackingPlayer, int originalExperience) {
        LivingExperienceDropEvent event = new LivingExperienceDropEvent(entity, attackingPlayer, originalExperience);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return 0;
        }
        return event.getDroppedExperience();
    }

    public static List<aiq.c> getPotentialSpawns(ls world, sh type, cm pos, List<aiq.c> oldList) {
        WorldEvent.PotentialSpawns event = new WorldEvent.PotentialSpawns((aid)world, type, pos, oldList);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getList();
    }

    public static int getMaxSpawnPackSize(sg entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post(maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.getMaxPackSize() : entity.cO();
    }

    public static String getPlayerDisplayName(zs player, String username) {
        PlayerEvent.NameFormat event = new PlayerEvent.NameFormat(player, username);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getDisplayname();
    }

    public static float fireBlockHarvesting(List<adz> drops, aid world, cm pos, ars state, int fortune, float dropChance, boolean silkTouch, zs player) {
        BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(world, pos, state, fortune, dropChance, drops, player, silkTouch);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getDropChance();
    }

    public static ItemTooltipEvent onItemTooltip(adz itemStack, zs entityPlayer, List<String> toolTip, boolean showAdvancedItemTooltips) {
        ItemTooltipEvent event = new ItemTooltipEvent(itemStack, entityPlayer, toolTip, showAdvancedItemTooltips);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static ZombieEvent.SummonAidEvent fireZombieSummonAid(zi zombie, aid world, int x, int y, int z, sf attacker, double summonChance) {
        ZombieEvent.SummonAidEvent summonEvent = new ZombieEvent.SummonAidEvent(zombie, world, x, y, z, attacker, summonChance);
        MinecraftForge.EVENT_BUS.post(summonEvent);
        return summonEvent;
    }

    public static boolean onEntityStruckByLightning(rw entity, yh bolt) {
        return MinecraftForge.EVENT_BUS.post(new EntityStruckByLightningEvent(entity, bolt));
    }

    public static int onItemUseStart(sf entity, adz item, int duration) {
        LivingEntityUseItemEvent.Start event = new LivingEntityUseItemEvent.Start(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.getDuration();
    }

    public static int onItemUseTick(sf entity, adz item, int duration) {
        LivingEntityUseItemEvent.Tick event = new LivingEntityUseItemEvent.Tick(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.getDuration();
    }

    public static boolean onUseItemStop(sf entity, adz item, int duration) {
        return MinecraftForge.EVENT_BUS.post(new LivingEntityUseItemEvent.Stop(entity, item, duration));
    }

    public static adz onItemUseFinish(sf entity, adz item, int duration, adz result) {
        LivingEntityUseItemEvent.Finish event = new LivingEntityUseItemEvent.Finish(entity, item, duration, result);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResultStack();
    }

    public static void onStartEntityTracking(rw entity, zs player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(rw entity, zs player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(zs player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerSavingEvent(zs player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.SaveToFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(zs player, bah playerFileData, String uuidString) {
        azy sh2 = (azy)playerFileData;
        File dir = (File)ObfuscationReflectionHelper.getPrivateValue(azy.class, sh2, "playersDirectory", "field_75771_c");
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, dir, uuidString));
    }

    public static ey onClientChat(byte type, ey message) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(type, message);
        return MinecraftForge.EVENT_BUS.post(event) ? null : event.getMessage();
    }

    public static int onHoeUse(adz stack, zs player, aid worldIn, cm pos) {
        UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            stack.a(1, (sf)player);
            return 1;
        }
        return 0;
    }

    public static int onApplyBonemeal(zs player, aid world, cm pos, ars state, adz stack) {
        BonemealEvent event = new BonemealEvent(player, world, pos, state);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!world.E) {
                --stack.b;
            }
            return 1;
        }
        return 0;
    }

    public static qu<adz> onBucketUse(zs player, aid world, adz stack, bbz target) {
        FillBucketEvent event = new FillBucketEvent(player, stack, world, target);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return new qu(qt.c, (Object)stack);
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.bL.d) {
                return new qu(qt.a, (Object)stack);
            }
            if (--stack.b <= 0) {
                return new qu(qt.a, (Object)event.getFilledBucket());
            }
            if (!player.bt.c(event.getFilledBucket())) {
                player.a(event.getFilledBucket(), false);
            }
            return new qu(qt.a, (Object)stack);
        }
        return null;
    }

    public static boolean canEntityUpdate(rw entity) {
        EntityEvent.CanUpdate event = new EntityEvent.CanUpdate(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCanUpdate();
    }

    public static PlaySoundAtEntityEvent onPlaySoundAtEntity(rw entity, ni name, nk category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(entity, name, category, volume, pitch);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static int onItemExpire(yk entity, adz item) {
        if (item == null) {
            return -1;
        }
        ItemExpireEvent event = new ItemExpireEvent(entity, item.b() == null ? 6000 : item.b().getEntityLifespan(item, entity.l));
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getExtraLife();
    }

    public static int onItemPickup(yk entityItem, zs entityIn, adz itemstack) {
        EntityItemPickupEvent event = new EntityItemPickupEvent(entityIn, entityItem);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getResult() == Event.Result.ALLOW ? 1 : 0;
    }

    public static void onPlayerDrops(zs player, rh cause, List<yk> capturedDrops, boolean recentlyHit) {
        PlayerDropsEvent event = new PlayerDropsEvent(player, cause, capturedDrops, recentlyHit);
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            for (yk item : capturedDrops) {
                player.a(item);
            }
        }
    }

    public static boolean canMountEntity(rw entityMounting, rw entityBeingMounted, boolean isMounting) {
        boolean isCanceled = MinecraftForge.EVENT_BUS.post(new EntityMountEvent(entityMounting, entityBeingMounted, entityMounting.l, isMounting));
        if (isCanceled) {
            entityMounting.a(entityMounting.p, entityMounting.q, entityMounting.r, entityMounting.x, entityMounting.y);
            return false;
        }
        return true;
    }

    public static zs.a onPlayerSleepInBed(zs player, cm pos) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, pos);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResultStatus();
    }

    public static void onPlayerWakeup(zs player, boolean wakeImmediately, boolean updateWorldFlag, boolean setSpawn) {
        MinecraftForge.EVENT_BUS.post(new PlayerWakeUpEvent(player, wakeImmediately, updateWorldFlag, setSpawn));
    }

    public static void onPlayerFall(zs player, float distance, float multiplier) {
        MinecraftForge.EVENT_BUS.post(new PlayerFlyableFallEvent(player, distance, multiplier));
    }

    public static boolean onPlayerSpawnSet(zs player, cm pos, boolean forced) {
        return MinecraftForge.EVENT_BUS.post(new PlayerSetSpawnEvent(player, pos, forced));
    }

    public static void onPlayerClone(zs player, zs oldPlayer, boolean wasDeath) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.Clone(player, oldPlayer, wasDeath));
    }

    public static boolean onExplosionStart(aid world, ahy explosion) {
        return MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Start(world, explosion));
    }

    public static void onExplosionDetonate(aid world, ahy explosion, List<rw> list, double diameter) {
        MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Detonate(world, explosion, list));
    }

    public static boolean onCreateWorldSpawn(aid world, aig settings) {
        return MinecraftForge.EVENT_BUS.post(new WorldEvent.CreateSpawnPosition(world, settings));
    }

    public static float onLivingHeal(sf entity, float amount) {
        LivingHealEvent event = new LivingHealEvent(entity, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.getAmount();
    }

    public static boolean onPotionAttemptBrew(adz[] stacks) {
        adz[] tmp = new adz[stacks.length];
        for (int x = 0; x < tmp.length; ++x) {
            tmp[x] = adz.c((adz)stacks[x]);
        }
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre(tmp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            boolean changed = false;
            for (int x = 0; x < stacks.length; ++x) {
                changed |= adz.b((adz)tmp[x], (adz)stacks[x]);
                stacks[x] = event.getItem(x);
            }
            if (changed) {
                ForgeEventFactory.onPotionBrewed(stacks);
            }
            return true;
        }
        return false;
    }

    public static void onPotionBrewed(adz[] brewingItemStacks) {
        MinecraftForge.EVENT_BUS.post(new PotionBrewEvent.Post(brewingItemStacks));
    }

    public static boolean renderFireOverlay(zs player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.FIRE, akg.ab.u(), new cm((rw)player));
    }

    public static boolean renderWaterOverlay(zs player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.WATER, akg.j.u(), new cm((rw)player));
    }

    public static boolean renderBlockOverlay(zs player, float renderPartialTicks, RenderBlockOverlayEvent.OverlayType type, ars block, cm pos) {
        return MinecraftForge.EVENT_BUS.post(new RenderBlockOverlayEvent(player, renderPartialTicks, type, block, pos));
    }

    public static CapabilityDispatcher gatherCapabilities(aqk tileEntity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.TileEntity(tileEntity), null);
    }

    public static CapabilityDispatcher gatherCapabilities(rw entity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.Entity(entity), null);
    }

    public static CapabilityDispatcher gatherCapabilities(adx item, adz stack, ICapabilityProvider parent) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent.Item(item, stack), parent);
    }

    private static CapabilityDispatcher gatherCapabilities(AttachCapabilitiesEvent event, ICapabilityProvider parent) {
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCapabilities().size() > 0 || parent != null ? new CapabilityDispatcher(event.getCapabilities(), parent) : null;
    }

    public static boolean fireSleepingLocationCheck(zs player, cm sleepingLocation) {
        SleepingLocationCheckEvent evt = new SleepingLocationCheckEvent(player, sleepingLocation);
        MinecraftForge.EVENT_BUS.post(evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            ars state = player.l.o(player.bI);
            return state.t().isBed(state, (aih)player.l, player.bI, (rw)player);
        }
        return canContinueSleep == Event.Result.ALLOW;
    }

    public static qu<adz> onArrowNock(adz item, aid world, zs player, qr hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, item, hand, world, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return new qu(qt.c, (Object)item);
        }
        return event.getAction();
    }

    public static int onArrowLoose(adz stack, aid world, zs player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static boolean onReplaceBiomeBlocks(asp gen, int x, int z, atv primer, aid world) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks(gen, x, z, primer, world);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() != Event.Result.DENY;
    }

    @Deprecated
    public static void onChunkPopulate(boolean pre, asp gen, aid world, int x, int z, boolean hasVillageGenerated) {
        MinecraftForge.EVENT_BUS.post(pre ? new PopulateChunkEvent.Pre(gen, world, world.r, x, z, hasVillageGenerated) : new PopulateChunkEvent.Post(gen, world, world.r, x, z, hasVillageGenerated));
    }

    public static void onChunkPopulate(boolean pre, asp gen, aid world, Random rand, int x, int z, boolean hasVillageGenerated) {
        MinecraftForge.EVENT_BUS.post(pre ? new PopulateChunkEvent.Pre(gen, world, rand, x, z, hasVillageGenerated) : new PopulateChunkEvent.Post(gen, world, rand, x, z, hasVillageGenerated));
    }

    public static bap loadLootTable(kn name, bap table) {
        LootTableLoadEvent event = new LootTableLoadEvent(name, table);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return bap.a;
        }
        return event.getTable();
    }

    public static boolean canCreateFluidSource(aid world, cm pos, ars state, boolean def) {
        BlockEvent.CreateFluidSourceEvent evt = new BlockEvent.CreateFluidSourceEvent(world, pos, state);
        MinecraftForge.EVENT_BUS.post(evt);
        Event.Result result = evt.getResult();
        return result == Event.Result.DEFAULT ? def : result == Event.Result.ALLOW;
    }
}

