/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final aid world;
    private final cm pos;
    private final ars state;

    public BlockEvent(aid world, cm pos, ars state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public aid getWorld() {
        return this.world;
    }

    public cm getPos() {
        return this.pos;
    }

    public ars getState() {
        return this.state;
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends BlockEvent {
        public CreateFluidSourceEvent(aid world, cm pos, ars state) {
            super(world, pos, state);
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<ct> notifiedSides;

        public NeighborNotifyEvent(aid world, cm pos, ars state, EnumSet<ct> notifiedSides) {
            super(world, pos, state);
            this.notifiedSides = notifiedSides;
        }

        public EnumSet<ct> getNotifiedSides() {
            return this.notifiedSides;
        }
    }

    @Cancelable
    public static class MultiPlaceEvent
    extends PlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public MultiPlaceEvent(List<BlockSnapshot> blockSnapshots, ars placedAgainst, zs player) {
            super(blockSnapshots.get(0), placedAgainst, player);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created MultiPlaceEvent - [PlacedAgainst: %s ][ItemInHand: %s ][Player: %s ]\n", placedAgainst, this.getItemInHand(), player);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class PlaceEvent
    extends BlockEvent {
        private final zs player;
        private final adz itemInHand;
        private final BlockSnapshot blockSnapshot;
        private final ars placedBlock;
        private final ars placedAgainst;

        public PlaceEvent(BlockSnapshot blockSnapshot, ars placedAgainst, zs player) {
            super(blockSnapshot.getWorld(), blockSnapshot.getPos(), blockSnapshot.getCurrentBlock());
            this.player = player;
            this.itemInHand = player.cf();
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created PlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][ItemStack: %s ][Player: %s ]\n", this.getPlacedBlock(), placedAgainst, this.getItemInHand(), player);
            }
        }

        public zs getPlayer() {
            return this.player;
        }

        public adz getItemInHand() {
            return this.itemInHand;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public ars getPlacedBlock() {
            return this.placedBlock;
        }

        public ars getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final zs player;
        private int exp;

        public BreakEvent(aid world, cm pos, ars state, zs player) {
            super(world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state.t(), player, (aih)world, pos) || state.t().canSilkHarvest(world, pos, world.o(pos), player) && agx.a((agv)agz.r, (adz)player.cf()) > 0) {
                this.exp = 0;
            } else {
                int bonusLevel = agx.a((agv)agz.t, (adz)player.cf());
                this.exp = state.t().getExpDrop(state, (aih)world, pos, bonusLevel);
            }
        }

        public zs getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        private final int fortuneLevel;
        private final List<adz> drops;
        private final boolean isSilkTouching;
        private float dropChance;
        private final zs harvester;

        public HarvestDropsEvent(aid world, cm pos, ars state, int fortuneLevel, float dropChance, List<adz> drops, zs harvester, boolean isSilkTouching) {
            super(world, pos, state);
            this.fortuneLevel = fortuneLevel;
            this.setDropChance(dropChance);
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }

        public int getFortuneLevel() {
            return this.fortuneLevel;
        }

        public List<adz> getDrops() {
            return this.drops;
        }

        public boolean isSilkTouching() {
            return this.isSilkTouching;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public void setDropChance(float dropChance) {
            this.dropChance = dropChance;
        }

        public zs getHarvester() {
            return this.harvester;
        }
    }
}

