/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends akf
implements IFluidBlock {
    protected static final Map<akf, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<akf, Boolean> displacements = Maps.newHashMap();
    public static final ash LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final ImmutableList<IUnlistedProperty<Float>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected ahv renderLayer = ahv.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, axx material) {
        super(material);
        this.a(true);
        this.q();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.w(this.A.b().a((asi)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected art b() {
        return new ExtendedBlockState(this, new asi[]{LEVEL}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public int e(ars state) {
        return (Integer)state.c((asi)LEVEL);
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(ahv renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(aih world, cm pos) {
        if (world.d(pos)) {
            return true;
        }
        ars state = world.o(pos);
        if (state.t() == this) {
            return false;
        }
        if (this.displacements.containsKey(state.t())) {
            return this.displacements.get(state.t());
        }
        axx material = state.a();
        if (material.c() || material == axx.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(aid world, cm pos) {
        if (world.d(pos)) {
            return true;
        }
        ars state = world.o(pos);
        akf block = state.t();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                block.b(world, pos, state, 0);
                return true;
            }
            return false;
        }
        axx material = state.a();
        if (material.c() || material == axx.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((aih)world, pos);
        if (density == Integer.MAX_VALUE) {
            block.b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(aih var1, cm var2);

    public abstract boolean a(ars var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void c(aid world, cm pos, ars state) {
        world.a(pos, (akf)this, this.tickRate);
    }

    public void a(ars state, aid world, cm pos, akf neighborBlock) {
        world.a(pos, (akf)this, this.tickRate);
    }

    public boolean s() {
        return false;
    }

    public boolean b(aih world, cm pos) {
        return true;
    }

    public adx a(ars state, Random rand, int fortune) {
        return null;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(aid world) {
        return this.tickRate;
    }

    public bcb a(aid world, cm pos, rw entity, bcb vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        bcb vec_flow = this.getFlowVector((aih)world, pos);
        return vec.b(vec_flow.b * (double)(this.quantaPerBlock * 4), vec_flow.c * (double)(this.quantaPerBlock * 4), vec_flow.d * (double)(this.quantaPerBlock * 4));
    }

    public int getLightValue(ars state, aih world, cm pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = (Integer)state.c((asi)LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean b(ars state) {
        return false;
    }

    public boolean c(ars state) {
        return false;
    }

    public int c(ars state, aih world, cm pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.a(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public ahv f() {
        return this.renderLayer;
    }

    public boolean a(ars state, aih world, cm pos, ct side) {
        ars neighbor = world.o(pos.a(side));
        if (neighbor.a() == state.a()) {
            return false;
        }
        if (this.densityDir == -1 && side == ct.b) {
            return true;
        }
        if (this.densityDir == 1 && side == ct.a) {
            return true;
        }
        return super.a(state, world, pos, side);
    }

    public ars getExtendedState(ars oldState, aih worldIn, cm pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(worldIn, pos)));
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        height[1][1] = this.getFluidHeightForRender(worldIn, pos);
        if (height[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                for (int j2 = 0; j2 < 2; ++j2) {
                    corner[i][j2] = 1.0f;
                }
            }
        } else {
            int j3;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j3 = 0; j3 < 3; ++j3) {
                    if (i == 1 && j3 == 1) continue;
                    height[i][j3] = this.getFluidHeightForRender(worldIn, pos.a(i - 1, 0, j3 - 1));
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j3 = 0; j3 < 2; ++j3) {
                    corner[i][j3] = this.getFluidHeightAverage(height[i][j3], height[i][j3 + 1], height[i + 1][j3], height[i + 1][j3 + 1]);
                }
            }
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static final int getDensity(aih world, cm pos) {
        akf block = world.o(pos).t();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(aih world, cm pos) {
        akf block = world.o(pos).t();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(aih world, cm pos) {
        ars state = world.o(pos);
        if (!state.a().d()) {
            return -1000.0;
        }
        bcb vec = ((BlockFluidBase)state.t()).getFlowVector(world, pos);
        return vec.b == 0.0 && vec.d == 0.0 ? -1000.0 : Math.atan2(vec.d, vec.b) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(aih world, cm pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(aih world, cm pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(aih world, cm pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 0.875f) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(aih world, cm pos) {
        ars here = world.o(pos);
        ars up = world.o(pos.c(this.densityDir));
        if (here.t() == this) {
            if (up.a().d() || up.t() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.e(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.t() instanceof anb) {
            return Math.min(1.0f - anb.e((int)((Integer)here.c((asi)anb.b))), 0.875f);
        }
        return !here.a().a() && up.t() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public bcb getFlowVector(aih world, cm pos) {
        bcb vec = new bcb(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.p();
            int z2 = pos.r();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            cm pos2 = new cm(x2, pos.q(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.o(pos2).a().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
        }
        if (world.o(pos.a()).t() == this) {
            boolean flag;
            boolean bl = flag = this.a(world, pos.a(0, 0, -1), ct.c) || this.a(world, pos.a(0, 0, 1), ct.d) || this.a(world, pos.a(-1, 0, 0), ct.e) || this.a(world, pos.a(1, 0, 0), ct.f) || this.a(world, pos.a(0, 1, -1), ct.c) || this.a(world, pos.a(0, 1, 1), ct.d) || this.a(world, pos.a(-1, 1, 0), ct.e) || this.a(world, pos.a(1, 1, 0), ct.f);
            if (flag) {
                vec = vec.a().b(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(aid world, cm pos) {
        int quantaRemaining = this.getQuantaValue((aih)world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    public bby a(ars blockState, aid worldIn, cm pos) {
        return k;
    }

    static {
        defaultDisplacements.put((akf)akg.ao, false);
        defaultDisplacements.put((akf)akg.ap, false);
        defaultDisplacements.put((akf)akg.aq, false);
        defaultDisplacements.put((akf)akg.ar, false);
        defaultDisplacements.put((akf)akg.as, false);
        defaultDisplacements.put((akf)akg.at, false);
        defaultDisplacements.put(akg.bd, false);
        defaultDisplacements.put(akg.cw, false);
        defaultDisplacements.put(akg.aO, false);
        defaultDisplacements.put(akg.aP, false);
        defaultDisplacements.put(akg.aQ, false);
        defaultDisplacements.put(akg.aR, false);
        defaultDisplacements.put(akg.aS, false);
        defaultDisplacements.put(akg.aT, false);
        defaultDisplacements.put(akg.bz, false);
        defaultDisplacements.put(akg.bo, false);
        defaultDisplacements.put(akg.bp, false);
        defaultDisplacements.put(akg.bq, false);
        defaultDisplacements.put(akg.br, false);
        defaultDisplacements.put(akg.bs, false);
        defaultDisplacements.put(akg.bt, false);
        defaultDisplacements.put(akg.aB, false);
        defaultDisplacements.put(akg.az, false);
        defaultDisplacements.put(akg.ch, false);
        defaultDisplacements.put(akg.ci, false);
        defaultDisplacements.put(akg.au, false);
        defaultDisplacements.put(akg.bi, false);
        defaultDisplacements.put(akg.bj, false);
        defaultDisplacements.put((akf)akg.cH, false);
        defaultDisplacements.put((akf)akg.aY, false);
        defaultDisplacements.put(akg.bF, false);
        defaultDisplacements.put(akg.bZ, false);
        defaultDisplacements.put(akg.cv, false);
        defaultDisplacements.put(akg.cK, false);
        defaultDisplacements.put(akg.cL, false);
        defaultDisplacements.put(akg.ba, false);
        defaultDisplacements.put((akf)akg.aA, false);
        defaultDisplacements.put(akg.an, false);
        defaultDisplacements.put(akg.ax, false);
        defaultDisplacements.put((akf)akg.aM, false);
        LEVEL = ash.a((String)"level", (int)0, (int)15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i = 0; i < 4; ++i) {
            BlockFluidBase.LEVEL_CORNERS[i] = new PropertyFloat("level_corner_" + i);
            builder.add((Object)LEVEL_CORNERS[i]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }
}

