/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.List;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends adx
implements IFluidContainerItem {
    private final int capacity;
    private final adz empty;
    private final boolean nbtSensitive;

    public UniversalBucket() {
        this(1000, new adz(aeb.ay), false);
    }

    public UniversalBucket(int capacity, adz empty, boolean nbtSensitive) {
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        this.d(1);
        this.a(acz.f);
        alh.c.a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    @SideOnly(value=Side.CLIENT)
    public void a(adx itemIn, acz tab, List<adz> subItems) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fs;
            adz stack;
            if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || fluid.getName().equals("milk") || this.fill(stack = new adz((adx)this), fs = new FluidStack(fluid, this.getCapacity()), true) != fs.amount) continue;
            subItems.add(stack);
        }
    }

    public String a(adz stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (this.getEmpty() != null) {
                return this.getEmpty().q();
            }
            return super.a(stack);
        }
        String unloc = this.j(stack);
        if (dl.c((String)(unloc + "." + fluidStack.getFluid().getName()))) {
            return dl.a((String)(unloc + "." + fluidStack.getFluid().getName()));
        }
        return dl.a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public qu<adz> a(adz itemstack, aid world, zs player, qr hand) {
        cm targetPos;
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return qu.newResult((qt)qt.b, (Object)itemstack);
        }
        bbz mop = this.a(world, player, false);
        if (mop == null || mop.a != bbz.a.b) {
            return qu.newResult((qt)qt.b, (Object)itemstack);
        }
        cm clickPos = mop.a();
        if (world.a(player, clickPos) && player.a(targetPos = clickPos.a(mop.b), mop.b, itemstack) && FluidUtil.tryPlaceFluid(player, player.e(), fluidStack, targetPos) && !player.bL.d) {
            adz emptyStack;
            player.b(nw.b((adx)this));
            --itemstack.b;
            adz adz2 = emptyStack = this.getEmpty() != null ? this.getEmpty().k() : new adz((adx)this);
            if (itemstack.b <= 0) {
                return qu.newResult((qt)qt.a, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return qu.newResult((qt)qt.a, (Object)itemstack);
        }
        return qu.newResult((qt)qt.c, (Object)itemstack);
    }

    @Deprecated
    public boolean tryPlaceFluid(akf block, aid worldIn, cm pos) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            return FluidUtil.tryPlaceFluid(null, worldIn, new FluidStack(fluidBlock.getFluid(), 1000), pos);
        }
        if (block.u().a() == axx.h) {
            FluidUtil.tryPlaceFluid(null, worldIn, new FluidStack(FluidRegistry.WATER, 1000), pos);
        } else if (block.u().a() == axx.i) {
            FluidUtil.tryPlaceFluid(null, worldIn, new FluidStack(FluidRegistry.LAVA, 1000), pos);
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        adz emptyBucket = event.getEmptyBucket();
        if (emptyBucket == null || !emptyBucket.a(this.getEmpty()) || this.isNbtSensitive() && adz.a((adz)emptyBucket, (adz)this.getEmpty())) {
            return;
        }
        bbz target = event.getTarget();
        if (target == null || target.a != bbz.a.b) {
            return;
        }
        aid world = event.getWorld();
        cm pos = target.a();
        adz singleBucket = emptyBucket.k();
        singleBucket.b = 1;
        adz filledBucket = FluidUtil.tryPickUpFluid(singleBucket, event.getEntityPlayer(), world, pos, target.b);
        if (filledBucket != null) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledBucket);
        } else {
            event.setCanceled(true);
        }
    }

    public static adz getFilledBucket(UniversalBucket item, Fluid fluid) {
        adz stack = new adz((adx)item);
        item.fill(stack, new FluidStack(fluid, item.getCapacity()), true);
        return stack;
    }

    @Override
    public FluidStack getFluid(adz container) {
        return FluidStack.loadFluidStackFromNBT(container.o());
    }

    @Override
    public int getCapacity(adz container) {
        return this.getCapacity();
    }

    @Override
    public int fill(adz container, FluidStack resource, boolean doFill) {
        if (container.b != 1) {
            return 0;
        }
        if (resource == null || resource.amount < this.getCapacity()) {
            return 0;
        }
        if (this.getFluid(container) != null) {
            return 0;
        }
        if (FluidRegistry.getBucketFluids().contains(resource.getFluid())) {
            if (doFill) {
                dr tag = container.o();
                if (tag == null) {
                    tag = new dr();
                }
                resource.writeToNBT(tag);
                container.d(tag);
            }
            return this.getCapacity();
        }
        if (resource.getFluid() == FluidRegistry.WATER) {
            if (doFill) {
                container.deserializeNBT(new adz(aeb.az).serializeNBT());
            }
            return this.getCapacity();
        }
        if (resource.getFluid() == FluidRegistry.LAVA) {
            if (doFill) {
                container.deserializeNBT(new adz(aeb.aA).serializeNBT());
            }
            return this.getCapacity();
        }
        return 0;
    }

    @Override
    public FluidStack drain(adz container, int maxDrain, boolean doDrain) {
        if (container.b != 1) {
            return null;
        }
        if (maxDrain < this.getCapacity(container)) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (doDrain && fluidStack != null) {
            if (this.getEmpty() != null) {
                container.deserializeNBT(this.getEmpty().serializeNBT());
            } else {
                container.b = 0;
            }
        }
        return fluidStack;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public adz getEmpty() {
        return this.empty;
    }

    public boolean isNbtSensitive() {
        return this.nbtSensitive;
    }

    public ICapabilityProvider initCapabilities(adz stack, dr nbt) {
        return new FluidBucketWrapper(stack);
    }
}

