/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class BlamingTransformer
implements IClassTransformer {
    private static final Map<String, String> classMap = new HashMap<String, String>();
    private static final Set<String> naughtyMods = new HashSet<String>();
    private static final Set<String> naughtyClasses = new TreeSet<String>();
    private static final Set<String> orphanNaughtyClasses = new HashSet<String>();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassReader classReader = new ClassReader(bytes);
        VersionVisitor visitor = new VersionVisitor();
        classReader.accept((ClassVisitor)visitor, 3);
        return bytes;
    }

    public static void blame(String modId, String cls) {
        naughtyClasses.add(cls);
        naughtyMods.add(modId);
        FMLLog.severe("Unsupported class format in mod %s: class %s", modId, cls);
    }

    private static void checkPendingNaughty() {
        ImmutableSet.Builder toRemove = ImmutableSet.builder();
        for (String cls : orphanNaughtyClasses) {
            if (!classMap.containsKey(cls)) continue;
            String modId = classMap.get(cls);
            BlamingTransformer.blame(modId, cls);
            toRemove.add((Object)cls);
        }
        orphanNaughtyClasses.removeAll((Collection<?>)toRemove.build());
    }

    public static void addClasses(String modId, Set<String> classList) {
        for (String cls : classList) {
            classMap.put(cls, modId);
        }
        BlamingTransformer.checkPendingNaughty();
    }

    public static void onCrash(StringBuilder builder) {
        BlamingTransformer.checkPendingNaughty();
        if (!naughtyClasses.isEmpty()) {
            builder.append("\n*** ATTENTION: detected classes with unsupported format ***\n");
            builder.append("*** DO NOT SUBMIT THIS CRASH REPORT TO FORGE ***\n\n");
            if (!naughtyMods.isEmpty()) {
                builder.append("Contact authors of the following mods: \n");
                for (String modId : naughtyMods) {
                    builder.append("  ").append(modId).append("\n");
                }
            }
            if (!orphanNaughtyClasses.isEmpty()) {
                builder.append("Unidentified unsupported classes: \n");
                for (String cls : orphanNaughtyClasses) {
                    builder.append("  ").append(cls).append("\n");
                }
            }
            builder.append('\n');
        }
    }

    public static class VersionVisitor
    extends ClassVisitor {
        public VersionVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (version == 52 && !SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8) || version == 51 && !SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_7)) {
                if (classMap.containsKey(name)) {
                    BlamingTransformer.blame((String)classMap.get(name), name);
                } else {
                    orphanNaughtyClasses.add(name);
                }
            }
        }
    }
}

