/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ForgeGuiFactory
implements IModGuiFactory {
    @Override
    public void initialize(bes minecraftInstance) {
    }

    @Override
    public Class<? extends bho> mainConfigGuiClass() {
        return ForgeConfigGui.class;
    }

    @Override
    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    @Override
    public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
        return null;
    }

    public static class ForgeConfigGui
    extends GuiConfig {
        public ForgeConfigGui(bho parentScreen) {
            super(parentScreen, ForgeConfigGui.getConfigElements(), "forge", false, false, cah.a((String)"forge.configgui.forgeConfigTitle", (Object[])new Object[0]));
        }

        private static List<IConfigElement> getConfigElements() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            list.add(new DummyConfigElement.DummyCategoryElement("forgeCfg", "forge.configgui.ctgy.forgeGeneralConfig", GeneralEntry.class));
            list.add(new DummyConfigElement.DummyCategoryElement("forgeClientCfg", "forge.configgui.ctgy.forgeClientConfig", ClientEntry.class));
            list.add(new DummyConfigElement.DummyCategoryElement("forgeChunkLoadingCfg", "forge.configgui.ctgy.forgeChunkLoadingConfig", ChunkLoaderEntry.class));
            list.add(new DummyConfigElement.DummyCategoryElement("forgeVersionCheckCfg", "forge.configgui.ctgy.VersionCheckConfig", VersionCheckEntry.class));
            return list;
        }

        public static class ModIDEntry
        extends GuiConfigEntries.SelectValueEntry {
            public ModIDEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop, ModIDEntry.getSelectableValues());
                if (this.selectableValues.size() == 0) {
                    this.btnValue.l = false;
                }
            }

            private static Map<Object, String> getSelectableValues() {
                TreeMap<Object, String> selectableValues = new TreeMap<Object, String>();
                for (ModContainer mod : Loader.instance().getActiveModList()) {
                    if (mod.isImmutable() || mod.getMod() == null) continue;
                    selectableValues.put(mod.getModId(), mod.getName());
                }
                return selectableValues;
            }

            @Override
            public void onGuiClosed() {
                Object modObject = Loader.instance().getModObjectList().get((Object)Loader.instance().getIndexedModList().get(this.currentValue));
                int maxTickets = 200;
                int maxChunks = 25;
                if (modObject != null) {
                    this.owningEntryList.saveConfigElements();
                    for (IConfigElement ice : this.owningScreen.configElements) {
                        if ("maximumTicketCount".equals(ice.getName())) {
                            maxTickets = Integer.valueOf(ice.get().toString());
                            continue;
                        }
                        if (!"maximumChunksPerTicket".equals(ice.getName())) continue;
                        maxChunks = Integer.valueOf(ice.get().toString());
                    }
                    ForgeChunkManager.addConfigProperty(modObject, "maximumTicketCount", String.valueOf(maxTickets), Property.Type.INTEGER);
                    ForgeChunkManager.addConfigProperty(modObject, "maximumChunksPerTicket", String.valueOf(maxChunks), Property.Type.INTEGER);
                    if (this.owningScreen.parentScreen instanceof GuiConfig) {
                        GuiConfig superParent = (GuiConfig)this.owningScreen.parentScreen;
                        ConfigCategory modCtgy = ForgeChunkManager.getConfigFor(modObject);
                        modCtgy.setPropertyOrder(ForgeChunkManager.MOD_PROP_ORDER);
                        ConfigElement modConfig = new ConfigElement(modCtgy);
                        boolean found = false;
                        for (IConfigElement ice : superParent.configElements) {
                            if (!ice.getName().equals(this.currentValue)) continue;
                            found = true;
                        }
                        if (!found) {
                            superParent.configElements.add(modConfig);
                        }
                        superParent.needsRefresh = true;
                        superParent.b();
                    }
                }
            }
        }

        public static class AddModOverrideEntry
        extends GuiConfigEntries.CategoryEntry {
            public AddModOverrideEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bho buildChildScreen() {
                ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
                list.add(new DummyConfigElement("modID", "", ConfigGuiType.STRING, "forge.configgui.modID").setCustomListEntryClass(ModIDEntry.class));
                list.add(new ConfigElement(new Property("maximumTicketCount", "200", Property.Type.INTEGER, "forge.configgui.maximumTicketCount")));
                list.add(new ConfigElement(new Property("maximumChunksPerTicket", "25", Property.Type.INTEGER, "forge.configgui.maximumChunksPerTicket")));
                return new GuiConfig((bho)this.owningScreen, list, this.owningScreen.modID, this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, this.owningScreen.title, cah.a((String)"forge.configgui.ctgy.forgeChunkLoadingAddModConfig", (Object[])new Object[0]));
            }

            @Override
            public boolean isChanged() {
                return false;
            }
        }

        public static class ModOverridesEntry
        extends GuiConfigEntries.CategoryEntry {
            public ModOverridesEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bho buildChildScreen() {
                ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
                list.add(new DummyConfigElement.DummyCategoryElement("addForgeChunkLoadingModCfg", "forge.configgui.ctgy.forgeChunkLoadingAddModConfig", AddModOverrideEntry.class));
                for (ConfigCategory cc : ForgeChunkManager.getModCategories()) {
                    list.add(new ConfigElement(cc));
                }
                return new GuiConfig((bho)this.owningScreen, list, this.owningScreen.modID, this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, this.owningScreen.title, cah.a((String)"forge.configgui.ctgy.forgeChunkLoadingModConfig", (Object[])new Object[0]));
            }

            @Override
            public boolean enabled() {
                for (GuiConfigEntries.IConfigEntry entry : this.owningEntryList.listEntries) {
                    if (!entry.getName().equals("enabled") || !(entry instanceof GuiConfigEntries.BooleanEntry)) continue;
                    return Boolean.valueOf(entry.getCurrentValue().toString());
                }
                return true;
            }

            @Override
            public boolean isChanged() {
                if (this.childScreen instanceof GuiConfig) {
                    GuiConfig child = (GuiConfig)this.childScreen;
                    return child.entryList.listEntries.size() != child.initEntries.size() || child.entryList.hasChangedEntry(true);
                }
                return false;
            }

            @Override
            public void undoChanges() {
                if (this.childScreen instanceof GuiConfig) {
                    GuiConfig child = (GuiConfig)this.childScreen;
                    for (GuiConfigEntries.IConfigEntry ice : child.entryList.listEntries) {
                        if (child.initEntries.contains(ice) || !ForgeChunkManager.getConfig().hasCategory(ice.getName())) continue;
                        ForgeChunkManager.getConfig().removeCategory(ForgeChunkManager.getConfig().getCategory(ice.getName()));
                    }
                    child.entryList.listEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(child.initEntries);
                }
            }
        }

        public static class VersionCheckEntry
        extends GuiConfigEntries.CategoryEntry {
            public VersionCheckEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bho buildChildScreen() {
                ConfigCategory cfg = ForgeModContainer.getConfig().getCategory("version_checking");
                HashMap<String, Property> values = new HashMap<String, Property>(cfg.getValues());
                values.remove("Global");
                Property global = ForgeModContainer.getConfig().get("version_checking", "Global", true);
                ArrayList<Property> props = new ArrayList<Property>();
                for (ModContainer mod : ForgeVersion.gatherMods().keySet()) {
                    values.remove(mod.getModId());
                    props.add(ForgeModContainer.getConfig().get("version_checking", mod.getModId(), true));
                }
                props.addAll(values.values());
                Collections.sort(props, new Comparator<Property>(){

                    @Override
                    public int compare(Property o1, Property o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
                list.add(new ConfigElement(global));
                for (Property prop : props) {
                    list.add(new ConfigElement(prop));
                }
                return new GuiConfig((bho)this.owningScreen, list, this.owningScreen.modID, "version_checking", true, true, GuiConfig.getAbridgedConfigPath(ForgeModContainer.getConfig().toString()));
            }
        }

        public static class ChunkLoaderEntry
        extends GuiConfigEntries.CategoryEntry {
            public ChunkLoaderEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bho buildChildScreen() {
                ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
                list.add(new DummyConfigElement.DummyCategoryElement("forgeChunkLoadingModCfg", "forge.configgui.ctgy.forgeChunkLoadingModConfig", ModOverridesEntry.class));
                list.addAll(new ConfigElement(ForgeChunkManager.getDefaultsCategory()).getChildElements());
                return new GuiConfig(this.owningScreen, list, this.owningScreen.modID, "chunkLoader", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, GuiConfig.getAbridgedConfigPath(ForgeChunkManager.getConfig().toString()), cah.a((String)"forge.configgui.ctgy.forgeChunkLoadingConfig", (Object[])new Object[0]));
            }
        }

        public static class ClientEntry
        extends GuiConfigEntries.CategoryEntry {
            public ClientEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bho buildChildScreen() {
                return new GuiConfig((bho)this.owningScreen, new ConfigElement(ForgeModContainer.getConfig().getCategory("client")).getChildElements(), this.owningScreen.modID, "client", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, GuiConfig.getAbridgedConfigPath(ForgeModContainer.getConfig().toString()));
            }
        }

        public static class GeneralEntry
        extends GuiConfigEntries.CategoryEntry {
            public GeneralEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
                super(owningScreen, owningEntryList, prop);
            }

            @Override
            protected bho buildChildScreen() {
                return new GuiConfig((bho)this.owningScreen, new ConfigElement(ForgeModContainer.getConfig().getCategory("general")).getChildElements(), this.owningScreen.modID, "general", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, GuiConfig.getAbridgedConfigPath(ForgeModContainer.getConfig().toString()));
            }
        }
    }
}

