/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.config;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.ITypeAdapter;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.config.TypeAdapters;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import org.apache.logging.log4j.Level;

public class ConfigManager {
    private static Map<String, Multimap<Config.Type, ASMDataTable.ASMData>> asm_data = Maps.newHashMap();
    private static Map<Class<?>, ITypeAdapter> ADAPTERS = Maps.newHashMap();
    private static Map<Class<?>, ITypeAdapter.Map> MAP_ADAPTERS = Maps.newHashMap();
    private static Map<String, Configuration> CONFIGS = Maps.newHashMap();
    private static final Joiner NEW_LINE;
    private static final Joiner PIPE;

    private static void register(Class<?> cls, ITypeAdapter adpt) {
        ADAPTERS.put(cls, adpt);
        if (adpt instanceof ITypeAdapter.Map) {
            MAP_ADAPTERS.put(cls, (ITypeAdapter.Map)adpt);
        }
    }

    public static void loadData(ASMDataTable data) {
        FMLLog.fine("Loading @Config anotation data", new Object[0]);
        for (ASMDataTable.ASMData target : data.getAll(Config.class.getName())) {
            ModAnnotation.EnumHolder tholder;
            String modid = (String)target.getAnnotationInfo().get("modid");
            ArrayListMultimap map = asm_data.get(modid);
            if (map == null) {
                map = ArrayListMultimap.create();
                asm_data.put(modid, (Multimap<Config.Type, ASMDataTable.ASMData>)map);
            }
            Config.Type type = (tholder = (ModAnnotation.EnumHolder)target.getAnnotationInfo().get("type")) == null ? Config.Type.INSTANCE : Config.Type.valueOf(tholder.getValue());
            map.put((Object)type, (Object)target);
        }
    }

    public static void load(String modid, Config.Type type) {
        FMLLog.fine("Attempting to inject @Config classes into %s for type %s", new Object[]{modid, type});
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        File configDir = Loader.instance().getConfigDir();
        Multimap<Config.Type, ASMDataTable.ASMData> map = asm_data.get(modid);
        if (map == null) {
            return;
        }
        for (ASMDataTable.ASMData targ : map.get((Object)type)) {
            try {
                File file;
                Configuration cfg;
                String category;
                Class<?> cls = Class.forName(targ.getClassName(), true, mcl);
                String name = (String)targ.getAnnotationInfo().get("name");
                if (name == null) {
                    name = modid;
                }
                if ((category = (String)targ.getAnnotationInfo().get("category")) == null) {
                    category = "general";
                }
                if ((cfg = CONFIGS.get((file = new File(configDir, name + ".cfg")).getAbsolutePath())) == null) {
                    cfg = new Configuration(file);
                    cfg.load();
                    CONFIGS.put(file.getAbsolutePath(), cfg);
                }
                ConfigManager.createConfig(cfg, cls, modid, type == Config.Type.INSTANCE, category);
                cfg.save();
            }
            catch (Exception e) {
                FMLLog.log(Level.ERROR, e, "An error occurred trying to load a config for %s into %s", modid, targ.getClassName());
                throw new LoaderException(e);
            }
        }
    }

    private static void createConfig(Configuration cfg, Class<?> cls, String modid, boolean isStatic, String category) {
        for (Field f : cls.getDeclaredFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) != isStatic) continue;
            ConfigManager.createConfig(modid, category, cfg, f.getType(), f, null);
        }
    }

    private static void createConfig(String modid, String category, Configuration cfg, Class<?> ftype, Field f, Object instance) {
        String sub;
        ITypeAdapter adapter;
        Property prop = null;
        String comment = null;
        Config.Comment ca = f.getAnnotation(Config.Comment.class);
        if (ca != null) {
            comment = NEW_LINE.join((Object[])ca.value());
        }
        String langKey = modid + "." + category + "." + f.getName().toLowerCase(Locale.ENGLISH);
        Config.LangKey la = f.getAnnotation(Config.LangKey.class);
        if (la != null) {
            langKey = la.value();
        }
        if ((adapter = ADAPTERS.get(ftype)) != null) {
            if (category.isEmpty()) {
                throw new RuntimeException("Can not specify a primitive field when the category is empty: " + f.getDeclaringClass() + "/" + f.getName());
            }
            prop = adapter.getProp(cfg, category, f, instance, comment);
            ConfigManager.set(instance, f, adapter.getValue(prop));
        } else if (ftype.getSuperclass() == Enum.class) {
            if (category.isEmpty()) {
                throw new RuntimeException("Can not specify a primitive field when the category is empty: " + f.getDeclaringClass() + "/" + f.getName());
            }
            Enum enu = (Enum)ConfigManager.get(instance, f);
            prop = cfg.get(category, ConfigManager.getName(f), enu.name(), comment);
            prop.setValidationPattern(ConfigManager.makePattern(ftype));
            ConfigManager.set(instance, f, Enum.valueOf(ftype, prop.getString()));
        } else if (ftype == Map.class) {
            if (category.isEmpty()) {
                throw new RuntimeException("Can not specify a primitive field when the category is empty: " + f.getDeclaringClass() + "/" + f.getName());
            }
            sub = category + "." + ConfigManager.getName(f).toLowerCase(Locale.ENGLISH);
            Map m = (Map)ConfigManager.get(instance, f);
            ParameterizedType type = (ParameterizedType)f.getGenericType();
            Type mtype = type.getActualTypeArguments()[1];
            cfg.getCategory(sub).setComment(comment);
            for (Map.Entry e : m.entrySet()) {
                ITypeAdapter.Map adpt = MAP_ADAPTERS.get(mtype);
                if (adpt != null) {
                    prop = adpt.getProp(cfg, sub, (String)e.getKey(), e.getValue());
                } else if (mtype instanceof Class && ((Class)mtype).getSuperclass() == Enum.class) {
                    prop = TypeAdapters.Str.getProp(cfg, sub, (String)e.getKey(), ((Enum)e.getValue()).name());
                    prop.setValidationPattern(ConfigManager.makePattern((Class)mtype));
                } else {
                    throw new RuntimeException("Unknown type in map! " + f.getDeclaringClass() + "/" + f.getName() + " " + mtype);
                }
                prop.setLanguageKey(langKey + "." + ((String)e.getKey()).toLowerCase(Locale.ENGLISH));
            }
            prop = null;
        } else if (ftype.getSuperclass() == Object.class) {
            sub = (category.isEmpty() ? "" : category + ".") + ConfigManager.getName(f).toLowerCase(Locale.ENGLISH);
            cfg.getCategory(sub).setComment(comment);
            Object sinst = ConfigManager.get(instance, f);
            for (Field sf : ftype.getDeclaredFields()) {
                if (!Modifier.isPublic(sf.getModifiers())) continue;
                ConfigManager.createConfig(modid, sub, cfg, sf.getType(), sf, sinst);
            }
        } else {
            throw new RuntimeException("Unknown type in config! " + f.getDeclaringClass() + "/" + f.getName() + " " + ftype);
        }
        if (prop != null) {
            Config.RangeDouble da;
            prop.setLanguageKey(langKey);
            Config.RangeInt ia = f.getAnnotation(Config.RangeInt.class);
            if (ia != null) {
                prop.setMinValue(ia.min());
                prop.setMaxValue(ia.max());
                if (comment != null) {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{comment, "Min: " + ia.min(), "Max: " + ia.max()}));
                } else {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{"Min: " + ia.min(), "Max: " + ia.max()}));
                }
            }
            if ((da = f.getAnnotation(Config.RangeDouble.class)) != null) {
                prop.setMinValue(da.min());
                prop.setMaxValue(da.max());
                if (comment != null) {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{comment, "Min: " + da.min(), "Max: " + da.max()}));
                } else {
                    prop.setComment(NEW_LINE.join((Object[])new String[]{"Min: " + da.min(), "Max: " + da.max()}));
                }
            }
        }
    }

    private static void set(Object instance, Field f, Object v) {
        try {
            f.set(instance, v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object get(Object instance, Field f) {
        try {
            return f.get(instance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Pattern makePattern(Class<? extends Enum> cls) {
        ArrayList lst = Lists.newArrayList();
        for (Enum e : cls.getEnumConstants()) {
            lst.add(e.name());
        }
        return Pattern.compile(PIPE.join((Iterable)lst));
    }

    private static String getName(Field f) {
        if (f.isAnnotationPresent(Config.Name.class)) {
            return f.getAnnotation(Config.Name.class).value();
        }
        return f.getName();
    }

    static {
        ConfigManager.register(Boolean.TYPE, TypeAdapters.bool);
        ConfigManager.register(boolean[].class, TypeAdapters.boolA);
        ConfigManager.register(Boolean.class, TypeAdapters.Bool);
        ConfigManager.register(Boolean[].class, TypeAdapters.BoolA);
        ConfigManager.register(Float.TYPE, TypeAdapters.flt);
        ConfigManager.register(float[].class, TypeAdapters.fltA);
        ConfigManager.register(Float.class, TypeAdapters.Flt);
        ConfigManager.register(Float[].class, TypeAdapters.FltA);
        ConfigManager.register(Double.TYPE, TypeAdapters.dbl);
        ConfigManager.register(double[].class, TypeAdapters.dblA);
        ConfigManager.register(Double.class, TypeAdapters.Dbl);
        ConfigManager.register(Double[].class, TypeAdapters.DblA);
        ConfigManager.register(Byte.TYPE, TypeAdapters.byt);
        ConfigManager.register(byte[].class, TypeAdapters.bytA);
        ConfigManager.register(Byte.class, TypeAdapters.Byt);
        ConfigManager.register(Byte[].class, TypeAdapters.BytA);
        ConfigManager.register(Character.TYPE, TypeAdapters.chr);
        ConfigManager.register(char[].class, TypeAdapters.chrA);
        ConfigManager.register(Character.class, TypeAdapters.Chr);
        ConfigManager.register(Character[].class, TypeAdapters.ChrA);
        ConfigManager.register(Short.TYPE, TypeAdapters.shrt);
        ConfigManager.register(short[].class, TypeAdapters.shrtA);
        ConfigManager.register(Short.class, TypeAdapters.Shrt);
        ConfigManager.register(Short[].class, TypeAdapters.ShrtA);
        ConfigManager.register(Integer.TYPE, TypeAdapters.int_);
        ConfigManager.register(int[].class, TypeAdapters.intA);
        ConfigManager.register(Integer.class, TypeAdapters.Int);
        ConfigManager.register(Integer[].class, TypeAdapters.IntA);
        ConfigManager.register(String.class, TypeAdapters.Str);
        ConfigManager.register(String[].class, TypeAdapters.StrA);
        NEW_LINE = Joiner.on((char)'\n');
        PIPE = Joiner.on((char)'|');
    }
}

