/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends alu
implements IFluidBlock {
    protected static final Map<alu, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<alu, Boolean> displacements = Maps.newHashMap();
    public static final aua LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final ImmutableList<IUnlistedProperty<Float>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected ajk renderLayer = ajk.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, azs material) {
        super(material);
        this.a(true);
        this.p();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.y(this.A.b().a((aub)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    protected atm b() {
        return new ExtendedBlockState(this, new aub[]{LEVEL}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public int e(@Nonnull atl state) {
        return (Integer)state.c((aub)LEVEL);
    }

    @Deprecated
    @Nonnull
    public atl a(int meta) {
        return this.t().a((aub)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(ajk renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(ajw world, co pos) {
        if (world.d(pos)) {
            return true;
        }
        atl state = world.o(pos);
        if (state.v() == this) {
            return false;
        }
        if (this.displacements.containsKey(state.v())) {
            return this.displacements.get(state.v());
        }
        azs material = state.a();
        if (material.c() || material == azs.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(ajs world, co pos) {
        if (world.d(pos)) {
            return true;
        }
        atl state = world.o(pos);
        alu block = state.v();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                if (state.v() != alv.aH) {
                    block.b(world, pos, state, 0);
                }
                return true;
            }
            return false;
        }
        azs material = state.a();
        if (material.c() || material == azs.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((ajw)world, pos);
        if (density == Integer.MAX_VALUE) {
            block.b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(ajw var1, co var2);

    public abstract boolean a(@Nonnull atl var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void c(@Nonnull ajs world, @Nonnull co pos, @Nonnull atl state) {
        world.a(pos, (alu)this, this.tickRate);
    }

    public void a(@Nonnull atl state, @Nonnull ajs world, @Nonnull co pos, @Nonnull alu neighborBlock, @Nonnull co neighbourPos) {
        world.a(pos, (alu)this, this.tickRate);
    }

    public boolean r() {
        return false;
    }

    public boolean b(@Nonnull ajw world, @Nonnull co pos) {
        return true;
    }

    @Nonnull
    public afh a(@Nonnull atl state, @Nonnull Random rand, int fortune) {
        return afl.a;
    }

    public int a(@Nonnull Random par1Random) {
        return 0;
    }

    public int a(@Nonnull ajs world) {
        return this.tickRate;
    }

    @Nonnull
    public bdw a(@Nonnull ajs world, @Nonnull co pos, @Nonnull sn entity, @Nonnull bdw vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        bdw vec_flow = this.getFlowVector((ajw)world, pos);
        return vec.b(vec_flow.b * (double)(this.quantaPerBlock * 4), vec_flow.c * (double)(this.quantaPerBlock * 4), vec_flow.d * (double)(this.quantaPerBlock * 4));
    }

    public int getLightValue(@Nonnull atl state, @Nonnull ajw world, @Nonnull co pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = (Integer)state.c((aub)LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean b(@Nonnull atl state) {
        return false;
    }

    public boolean c(@Nonnull atl state) {
        return false;
    }

    public int d(@Nonnull atl state, @Nonnull ajw world, @Nonnull co pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.a(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ajk f() {
        return this.renderLayer;
    }

    public boolean a(@Nonnull atl state, @Nonnull ajw world, @Nonnull co pos, @Nonnull cv side) {
        atl neighbor = world.o(pos.a(side));
        if (neighbor.a() == state.a()) {
            return false;
        }
        if (this.densityDir == -1 && side == cv.b) {
            return true;
        }
        if (this.densityDir == 1 && side == cv.a) {
            return true;
        }
        return super.a(state, world, pos, side);
    }

    @Nonnull
    public atl getExtendedState(@Nonnull atl oldState, @Nonnull ajw worldIn, @Nonnull co pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(worldIn, pos)));
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        height[1][1] = this.getFluidHeightForRender(worldIn, pos);
        if (height[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                for (int j2 = 0; j2 < 2; ++j2) {
                    corner[i][j2] = 1.0f;
                }
            }
        } else {
            int j3;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j3 = 0; j3 < 3; ++j3) {
                    if (i == 1 && j3 == 1) continue;
                    height[i][j3] = this.getFluidHeightForRender(worldIn, pos.a(i - 1, 0, j3 - 1));
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j3 = 0; j3 < 2; ++j3) {
                    corner[i][j3] = this.getFluidHeightAverage(height[i][j3], height[i][j3 + 1], height[i + 1][j3], height[i + 1][j3 + 1]);
                }
            }
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static final int getDensity(ajw world, co pos) {
        alu block = world.o(pos).v();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(ajw world, co pos) {
        alu block = world.o(pos).v();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(ajw world, co pos) {
        atl state = world.o(pos);
        if (!state.a().d()) {
            return -1000.0;
        }
        bdw vec = ((BlockFluidBase)state.v()).getFlowVector(world, pos);
        return vec.b == 0.0 && vec.d == 0.0 ? -1000.0 : Math.atan2(vec.d, vec.b) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(ajw world, co pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(ajw world, co pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(ajw world, co pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 0.875f) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(ajw world, co pos) {
        atl here = world.o(pos);
        atl up = world.o(pos.c(this.densityDir));
        if (here.v() == this) {
            if (up.a().d() || up.v() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.e(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.v() instanceof aoq) {
            return Math.min(1.0f - aoq.e((int)((Integer)here.c((aub)aoq.b))), 0.875f);
        }
        return !here.a().a() && up.v() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public bdw getFlowVector(ajw world, co pos) {
        bdw vec = new bdw(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.p();
            int z2 = pos.r();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            co pos2 = new co(x2, pos.q(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.o(pos2).a().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
        }
        if (world.o(pos.a()).v() == this) {
            boolean flag;
            boolean bl = flag = this.a(world, pos.a(0, 0, -1), cv.c) || this.a(world, pos.a(0, 0, 1), cv.d) || this.a(world, pos.a(-1, 0, 0), cv.e) || this.a(world, pos.a(1, 0, 0), cv.f) || this.a(world, pos.a(0, 1, -1), cv.c) || this.a(world, pos.a(0, 1, 1), cv.d) || this.a(world, pos.a(-1, 1, 0), cv.e) || this.a(world, pos.a(1, 1, 0), cv.f);
            if (flag) {
                vec = vec.a().b(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(ajs world, co pos) {
        int quantaRemaining = this.getQuantaValue((ajw)world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    public bdt a(@Nonnull atl blockState, @Nonnull ajw worldIn, @Nonnull co pos) {
        return k;
    }

    static {
        defaultDisplacements.put((alu)alv.ao, false);
        defaultDisplacements.put((alu)alv.ap, false);
        defaultDisplacements.put((alu)alv.aq, false);
        defaultDisplacements.put((alu)alv.ar, false);
        defaultDisplacements.put((alu)alv.as, false);
        defaultDisplacements.put((alu)alv.at, false);
        defaultDisplacements.put(alv.bd, false);
        defaultDisplacements.put(alv.cw, false);
        defaultDisplacements.put(alv.aO, false);
        defaultDisplacements.put(alv.aP, false);
        defaultDisplacements.put(alv.aQ, false);
        defaultDisplacements.put(alv.aR, false);
        defaultDisplacements.put(alv.aS, false);
        defaultDisplacements.put(alv.aT, false);
        defaultDisplacements.put(alv.bz, false);
        defaultDisplacements.put(alv.bo, false);
        defaultDisplacements.put(alv.bp, false);
        defaultDisplacements.put(alv.bq, false);
        defaultDisplacements.put(alv.br, false);
        defaultDisplacements.put(alv.bs, false);
        defaultDisplacements.put(alv.bt, false);
        defaultDisplacements.put(alv.aB, false);
        defaultDisplacements.put(alv.az, false);
        defaultDisplacements.put(alv.ch, false);
        defaultDisplacements.put(alv.ci, false);
        defaultDisplacements.put(alv.au, false);
        defaultDisplacements.put(alv.bi, false);
        defaultDisplacements.put(alv.bj, false);
        defaultDisplacements.put((alu)alv.cH, false);
        defaultDisplacements.put((alu)alv.aY, false);
        defaultDisplacements.put(alv.bF, false);
        defaultDisplacements.put(alv.bZ, false);
        defaultDisplacements.put(alv.cv, false);
        defaultDisplacements.put(alv.cK, false);
        defaultDisplacements.put(alv.cL, false);
        defaultDisplacements.put(alv.ba, false);
        defaultDisplacements.put((alu)alv.aA, false);
        defaultDisplacements.put(alv.an, false);
        defaultDisplacements.put(alv.ax, false);
        defaultDisplacements.put((alu)alv.aM, false);
        LEVEL = aua.a((String)"level", (int)0, (int)15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i = 0; i < 4; ++i) {
            BlockFluidBase.LEVEL_CORNERS[i] = new PropertyFloat("level_corner_" + i);
            builder.add((Object)LEVEL_CORNERS[i]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }
}

