/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidClassic
extends BlockFluidBase {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;

    public BlockFluidClassic(Fluid fluid, azs material) {
        super(fluid, material);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(ajw world, co pos) {
        atl state = world.o(pos);
        if (state.v() == alv.a) {
            return 0;
        }
        if (state.v() != this) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - (Integer)state.c((aub)LEVEL);
        return quantaRemaining;
    }

    @Override
    public boolean a(@Nonnull atl state, boolean fullHit) {
        return fullHit && (Integer)state.c((aub)LEVEL) == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public int getLightValue(@Nonnull atl state, @Nonnull ajw world, @Nonnull co pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = this.quantaPerBlock - (Integer)state.c((aub)LEVEL) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public void b(@Nonnull ajs world, @Nonnull co pos, @Nonnull atl state, @Nonnull Random rand) {
        int adjacentSourceBlocks;
        if (!this.isSourceBlock((ajw)world, pos) && ForgeEventFactory.canCreateFluidSource(world, pos, state, false) && (adjacentSourceBlocks = (this.isSourceBlock((ajw)world, pos.c()) ? 1 : 0) + (this.isSourceBlock((ajw)world, pos.d()) ? 1 : 0) + (this.isSourceBlock((ajw)world, pos.f()) ? 1 : 0) + (this.isSourceBlock((ajw)world, pos.e()) ? 1 : 0)) >= 2 && (world.o(pos.b(this.densityDir)).a().a() || this.isSourceBlock((ajw)world, pos.b(this.densityDir)))) {
            world.a(pos, state.a((aub)LEVEL, (Comparable)Integer.valueOf(0)));
        }
        int quantaRemaining = this.quantaPerBlock - (Integer)state.c((aub)LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            if (world.o(pos.a(0, -this.densityDir, 0)).v() == this || world.o(pos.a(-1, -this.densityDir, 0)).v() == this || world.o(pos.a(1, -this.densityDir, 0)).v() == this || world.o(pos.a(0, -this.densityDir, -1)).v() == this || world.o(pos.a(0, -this.densityDir, 1)).v() == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((ajw)world, pos.a(-1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((ajw)world, pos.a(1, 0, 0), maxQuanta);
                maxQuanta = this.getLargerQuanta((ajw)world, pos.a(0, 0, -1), maxQuanta);
                maxQuanta = this.getLargerQuanta((ajw)world, pos.a(0, 0, 1), maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.g(pos);
                } else {
                    world.a(pos, state.a((aub)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                    world.a(pos, (alu)this, this.tickRate);
                    world.b(pos, (alu)this, false);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.a(pos, this.t(), 2);
        }
        if (this.canDisplace((ajw)world, pos.b(this.densityDir))) {
            this.flowIntoBlock(world, pos.b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((ajw)world, pos) || !this.isFlowingVertically((ajw)world, pos)) {
            boolean[] flowTo;
            if (world.o(pos.c(this.densityDir)).v() == this) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                this.flowIntoBlock(world, pos.a(-1, 0, 0), flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, pos.a(1, 0, 0), flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, pos.a(0, 0, -1), flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, pos.a(0, 0, 1), flowMeta);
            }
        }
    }

    public boolean isFlowingVertically(ajw world, co pos) {
        return world.o(pos.b(this.densityDir)).v() == this || world.o(pos).v() == this && this.canFlowInto(world, pos.b(this.densityDir));
    }

    public boolean isSourceBlock(ajw world, co pos) {
        atl state = world.o(pos);
        return state.v() == this && (Integer)state.c((aub)LEVEL) == 0;
    }

    protected boolean[] getOptimalFlowDirections(ajs world, co pos) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            co pos2 = pos;
            switch (side2) {
                case 0: {
                    pos2 = pos2.a(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.a(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.a(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.a(0, 0, 1);
                }
            }
            if (!this.canFlowInto((ajw)world, pos2) || this.isSourceBlock((ajw)world, pos2)) continue;
            this.flowCost[side2] = this.canFlowInto((ajw)world, pos2.a(0, this.densityDir, 0)) ? 0 : this.calculateFlowCost(world, pos2, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(ajs world, co pos, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            co pos2 = pos;
            switch (adjSide) {
                case 0: {
                    pos2 = pos2.a(-1, 0, 0);
                    break;
                }
                case 1: {
                    pos2 = pos2.a(1, 0, 0);
                    break;
                }
                case 2: {
                    pos2 = pos2.a(0, 0, -1);
                    break;
                }
                case 3: {
                    pos2 = pos2.a(0, 0, 1);
                }
            }
            if (!this.canFlowInto((ajw)world, pos2) || this.isSourceBlock((ajw)world, pos2)) continue;
            if (this.canFlowInto((ajw)world, pos2.a(0, this.densityDir, 0))) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, pos2, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(ajs world, co pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.a(pos, this.s().b().a((aub)LEVEL, (Comparable)Integer.valueOf(meta)), 3);
        }
    }

    protected boolean canFlowInto(ajw world, co pos) {
        if (world.d(pos)) {
            return true;
        }
        atl state = world.o(pos);
        if (state.v() == this) {
            return true;
        }
        if (this.displacements.containsKey(state.v())) {
            return (Boolean)this.displacements.get(state.v());
        }
        azs material = state.a();
        if (material.c() || material == azs.h || material == azs.i || material == azs.E) {
            return false;
        }
        int density = BlockFluidClassic.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected int getLargerQuanta(ajw world, co pos, int compare) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public int place(ajs world, co pos, @Nonnull FluidStack fluidStack, boolean doPlace) {
        if (fluidStack.amount < 1000) {
            return 0;
        }
        if (doPlace) {
            world.a(pos, this.t(), 11);
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(ajs world, co pos, boolean doDrain) {
        if (!this.isSourceBlock((ajw)world, pos)) {
            return null;
        }
        if (doDrain) {
            world.g(pos);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(ajs world, co pos) {
        return this.isSourceBlock((ajw)world, pos);
    }
}

