/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.GuiSlotModList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Mouse;

public class GuiModList
extends bho {
    private bho mainMenu;
    private GuiSlotModList modList;
    private GuiScrollingList modInfo;
    private int selected = -1;
    private ModContainer selectedMod;
    private int listWidth;
    private ArrayList<ModContainer> mods;
    private bfm configModButton;
    private bfm disableModButton;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private bfq search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public GuiModList(bho mainMenu) {
        this.mainMenu = mainMenu;
        this.mods = new ArrayList();
        FMLClientHandler.instance().addSpecialModEntries(this.mods);
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod.getMetadata() != null && mod.getMetadata().parentMod == null && !Strings.isNullOrEmpty((String)mod.getMetadata().parent)) {
                String parentMod = mod.getMetadata().parent;
                ModContainer parentContainer = Loader.instance().getIndexedModList().get(parentMod);
                if (parentContainer != null) {
                    mod.getMetadata().parentMod = parentContainer;
                    parentContainer.getMetadata().childMods.add(mod);
                    continue;
                }
            } else if (mod.getMetadata() != null && mod.getMetadata().parentMod != null) continue;
            this.mods.add(mod);
        }
    }

    public void b() {
        int slotHeight = 35;
        for (ModContainer mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().a(mod.getName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().a(mod.getVersion()) + 5 + slotHeight);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.modList = new GuiSlotModList(this, this.mods, this.listWidth, slotHeight);
        this.n.add(new bfm(6, (this.modList.right + this.l) / 2 - 100, this.m - 38, cah.a((String)"gui.done", (Object[])new Object[0])));
        this.configModButton = new bfm(20, 10, this.m - 49, this.listWidth, 20, "Config");
        this.disableModButton = new bfm(21, 10, this.m - 27, this.listWidth, 20, "Disable");
        this.n.add(this.configModButton);
        this.n.add(this.disableModButton);
        this.search = new bfq(0, this.getFontRenderer(), 12, this.modList.bottom + 17, this.modList.listWidth - 4, 14);
        this.search.b(true);
        this.search.d(true);
        int width = this.modList.listWidth / this.numButtons;
        int x = 10;
        int y = 10;
        bfm normalSort = new bfm(SortType.NORMAL.buttonID, x, y, width - this.buttonMargin, 20, cah.a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.l = false;
        this.n.add(normalSort);
        this.n.add(new bfm(SortType.A_TO_Z.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "A-Z"));
        this.n.add(new bfm(SortType.Z_TO_A.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "Z-A"));
        this.updateCache();
    }

    protected void a(int x, int y, int button) throws IOException {
        super.a(x, y, button);
        this.search.a(x, y, button);
        if (button == 1 && x >= this.search.a && x < this.search.a + this.search.i && y >= this.search.f && y < this.search.f + this.search.j) {
            this.search.a("");
        }
    }

    protected void a(char c2, int keyCode) throws IOException {
        super.a(c2, keyCode);
        this.search.a(c2, keyCode);
    }

    public void e() {
        super.e();
        this.search.a();
        if (!this.search.b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            Collections.sort(this.mods, this.sortType);
            this.selected = this.modList.selectedIndex = this.mods.indexOf(this.selectedMod);
            this.sorted = true;
        }
    }

    private void reloadMods() {
        ArrayList<ModContainer> mods = this.modList.getMods();
        mods.clear();
        for (ModContainer m : Loader.instance().getActiveModList()) {
            if (!m.getName().toLowerCase().contains(this.search.b().toLowerCase()) || m.getMetadata().parentMod != null) continue;
            mods.add(m);
        }
        this.mods = mods;
        this.lastFilterText = this.search.b();
    }

    protected void a(bfm button) throws IOException {
        if (button.l) {
            SortType type = SortType.getTypeForButton(button);
            if (type != null) {
                for (bfm b2 : this.n) {
                    if (SortType.getTypeForButton(b2) == null) continue;
                    b2.l = true;
                }
                button.l = false;
                this.sorted = false;
                this.sortType = type;
                this.mods = this.modList.getMods();
            } else {
                switch (button.k) {
                    case 6: {
                        this.j.a(this.mainMenu);
                        return;
                    }
                    case 20: {
                        try {
                            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                            bho newScreen = guiFactory.mainConfigGuiClass().getConstructor(bho.class).newInstance(new Object[]{this});
                            this.j.a(newScreen);
                        }
                        catch (Exception e) {
                            FMLLog.log(Level.ERROR, e, "There was a critical issue trying to build the config GUI for %s", this.selectedMod.getModId());
                        }
                        return;
                    }
                }
            }
        }
        super.a(button);
    }

    public int drawLine(String line, int offset, int shifty) {
        this.q.a(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.modList.drawScreen(mouseX, mouseY, partialTicks);
        if (this.modInfo != null) {
            this.modInfo.drawScreen(mouseX, mouseY, partialTicks);
        }
        int left = (this.l - this.listWidth - 38) / 2 + this.listWidth + 30;
        this.a(this.q, "Mod List", left, 16, 0xFFFFFF);
        super.a(mouseX, mouseY, partialTicks);
        String text = cah.a((String)"fml.menu.mods.search", (Object[])new Object[0]);
        int x = (10 + this.modList.right) / 2 - this.getFontRenderer().a(text) / 2;
        this.getFontRenderer().a(text, x, this.modList.bottom + 5, 0xFFFFFF);
        this.search.g();
    }

    public void k() throws IOException {
        int mouseX = Mouse.getEventX() * this.l / this.j.d;
        int mouseY = this.m - Mouse.getEventY() * this.m / this.j.e - 1;
        super.k();
        if (this.modInfo != null) {
            this.modInfo.handleMouseInput(mouseX, mouseY);
        }
        this.modList.handleMouseInput(mouseX, mouseY);
    }

    bes getMinecraftInstance() {
        return this.j;
    }

    bfg getFontRenderer() {
        return this.q;
    }

    public void selectModIndex(int index) {
        if (index == this.selected) {
            return;
        }
        this.selected = index;
        this.selectedMod = index >= 0 && index <= this.mods.size() ? this.mods.get(this.selected) : null;
        this.updateCache();
    }

    public boolean modIndexSelected(int index) {
        return index == this.selected;
    }

    private void updateCache() {
        this.configModButton.m = false;
        this.disableModButton.m = false;
        this.modInfo = null;
        if (this.selectedMod == null) {
            return;
        }
        kq logoPath = null;
        Dimension logoDims = new Dimension(0, 0);
        ArrayList<String> lines = new ArrayList<String>();
        ForgeVersion.CheckResult vercheck = ForgeVersion.getResult(this.selectedMod);
        String logoFile = this.selectedMod.getMetadata().logoFile;
        if (!logoFile.isEmpty()) {
            bza tm = this.j.N();
            caa pack = FMLClientHandler.instance().getResourcePackFor(this.selectedMod.getModId());
            try {
                BufferedImage logo = null;
                if (pack != null) {
                    logo = pack.a();
                } else {
                    InputStream logoResource = ((Object)((Object)this)).getClass().getResourceAsStream(logoFile);
                    if (logoResource != null) {
                        logo = ImageIO.read(logoResource);
                    }
                }
                if (logo != null) {
                    logoPath = tm.a("modlogo", new byp(logo));
                    logoDims = new Dimension(logo.getWidth(), logo.getHeight());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.selectedMod.getMetadata().autogenerated) {
            this.disableModButton.m = true;
            this.disableModButton.l = true;
            this.disableModButton.packedFGColour = 0;
            ModContainer.Disableable disableable = this.selectedMod.canBeDisabled();
            if (disableable == ModContainer.Disableable.RESTART) {
                this.disableModButton.packedFGColour = 0xFF3377;
            } else if (disableable != ModContainer.Disableable.YES) {
                this.disableModButton.l = false;
            }
            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
            this.configModButton.m = true;
            this.configModButton.l = guiFactory != null && guiFactory.mainConfigGuiClass() != null;
            lines.add(this.selectedMod.getMetadata().name);
            lines.add(String.format("Version: %s (%s)", this.selectedMod.getDisplayVersion(), this.selectedMod.getVersion()));
            lines.add(String.format("Mod ID: '%s' Mod State: %s", new Object[]{this.selectedMod.getModId(), Loader.instance().getModState(this.selectedMod)}));
            if (!this.selectedMod.getMetadata().credits.isEmpty()) {
                lines.add("Credits: " + this.selectedMod.getMetadata().credits);
            }
            lines.add("Authors: " + this.selectedMod.getMetadata().getAuthorList());
            lines.add("URL: " + this.selectedMod.getMetadata().url);
            if (this.selectedMod.getMetadata().childMods.isEmpty()) {
                lines.add("No child mods for this mod");
            } else {
                lines.add("Child mods: " + this.selectedMod.getMetadata().getChildModList());
            }
            if (vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                lines.add("Update Available: " + (vercheck.url == null ? "" : vercheck.url));
            }
            lines.add(null);
            lines.add(this.selectedMod.getMetadata().description);
        } else {
            lines.add(a.p + this.selectedMod.getName());
            lines.add(a.p + "Version: " + this.selectedMod.getVersion());
            lines.add(a.p + "Mod State: " + (Object)((Object)Loader.instance().getModState(this.selectedMod)));
            if (vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                lines.add("Update Available: " + (vercheck.url == null ? "" : vercheck.url));
            }
            lines.add(null);
            lines.add(a.m + "No mod information found");
            lines.add(a.m + "Ask your mod author to provide a mod mcmod.info file");
        }
        if ((vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED) && vercheck.changes.size() > 0) {
            lines.add(null);
            lines.add("Changes:");
            for (Map.Entry<ComparableVersion, String> entry : vercheck.changes.entrySet()) {
                lines.add("  " + entry.getKey() + ":");
                lines.add(entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo = new Info(this.l - this.listWidth - 30, lines, logoPath, logoDims);
    }

    private class Info
    extends GuiScrollingList {
        @Nullable
        private kq logoPath;
        private Dimension logoDims;
        private List<fb> lines;

        public Info(int width, @Nullable List<String> lines, kq logoPath, Dimension logoDims) {
            super(GuiModList.this.getMinecraftInstance(), width, GuiModList.this.m, 32, GuiModList.this.m - 88 + 4, GuiModList.this.listWidth + 20, 60, GuiModList.this.l, GuiModList.this.m);
            this.lines = null;
            this.lines = this.resizeContent(lines);
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        @Override
        protected int getSize() {
            return 0;
        }

        @Override
        protected void elementClicked(int index, boolean doubleClick) {
        }

        @Override
        protected boolean isSelected(int index) {
            return false;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, bqs tess) {
        }

        private List<fb> resizeContent(List<String> lines) {
            ArrayList<fb> ret = new ArrayList<fb>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                fb chat = ForgeHooks.newChatWithLinks(line, false);
                ret.addAll(bfo.a((fb)chat, (int)(this.listWidth - 8), (bfg)GuiModList.this.q, (boolean)false, (boolean)true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = 0;
            if (this.logoPath != null) {
                double scaleX = (double)this.logoDims.width / 200.0;
                double scaleY = (double)this.logoDims.height / 65.0;
                double scale = 1.0;
                if (scaleX > 1.0 || scaleY > 1.0) {
                    scale = 1.0 / Math.max(scaleX, scaleY);
                }
                this.logoDims.width = (int)((double)this.logoDims.width * scale);
                this.logoDims.height = (int)((double)this.logoDims.height * scale);
                height += this.logoDims.height;
                height += 10;
            }
            if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected void drawHeader(int entryRight, int relativeY, bqs tess) {
            int top = relativeY;
            if (this.logoPath != null) {
                bqg.m();
                GuiModList.this.j.Q.a(this.logoPath);
                bpy wr = tess.c();
                int offset = this.left + this.listWidth / 2 - this.logoDims.width / 2;
                wr.a(7, bzh.g);
                wr.b((double)offset, (double)(top + this.logoDims.height), (double)GuiModList.this.e).a(0.0, 1.0).d();
                wr.b((double)(offset + this.logoDims.width), (double)(top + this.logoDims.height), (double)GuiModList.this.e).a(1.0, 1.0).d();
                wr.b((double)(offset + this.logoDims.width), (double)top, (double)GuiModList.this.e).a(1.0, 0.0).d();
                wr.b((double)offset, (double)top, (double)GuiModList.this.e).a(0.0, 0.0).d();
                tess.b();
                bqg.l();
                top += this.logoDims.height + 10;
            }
            for (fb line : this.lines) {
                if (line != null) {
                    bqg.m();
                    GuiModList.this.q.a(line.d(), (float)(this.left + 4), (float)top, 0xFFFFFF);
                    bqg.d();
                    bqg.l();
                }
                top += 10;
            }
        }

        @Override
        protected void clickHeader(int x, int y) {
            int offset = y;
            if (this.logoPath != null) {
                offset -= this.logoDims.height + 10;
            }
            if (offset <= 0) {
                return;
            }
            int lineIdx = offset / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            fb line = this.lines.get(lineIdx);
            if (line != null) {
                int k2 = -4;
                for (fb part : line) {
                    if (!(part instanceof fh) || (k2 += GuiModList.this.q.a(((fh)part).g())) < x) continue;
                    GuiModList.this.a(part);
                    break;
                }
            }
        }
    }

    private static enum SortType implements Comparator<ModContainer>
    {
        NORMAL(24),
        A_TO_Z(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        @Nullable
        public static SortType getTypeForButton(bfm button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.k) continue;
                return t;
            }
            return null;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            String name1 = oy.a((String)o1.getName()).toLowerCase();
            String name2 = oy.a((String)o2.getName()).toLowerCase();
            return this.compare(name1, name2);
        }
    }
}

