/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLHandledException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.LoaderExceptionModCrash;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLLoadEvent;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.functions.ArtifactVersionNameFunction;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

public class LoadController {
    private Loader loader;
    private EventBus masterChannel;
    private ImmutableMap<String, EventBus> eventChannels;
    private LoaderState state;
    private Multimap<String, LoaderState.ModState> modStates = ArrayListMultimap.create();
    private Multimap<String, Throwable> errors = ArrayListMultimap.create();
    private Map<String, String> modNames = Maps.newHashMap();
    private List<ModContainer> activeModList = Lists.newArrayList();
    private ModContainer activeContainer;
    private BiMap<ModContainer, Object> modObjectList;
    private ListMultimap<String, ModContainer> packageOwners;
    private FMLSecurityManager accessibleManager = new FMLSecurityManager();

    public LoadController(Loader loader) {
        this.loader = loader;
        this.masterChannel = new EventBus(new SubscriberExceptionHandler(){

            public void handleException(Throwable exception, SubscriberExceptionContext context) {
                FMLLog.log("FMLMainChannel", Level.ERROR, exception, "Could not dispatch event: %s to %s", context.getEvent(), context.getSubscriberMethod());
            }
        });
        this.masterChannel.register((Object)this);
        this.state = LoaderState.NOINIT;
        this.packageOwners = ArrayListMultimap.create();
    }

    void disableMod(ModContainer mod) {
        HashMap temporary = Maps.newHashMap(this.eventChannels);
        String modId = mod.getModId();
        EventBus bus2 = (EventBus)temporary.remove(modId);
        bus2.post((Object)new FMLModDisabledEvent());
        if (this.errors.get((Object)modId).isEmpty()) {
            this.eventChannels = ImmutableMap.copyOf((Map)temporary);
            this.modStates.put((Object)modId, (Object)LoaderState.ModState.DISABLED);
            this.modObjectList.remove((Object)mod);
            this.activeModList.remove(mod);
        }
    }

    @Subscribe
    public void buildModList(FMLLoadEvent event) {
        ImmutableMap.Builder eventBus = ImmutableMap.builder();
        for (final ModContainer mod : this.loader.getModList()) {
            EventBus bus2;
            boolean isActive = mod.registerBus(bus2 = new EventBus(new SubscriberExceptionHandler(){

                public void handleException(Throwable exception, SubscriberExceptionContext context) {
                    LoadController.this.errorOccurred(mod, exception);
                }
            }), this);
            if (isActive) {
                this.activeModList.add(mod);
                this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
                eventBus.put((Object)mod.getModId(), (Object)bus2);
                FMLCommonHandler.instance().addModToResourcePack(mod);
            } else {
                FMLLog.log(mod.getModId(), Level.WARN, "Mod %s has been disabled through configuration", mod.getModId());
                this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
                this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.DISABLED);
            }
            this.modNames.put(mod.getModId(), mod.getName());
        }
        this.eventChannels = eventBus.build();
    }

    public void distributeStateMessage(LoaderState state, Object ... eventData) {
        if (state.hasEvent()) {
            this.masterChannel.post((Object)state.getEvent(eventData));
        }
    }

    public void transition(LoaderState desiredState, boolean forceState) {
        LoaderState oldState = this.state;
        this.state = this.state.transition(!this.errors.isEmpty());
        if (this.state != desiredState && !forceState) {
            Map.Entry toThrow = null;
            FMLLog.severe("Fatal errors were detected during the transition from %s to %s. Loading cannot continue", new Object[]{oldState, desiredState});
            StringBuilder sb = new StringBuilder();
            this.printModStates(sb);
            FMLLog.severe("%s", sb.toString());
            if (this.errors.size() > 0) {
                FMLLog.severe("The following problems were captured during this phase", new Object[0]);
                for (Map.Entry error : this.errors.entries()) {
                    String modId = (String)error.getKey();
                    String modName = this.modNames.get(modId);
                    FMLLog.log(Level.ERROR, (Throwable)error.getValue(), "Caught exception from %s (%s)", modName, modId);
                    if (error.getValue() instanceof IFMLHandledException) {
                        toThrow = error;
                        continue;
                    }
                    if (toThrow != null) continue;
                    toThrow = error;
                }
            } else {
                FMLLog.severe("The ForgeModLoader state engine has become corrupted. Probably, a state was missed by and invalid modification to a base classForgeModLoader depends on. This is a critical error and not recoverable. Investigate any modifications to base classes outside ofForgeModLoader, especially Optifine, to see if there are fixes available.", new Object[0]);
                throw new RuntimeException("The ForgeModLoader state engine is invalid");
            }
            if (toThrow != null) {
                String modId = (String)toThrow.getKey();
                String modName = this.modNames.get(modId);
                String errMsg = String.format("Caught exception from %s (%s)", modName, modId);
                throw new LoaderExceptionModCrash(errMsg, (Throwable)toThrow.getValue());
            }
        } else if (this.state != desiredState && forceState) {
            FMLLog.info("The state engine was in incorrect state %s and forced into state %s. Errors may have been discarded.", new Object[]{this.state, desiredState});
            this.forceState(desiredState);
        }
    }

    @Nullable
    public ModContainer activeContainer() {
        return this.activeContainer != null ? this.activeContainer : this.findActiveContainerFromStack();
    }

    void forceActiveContainer(@Nullable ModContainer container) {
        this.activeContainer = container;
    }

    @Subscribe
    public void propogateStateMessage(FMLEvent stateEvent) {
        if (stateEvent instanceof FMLPreInitializationEvent) {
            this.modObjectList = this.buildModObjectList();
        }
        ProgressManager.ProgressBar bar = ProgressManager.push(stateEvent.description(), this.activeModList.size(), true);
        for (ModContainer mc : this.activeModList) {
            bar.step(mc.getName());
            this.sendEventToModContainer(stateEvent, mc);
        }
        ProgressManager.pop(bar);
    }

    private void sendEventToModContainer(FMLEvent stateEvent, ModContainer mc) {
        String modId = mc.getModId();
        Collection requirements = Collections2.transform(mc.getRequirements(), (Function)new ArtifactVersionNameFunction());
        for (ArtifactVersion av : mc.getDependencies()) {
            if (av.getLabel() == null || !requirements.contains(av.getLabel()) || !this.modStates.containsEntry((Object)av.getLabel(), (Object)LoaderState.ModState.ERRORED)) continue;
            FMLLog.log(modId, Level.ERROR, "Skipping event %s and marking errored mod %s since required dependency %s has errored", stateEvent.getEventType(), modId, av.getLabel());
            this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
            return;
        }
        this.activeContainer = mc;
        stateEvent.applyModContainer(mc);
        ThreadContext.put((String)"mod", (String)modId);
        FMLLog.log(modId, Level.TRACE, "Sending event %s to mod %s", stateEvent.getEventType(), modId);
        ((EventBus)this.eventChannels.get((Object)modId)).post((Object)stateEvent);
        FMLLog.log(modId, Level.TRACE, "Sent event %s to mod %s", stateEvent.getEventType(), modId);
        ThreadContext.remove((String)"mod");
        this.activeContainer = null;
        if (stateEvent instanceof FMLStateEvent) {
            if (!this.errors.containsKey((Object)modId)) {
                this.modStates.put((Object)modId, (Object)((FMLStateEvent)stateEvent).getModState());
            } else {
                this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
            }
        }
    }

    public ImmutableBiMap<ModContainer, Object> buildModObjectList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModContainer mc : this.activeModList) {
            if (!mc.isImmutable() && mc.getMod() != null) {
                builder.put((Object)mc, mc.getMod());
                List<String> packages = mc.getOwnedPackages();
                for (String pkg : packages) {
                    this.packageOwners.put((Object)pkg, (Object)mc);
                }
            }
            if (mc.getMod() != null || mc.isImmutable() || this.state == LoaderState.CONSTRUCTING) continue;
            FMLLog.severe("There is a severe problem with %s - it appears not to have constructed correctly", mc.getModId());
            if (this.state == LoaderState.CONSTRUCTING) continue;
            this.errorOccurred(mc, new RuntimeException());
        }
        return builder.build();
    }

    public void errorOccurred(ModContainer modContainer, Throwable exception) {
        if (exception instanceof InvocationTargetException) {
            this.errors.put((Object)modContainer.getModId(), (Object)exception.getCause());
        } else {
            this.errors.put((Object)modContainer.getModId(), (Object)exception);
        }
    }

    public void printModStates(StringBuilder ret) {
        ret.append("\n\tStates:");
        for (LoaderState.ModState state : LoaderState.ModState.values()) {
            ret.append(" '").append(state.getMarker()).append("' = ").append(state.toString());
        }
        for (ModContainer mc : this.loader.getModList()) {
            ret.append("\n\t");
            for (LoaderState.ModState state : this.modStates.get((Object)mc.getModId())) {
                ret.append(state.getMarker());
            }
            ret.append("\t").append(mc.getModId()).append("{").append(mc.getVersion()).append("} [").append(mc.getName()).append("] (").append(mc.getSource().getName()).append(") ");
        }
    }

    public List<ModContainer> getActiveModList() {
        return this.activeModList;
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return (LoaderState.ModState)((Object)Iterables.getLast((Iterable)this.modStates.get((Object)selectedMod.getModId()), (Object)((Object)LoaderState.ModState.AVAILABLE)));
    }

    public void distributeStateMessage(Class<?> customEvent) {
        try {
            this.masterChannel.post(customEvent.newInstance());
        }
        catch (Exception e2) {
            FMLLog.log(Level.ERROR, e2, "An unexpected exception", new Object[0]);
            throw new LoaderException(e2);
        }
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        if (this.modObjectList == null) {
            FMLLog.severe("Detected an attempt by a mod %s to perform game activity during mod construction. This is a serious programming error.", this.activeContainer);
            return this.buildModObjectList();
        }
        return ImmutableBiMap.copyOf(this.modObjectList);
    }

    public boolean isInState(LoaderState state) {
        return this.state == state;
    }

    boolean hasReachedState(LoaderState state) {
        return this.state.ordinal() >= state.ordinal() && this.state != LoaderState.ERRORED;
    }

    void forceState(LoaderState newState) {
        this.state = newState;
    }

    @Nullable
    private ModContainer findActiveContainerFromStack() {
        for (Class<?> c2 : this.getCallingStack()) {
            String pkg;
            int idx = c2.getName().lastIndexOf(46);
            if (idx == -1 || !this.packageOwners.containsKey((Object)(pkg = c2.getName().substring(0, idx)))) continue;
            return (ModContainer)this.packageOwners.get((Object)pkg).get(0);
        }
        return null;
    }

    Class<?>[] getCallingStack() {
        return this.accessibleManager.getStackClasses();
    }

    LoaderState getState() {
        return this.state;
    }

    class FMLSecurityManager
    extends SecurityManager {
        FMLSecurityManager() {
        }

        Class<?>[] getStackClasses() {
            return this.getClassContext();
        }
    }
}

