/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery.asm;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.discovery.asm.ModClassVisitor;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class ASMModParser {
    private Type asmType;
    private int classVersion;
    private Type asmSuperType;
    private LinkedList<ModAnnotation> annotations = Lists.newLinkedList();
    private Set<String> interfaces = Sets.newHashSet();
    private String baseModProperties;

    public ASMModParser(InputStream stream) throws IOException {
        try {
            ClassReader reader = new ClassReader(stream);
            reader.accept((ClassVisitor)new ModClassVisitor(this), 0);
        }
        catch (Exception ex) {
            FMLLog.log(Level.ERROR, ex, "Unable to read a class file correctly", new Object[0]);
            throw new LoaderException(ex);
        }
    }

    public void beginNewTypeName(String typeQName, int classVersion, String superClassQName, String[] interfaces) {
        this.asmType = Type.getObjectType((String)typeQName);
        this.classVersion = classVersion;
        this.asmSuperType = !Strings.isNullOrEmpty((String)superClassQName) ? Type.getObjectType((String)superClassQName) : null;
        for (String intf : interfaces) {
            this.interfaces.add(intf);
        }
    }

    public void startClassAnnotation(String annotationName) {
        ModAnnotation ann2 = new ModAnnotation(AnnotationType.CLASS, Type.getType((String)annotationName), this.asmType.getClassName());
        this.annotations.addFirst(ann2);
    }

    public void addAnnotationProperty(String key, Object value) {
        this.annotations.getFirst().addProperty(key, value);
    }

    public void startFieldAnnotation(String fieldName, String annotationName) {
        ModAnnotation ann2 = new ModAnnotation(AnnotationType.FIELD, Type.getType((String)annotationName), fieldName);
        this.annotations.addFirst(ann2);
    }

    public String toString() {
        return Objects.toStringHelper((String)"ASMAnnotationDiscoverer").add("className", (Object)this.asmType.getClassName()).add("classVersion", this.classVersion).add("superName", (Object)this.asmSuperType.getClassName()).add("annotations", this.annotations).add("isBaseMod", this.isBaseMod(Collections.<String>emptyList())).add("baseModProperties", (Object)this.baseModProperties).toString();
    }

    public Type getASMType() {
        return this.asmType;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    public Type getASMSuperType() {
        return this.asmSuperType;
    }

    public LinkedList<ModAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void validate() {
    }

    public boolean isBaseMod(List<String> rememberedTypes) {
        return this.getASMSuperType().equals((Object)Type.getType((String)"LBaseMod;")) || this.getASMSuperType().equals((Object)Type.getType((String)"Lnet/minecraft/src/BaseMod;")) || rememberedTypes.contains(this.getASMSuperType().getClassName());
    }

    public void setBaseModProperties(String foundProperties) {
        this.baseModProperties = foundProperties;
    }

    public String getBaseModProperties() {
        return this.baseModProperties;
    }

    public void sendToTable(ASMDataTable table, ModCandidate candidate) {
        for (ModAnnotation ma : this.annotations) {
            table.addASMData(candidate, ma.asmType.getClassName(), this.asmType.getClassName(), ma.member, ma.values);
        }
        for (String intf : this.interfaces) {
            table.addASMData(candidate, intf, this.asmType.getInternalName(), null, null);
        }
    }

    public void addAnnotationArray(String name) {
        this.annotations.getFirst().addArray(name);
    }

    public void addAnnotationEnumProperty(String name, String desc, String value) {
        this.annotations.getFirst().addEnumProperty(name, desc, value);
    }

    public void endArray() {
        this.annotations.getFirst().endArray();
    }

    public void addSubAnnotation(String name, String desc) {
        ModAnnotation ma = this.annotations.getFirst();
        this.annotations.addFirst(ma.addChildAnnotation(name, desc));
    }

    public void endSubAnnotation() {
        ModAnnotation child = this.annotations.removeFirst();
        this.annotations.addLast(child);
    }

    public void startMethodAnnotation(String methodName, String methodDescriptor, String annotationName) {
        ModAnnotation ann2 = new ModAnnotation(AnnotationType.METHOD, Type.getType((String)annotationName), methodName + methodDescriptor);
        this.annotations.addFirst(ann2);
    }

    static enum AnnotationType {
        CLASS,
        FIELD,
        METHOD,
        SUBTYPE;

    }
}

