/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.apache.logging.log4j.Level;

public class FMLPostInitializationEvent
extends FMLStateEvent {
    public FMLPostInitializationEvent(Object ... data) {
        super(data);
    }

    @Override
    public LoaderState.ModState getModState() {
        return LoaderState.ModState.POSTINITIALIZED;
    }

    public Optional<?> buildSoftDependProxy(String modId, String className, Object ... arguments) {
        if (Loader.isModLoaded(modId)) {
            Class[] args = Lists.transform((List)Lists.newArrayList((Object[])arguments), (Function)new Function<Object, Class<?>>(){

                @Nullable
                public Class<?> apply(@Nullable Object input) {
                    return input == null ? null : input.getClass();
                }
            }).toArray(new Class[0]);
            try {
                Class<?> clz = Class.forName(className, true, Loader.instance().getModClassLoader());
                Constructor<?> ct2 = clz.getConstructor(args);
                return Optional.of(ct2.newInstance(arguments));
            }
            catch (Exception e2) {
                FMLLog.getLogger().log(Level.INFO, "An error occurred trying to build a soft depend proxy", (Throwable)e2);
                return Optional.absent();
            }
        }
        return Optional.absent();
    }
}

