/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FluidEvent
extends Event {
    private final FluidStack fluid;
    private final ajs world;
    private final co pos;

    public FluidEvent(FluidStack fluid, ajs world, co pos) {
        this.fluid = fluid;
        this.world = world;
        this.pos = pos;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public ajs getWorld() {
        return this.world;
    }

    public co getPos() {
        return this.pos;
    }

    public static final void fireEvent(FluidEvent event) {
        MinecraftForge.EVENT_BUS.post(event);
    }

    public static class FluidSpilledEvent
    extends FluidEvent {
        public FluidSpilledEvent(FluidStack fluid, ajs world, co pos) {
            super(fluid, world, pos);
        }
    }

    public static class FluidDrainingEvent
    extends FluidEvent {
        private final IFluidTank tank;
        private final int amount;

        public FluidDrainingEvent(FluidStack fluid, ajs world, co pos, IFluidTank tank, int amount) {
            super(fluid, world, pos);
            this.amount = amount;
            this.tank = tank;
        }

        public IFluidTank getTank() {
            return this.tank;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class FluidFillingEvent
    extends FluidEvent {
        private final IFluidTank tank;
        private final int amount;

        public FluidFillingEvent(FluidStack fluid, ajs world, co pos, IFluidTank tank, int amount) {
            super(fluid, world, pos);
            this.tank = tank;
            this.amount = amount;
        }

        public IFluidTank getTank() {
            return this.tank;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static class FluidMotionEvent
    extends FluidEvent {
        public FluidMotionEvent(FluidStack fluid, ajs world, co pos) {
            super(fluid, world, pos);
        }
    }
}

