/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.ObjectHolderRef;

public enum ObjectHolderRegistry {
    INSTANCE;

    private List<ObjectHolderRef> objectHolders = Lists.newArrayList();

    public void findObjectHolders(ASMDataTable table) {
        boolean isClass;
        String value;
        String annotationTarget;
        String className;
        FMLLog.info("Processing ObjectHolder annotations", new Object[0]);
        Set<ASMDataTable.ASMData> allObjectHolders = table.getAll(GameRegistry.ObjectHolder.class.getName());
        HashMap classModIds = Maps.newHashMap();
        HashMap classCache = Maps.newHashMap();
        for (ASMDataTable.ASMData data : allObjectHolders) {
            className = data.getClassName();
            annotationTarget = data.getObjectName();
            value = (String)data.getAnnotationInfo().get("value");
            isClass = className.equals(annotationTarget);
            if (!isClass) continue;
            this.scanTarget(classModIds, classCache, className, annotationTarget, value, isClass, false);
        }
        for (ASMDataTable.ASMData data : allObjectHolders) {
            className = data.getClassName();
            annotationTarget = data.getObjectName();
            value = (String)data.getAnnotationInfo().get("value");
            isClass = className.equals(annotationTarget);
            if (isClass) continue;
            this.scanTarget(classModIds, classCache, className, annotationTarget, value, isClass, false);
        }
        this.scanTarget(classModIds, classCache, "net.minecraft.init.Blocks", null, "minecraft", true, true);
        this.scanTarget(classModIds, classCache, "net.minecraft.init.Items", null, "minecraft", true, true);
        FMLLog.info("Found %d ObjectHolder annotations", this.objectHolders.size());
    }

    private void scanTarget(Map<String, String> classModIds, Map<String, Class<?>> classCache, String className, @Nullable String annotationTarget, String value, boolean isClass, boolean extractFromValue) {
        Class<?> clazz;
        if (classCache.containsKey(className)) {
            clazz = classCache.get(className);
        } else {
            try {
                clazz = Class.forName(className, extractFromValue, ((Object)((Object)this)).getClass().getClassLoader());
                classCache.put(className, clazz);
            }
            catch (Exception ex2) {
                throw Throwables.propagate((Throwable)ex2);
            }
        }
        if (isClass) {
            this.scanClassForFields(classModIds, className, value, clazz, extractFromValue);
        } else {
            if (value.indexOf(58) == -1) {
                String prefix = classModIds.get(className);
                if (prefix == null) {
                    FMLLog.warning("Found an unqualified ObjectHolder annotation (%s) without a modid context at %s.%s, ignoring", value, className, annotationTarget);
                    throw new IllegalStateException("Unqualified reference to ObjectHolder");
                }
                value = prefix + ":" + value;
            }
            try {
                Field f2 = clazz.getField(annotationTarget);
                this.addHolderReference(new ObjectHolderRef(f2, new kq(value), extractFromValue));
            }
            catch (Exception ex3) {
                throw Throwables.propagate((Throwable)ex3);
            }
        }
    }

    private void scanClassForFields(Map<String, String> classModIds, String className, String value, Class<?> clazz, boolean extractFromExistingValues) {
        classModIds.put(className, value);
        for (Field f2 : clazz.getFields()) {
            boolean isMatch;
            int mods = f2.getModifiers();
            boolean bl = isMatch = Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods);
            if (!isMatch || f2.isAnnotationPresent(GameRegistry.ObjectHolder.class)) continue;
            this.addHolderReference(new ObjectHolderRef(f2, new kq(value, f2.getName()), extractFromExistingValues));
        }
    }

    private void addHolderReference(ObjectHolderRef ref) {
        if (ref.isValid()) {
            this.objectHolders.add(ref);
        }
    }

    public void applyObjectHolders() {
        FMLLog.info("Applying holder lookups", new Object[0]);
        for (ObjectHolderRef ohr : this.objectHolders) {
            ohr.apply();
        }
        FMLLog.info("Holder lookups applied", new Object[0]);
    }
}

