/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class EntityViewRenderEvent
extends Event {
    private final bqe renderer;
    private final sn entity;
    private final atl state;
    private final double renderPartialTicks;

    public EntityViewRenderEvent(bqe renderer, sn entity, atl state, double renderPartialTicks) {
        this.renderer = renderer;
        this.entity = entity;
        this.state = state;
        this.renderPartialTicks = renderPartialTicks;
    }

    public bqe getRenderer() {
        return this.renderer;
    }

    public sn getEntity() {
        return this.entity;
    }

    public atl getState() {
        return this.state;
    }

    public double getRenderPartialTicks() {
        return this.renderPartialTicks;
    }

    public static class FOVModifier
    extends EntityViewRenderEvent {
        private float fov;

        public FOVModifier(bqe renderer, sn entity, atl state, double renderPartialTicks, float fov) {
            super(renderer, entity, state, renderPartialTicks);
            this.setFOV(fov);
        }

        public float getFOV() {
            return this.fov;
        }

        public void setFOV(float fov) {
            this.fov = fov;
        }
    }

    public static class CameraSetup
    extends EntityViewRenderEvent {
        private float yaw;
        private float pitch;
        private float roll;

        public CameraSetup(bqe renderer, sn entity, atl state, double renderPartialTicks, float yaw, float pitch, float roll) {
            super(renderer, entity, state, renderPartialTicks);
            this.setYaw(yaw);
            this.setPitch(pitch);
            this.setRoll(roll);
        }

        public float getYaw() {
            return this.yaw;
        }

        public void setYaw(float yaw) {
            this.yaw = yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getRoll() {
            return this.roll;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }
    }

    public static class FogColors
    extends EntityViewRenderEvent {
        private float red;
        private float green;
        private float blue;

        public FogColors(bqe renderer, sn entity, atl state, double renderPartialTicks, float red, float green, float blue) {
            super(renderer, entity, state, renderPartialTicks);
            this.setRed(red);
            this.setGreen(green);
            this.setBlue(blue);
        }

        public float getRed() {
            return this.red;
        }

        public void setRed(float red) {
            this.red = red;
        }

        public float getGreen() {
            return this.green;
        }

        public void setGreen(float green) {
            this.green = green;
        }

        public float getBlue() {
            return this.blue;
        }

        public void setBlue(float blue) {
            this.blue = blue;
        }
    }

    @Event.HasResult
    public static class RenderFogEvent
    extends EntityViewRenderEvent {
        private final int fogMode;
        private final float farPlaneDistance;

        public RenderFogEvent(bqe renderer, sn entity, atl state, double renderPartialTicks, int fogMode, float farPlaneDistance) {
            super(renderer, entity, state, renderPartialTicks);
            this.fogMode = fogMode;
            this.farPlaneDistance = farPlaneDistance;
        }

        public int getFogMode() {
            return this.fogMode;
        }

        public float getFarPlaneDistance() {
            return this.farPlaneDistance;
        }
    }

    @Cancelable
    public static class FogDensity
    extends EntityViewRenderEvent {
        private float density;

        public FogDensity(bqe renderer, sn entity, atl state, double renderPartialTicks, float density) {
            super(renderer, entity, state, renderPartialTicks);
            this.setDensity(density);
        }

        public float getDensity() {
            return this.density;
        }

        public void setDensity(float density) {
            this.density = density;
        }
    }
}

