/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;

public interface ISpecialArmor {
    public ArmorProperties getProperties(sw var1, @Nonnull afj var2, ry var3, double var4, int var6);

    public int getArmorDisplay(aay var1, @Nonnull afj var2, int var3);

    public void damageArmor(sw var1, @Nonnull afj var2, ry var3, int var4, int var5);

    public static class ArmorProperties
    implements Comparable<ArmorProperties> {
        public int Priority = 0;
        public int AbsorbMax = Integer.MAX_VALUE;
        public double AbsorbRatio = 0.0;
        public int Slot = 0;
        private static final boolean DEBUG = false;

        public ArmorProperties(int priority, double ratio, int max) {
            this.Priority = priority;
            this.AbsorbRatio = ratio;
            this.AbsorbMax = max;
        }

        public static float applyArmor(sw entity, dd<afj> inventory, ry source, double damage) {
            damage *= 25.0;
            ArrayList<ArmorProperties> dmgVals = new ArrayList<ArmorProperties>();
            for (int x = 0; x < inventory.size(); ++x) {
                ISpecialArmor armor;
                afj stack = (afj)inventory.get(x);
                if (stack.b()) continue;
                ArmorProperties prop = null;
                if (stack.c() instanceof ISpecialArmor) {
                    armor = (ISpecialArmor)stack.c();
                    prop = armor.getProperties(entity, stack, source, damage / 25.0, x).copy();
                } else if (stack.c() instanceof adp && !source.e()) {
                    armor = (adp)stack.c();
                    prop = new ArmorProperties(0, (double)((adp)armor).d / 25.0, Integer.MAX_VALUE);
                }
                if (prop == null) continue;
                prop.Slot = x;
                dmgVals.add(prop);
            }
            if (dmgVals.size() > 0) {
                ArmorProperties[] props = dmgVals.toArray(new ArmorProperties[dmgVals.size()]);
                ArmorProperties.StandardizeList(props, damage);
                int level = props[0].Priority;
                double ratio = 0.0;
                for (ArmorProperties prop : props) {
                    if (level != prop.Priority) {
                        damage -= damage * ratio;
                        ratio = 0.0;
                        level = prop.Priority;
                    }
                    ratio += prop.AbsorbRatio;
                    double absorb = damage * prop.AbsorbRatio;
                    if (!(absorb > 0.0)) continue;
                    afj stack = (afj)inventory.get(prop.Slot);
                    int itemDamage = (int)(absorb / 25.0 < 1.0 ? 1.0 : absorb / 25.0);
                    if (stack.c() instanceof ISpecialArmor) {
                        ((ISpecialArmor)stack.c()).damageArmor(entity, stack, source, itemDamage, prop.Slot);
                    } else {
                        stack.a(itemDamage, entity);
                    }
                    if (!stack.b()) continue;
                    inventory.set(prop.Slot, (Object)afj.a);
                }
                damage -= damage * ratio;
            }
            return (float)(damage / 25.0);
        }

        private static void StandardizeList(ArmorProperties[] armor, double damage) {
            Arrays.sort(armor);
            int start = 0;
            double total = 0.0;
            int priority = armor[0].Priority;
            int pStart = 0;
            boolean pChange = false;
            boolean pFinished = false;
            for (int x = 0; x < armor.length; ++x) {
                int y;
                total += armor[x].AbsorbRatio;
                if (x != armor.length - 1 && armor[x].Priority == priority) continue;
                if (armor[x].Priority != priority) {
                    total -= armor[x].AbsorbRatio;
                    --x;
                    pChange = true;
                }
                if (total > 1.0) {
                    for (y = start; y <= x; ++y) {
                        double newRatio = armor[y].AbsorbRatio / total;
                        if (newRatio * damage > (double)armor[y].AbsorbMax) {
                            armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                            total = 0.0;
                            for (int z = pStart; z <= y; ++z) {
                                total += armor[z].AbsorbRatio;
                            }
                            start = y + 1;
                            x = y;
                            break;
                        }
                        armor[y].AbsorbRatio = newRatio;
                        pFinished = true;
                    }
                    if (!pChange || !pFinished) continue;
                    damage -= damage * total;
                    total = 0.0;
                    start = x + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    pFinished = false;
                    if (!(damage <= 0.0)) continue;
                    for (y = x + 1; y < armor.length; ++y) {
                        armor[y].AbsorbRatio = 0.0;
                    }
                } else {
                    for (y = start; y <= x; ++y) {
                        total -= armor[y].AbsorbRatio;
                        if (damage * armor[y].AbsorbRatio > (double)armor[y].AbsorbMax) {
                            armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                        }
                        total += armor[y].AbsorbRatio;
                    }
                    damage -= damage * total;
                    total = 0.0;
                    if (x == armor.length - 1) continue;
                    start = x + 1;
                    priority = armor[start].Priority;
                    pStart = start;
                    pChange = false;
                    if (!(damage <= 0.0)) continue;
                    for (y = x + 1; y < armor.length; ++y) {
                        armor[y].AbsorbRatio = 0.0;
                    }
                }
                break;
            }
        }

        @Override
        public int compareTo(ArmorProperties o) {
            if (o.Priority != this.Priority) {
                return o.Priority - this.Priority;
            }
            double left = this.AbsorbRatio == 0.0 ? 0.0 : (double)this.AbsorbMax * 100.0 / this.AbsorbRatio;
            double right = o.AbsorbRatio == 0.0 ? 0.0 : (double)o.AbsorbMax * 100.0 / o.AbsorbRatio;
            return (int)(left - right);
        }

        public String toString() {
            return String.format("%d, %d, %f, %d", this.Priority, this.AbsorbMax, this.AbsorbRatio, this.AbsorbRatio == 0.0 ? 0 : (int)((double)this.AbsorbMax * 100.0 / this.AbsorbRatio));
        }

        public ArmorProperties copy() {
            return new ArmorProperties(this.Priority, this.AbsorbRatio, this.AbsorbMax);
        }
    }
}

