/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidUtil {
    private FluidUtil() {
    }

    public static boolean interactWithFluidHandler(@Nonnull aay player, @Nonnull ri hand, @Nonnull ajs world, @Nonnull co pos, @Nullable cv side) {
        IItemHandler playerInventory;
        IFluidHandler blockFluidHandler;
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        afj heldItem = player.b(hand);
        if (!heldItem.b() && (blockFluidHandler = FluidUtil.getFluidHandler(world, pos, side)) != null && (playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            FluidActionResult fluidActionResult = FluidUtil.tryFillContainerAndStow(heldItem, blockFluidHandler, playerInventory, Integer.MAX_VALUE, player);
            if (!fluidActionResult.isSuccess()) {
                fluidActionResult = FluidUtil.tryEmptyContainerAndStow(heldItem, blockFluidHandler, playerInventory, Integer.MAX_VALUE, player);
            }
            if (fluidActionResult.isSuccess()) {
                player.a(hand, fluidActionResult.getResult());
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @Nonnull
    public static FluidActionResult interactWithFluidHandler(@Nonnull afj stack, IFluidHandler fluidHandler, aay player) {
        if (stack.b() || fluidHandler == null || player == null) {
            return FluidActionResult.FAILURE;
        }
        InvWrapper playerInventory = new InvWrapper((rc)player.bs);
        FluidActionResult fillResult = FluidUtil.tryFillContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player);
        if (fillResult.isSuccess()) {
            return fillResult;
        }
        return FluidUtil.tryEmptyContainerAndStow(stack, fluidHandler, playerInventory, Integer.MAX_VALUE, player);
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull afj container, IFluidHandler fluidSource, int maxAmount, @Nullable aay player, boolean doFill) {
        FluidStack simulatedTransfer;
        afj containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, false)) != null) {
            if (doFill) {
                FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, true);
                if (player != null) {
                    nm soundevent = simulatedTransfer.getFluid().getFillSound(simulatedTransfer);
                    player.a(soundevent, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, true);
            }
            afj resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull afj container, IFluidHandler fluidDestination, int maxAmount, @Nullable aay player, boolean doDrain) {
        afj containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null) {
            if (doDrain) {
                FluidStack transfer = FluidUtil.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, true);
                if (transfer != null) {
                    if (player != null) {
                        nm soundevent = transfer.getFluid().getEmptySound(transfer);
                        player.a(soundevent, 1.0f, 1.0f);
                    }
                    afj resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            } else {
                FluidStack simulatedTransfer = FluidUtil.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, false);
                if (simulatedTransfer != null) {
                    containerFluidHandler.drain(simulatedTransfer, true);
                    afj resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryFillContainerAndStow(@Nonnull afj container, IFluidHandler fluidSource, IItemHandler inventory, int maxAmount, @Nullable aay player) {
        if (container.b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.bK.d) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.E() == 1) {
            FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
            if (filledReal.isSuccess()) {
                return filledReal;
            }
        } else {
            afj remainder;
            FluidActionResult filledSimulated = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, false);
            if (filledSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, filledSimulated.getResult(), true)).b() || player != null)) {
                FluidActionResult filledReal = FluidUtil.tryFillContainer(container, fluidSource, maxAmount, player, true);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, filledReal.getResult(), false);
                if (!remainder.b() && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                afj containerCopy = container.l();
                containerCopy.g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainerAndStow(@Nonnull afj container, IFluidHandler fluidDestination, IItemHandler inventory, int maxAmount, @Nullable aay player) {
        if (container.b()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.bK.d) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.E() == 1) {
            FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            afj remainder;
            FluidActionResult emptiedSimulated = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedSimulated.getResult(), true)).b() || player != null)) {
                FluidActionResult emptiedReal = FluidUtil.tryEmptyContainer(container, fluidDestination, maxAmount, player, true);
                remainder = ItemHandlerHelper.insertItemStacked(inventory, emptiedReal.getResult(), false);
                if (!remainder.b() && player != null) {
                    ItemHandlerHelper.giveItemToPlayer(player, remainder);
                }
                afj containerCopy = container.l();
                containerCopy.g(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, false);
        if (drainable != null && drainable.amount > 0) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return null;
    }

    @Nullable
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack resource, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(resource, false);
        if (drainable != null && drainable.amount > 0 && resource.isFluidEqual(drainable)) {
            return FluidUtil.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return null;
    }

    @Nullable
    private static FluidStack tryFluidTransfer_Internal(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack drainable, boolean doTransfer) {
        int fillableAmount = fluidDestination.fill(drainable, false);
        if (fillableAmount > 0) {
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(fillableAmount, true);
                if (drained != null) {
                    drained.amount = fluidDestination.fill(drained, true);
                    return drained;
                }
            } else {
                drainable.amount = fillableAmount;
                return drainable;
            }
        }
        return null;
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandler(@Nonnull afj itemStack) {
        if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        }
        return null;
    }

    @Nullable
    public static FluidStack getFluidContained(@Nonnull afj container) {
        IFluidHandlerItem fluidHandler;
        if (!container.b() && (fluidHandler = FluidUtil.getFluidHandler(container = ItemHandlerHelper.copyStackWithSize(container, 1))) != null) {
            return fluidHandler.drain(Integer.MAX_VALUE, false);
        }
        return null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(ajs world, co blockPos, @Nullable cv side) {
        atl state = world.o(blockPos);
        alu block = state.v();
        if (block.hasTileEntity(state)) {
            asc tileEntity = world.r(blockPos);
            if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            }
        } else {
            if (block instanceof IFluidBlock) {
                return new FluidBlockWrapper((IFluidBlock)block, world, blockPos);
            }
            if (block instanceof aoq) {
                return new BlockLiquidWrapper((aoq)block, world, blockPos);
            }
        }
        return null;
    }

    @Nonnull
    public static FluidActionResult tryPickUpFluid(@Nonnull afj emptyContainer, @Nullable aay playerIn, ajs worldIn, co pos, cv side) {
        IFluidHandler targetFluidHandler;
        if (emptyContainer.b() || worldIn == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        atl state = worldIn.o(pos);
        alu block = state.v();
        if ((block instanceof IFluidBlock || block instanceof aoq) && (targetFluidHandler = FluidUtil.getFluidHandler(worldIn, pos, side)) != null) {
            return FluidUtil.tryFillContainer(emptyContainer, targetFluidHandler, Integer.MAX_VALUE, playerIn, true);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryPlaceFluid(@Nullable aay player, ajs world, co pos, @Nonnull afj container, FluidStack resource) {
        afj containerCopy = ItemHandlerHelper.copyStackWithSize(container, 1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler(containerCopy);
        if (containerFluidHandler != null && FluidUtil.tryPlaceFluid(player, world, pos, containerFluidHandler, resource)) {
            return new FluidActionResult(containerFluidHandler.getContainer());
        }
        return FluidActionResult.FAILURE;
    }

    public static boolean tryPlaceFluid(@Nullable aay player, ajs world, co pos, IFluidHandler fluidSource, FluidStack resource) {
        if (world == null || resource == null || pos == null) {
            return false;
        }
        Fluid fluid = resource.getFluid();
        if (fluid == null || !fluid.canBePlacedInWorld()) {
            return false;
        }
        if (fluidSource.drain(resource, false) == null) {
            return false;
        }
        atl destBlockState = world.o(pos);
        azs destMaterial = destBlockState.a();
        boolean isDestNonSolid = !destMaterial.a();
        boolean isDestReplaceable = destBlockState.v().a((ajw)world, pos);
        if (!(world.d(pos) || isDestNonSolid || isDestReplaceable)) {
            return false;
        }
        if (world.s.l() && fluid.doesVaporize(resource)) {
            FluidStack result = fluidSource.drain(resource, true);
            if (result != null) {
                result.getFluid().vaporize(player, world, pos, result);
                return true;
            }
        } else {
            IFluidHandler handler = FluidUtil.getFluidBlockHandler(fluid, world, pos);
            FluidStack result = FluidUtil.tryFluidTransfer(handler, fluidSource, resource, true);
            if (result != null) {
                nm soundevent = resource.getFluid().getEmptySound(resource);
                world.a(player, pos, soundevent, no.e, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }

    private static IFluidHandler getFluidBlockHandler(Fluid fluid, ajs world, co pos) {
        alu block = fluid.getBlock();
        if (block instanceof IFluidBlock) {
            return new FluidBlockWrapper((IFluidBlock)block, world, pos);
        }
        if (block instanceof aoq) {
            return new BlockLiquidWrapper((aoq)block, world, pos);
        }
        return new BlockWrapper(block, world, pos);
    }

    public static void destroyBlockOnFluidPlacement(ajs world, co pos) {
        if (!world.E) {
            atl destBlockState = world.o(pos);
            azs destMaterial = destBlockState.a();
            boolean isDestNonSolid = !destMaterial.a();
            boolean isDestReplaceable = destBlockState.v().a((ajw)world, pos);
            if ((isDestNonSolid || isDestReplaceable) && !destMaterial.d()) {
                world.b(pos, true);
            }
        }
    }
}

