/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class VanillaDoubleChestItemHandler
extends WeakReference<ase>
implements IItemHandlerModifiable {
    public static final VanillaDoubleChestItemHandler NO_ADJACENT_CHESTS_INSTANCE = new VanillaDoubleChestItemHandler(null, null, false);
    private final boolean mainChestIsUpper;
    private final ase mainChest;
    private final int hashCode;

    public VanillaDoubleChestItemHandler(@Nullable ase mainChest, @Nullable ase other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    @Nullable
    public static VanillaDoubleChestItemHandler get(ase chest) {
        ajs world = chest.D();
        co pos = chest.w();
        if (world == null || pos == null || !world.e(pos)) {
            return null;
        }
        alu blockType = chest.x();
        cv[] horizontals = cv.o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            asc otherTE;
            cv enumfacing = horizontals[i];
            co blockpos = pos.a(enumfacing);
            alu block = world.o(blockpos).v();
            if (block != blockType || !((otherTE = world.r(blockpos)) instanceof ase)) continue;
            ase otherChest = (ase)otherTE;
            return new VanillaDoubleChestItemHandler(chest, otherChest, enumfacing != cv.e && enumfacing != cv.c);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    @Nullable
    public ase getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    @Nullable
    private ase getOtherChest() {
        ase tileEntityChest = (ase)this.get();
        return tileEntityChest != null && !tileEntityChest.y() ? tileEntityChest : null;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    @Nonnull
    public afj getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        ase chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.a(targetSlot) : afj.a;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull afj stack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        ase chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, stack);
        }
        if ((chest = this.getChest(!accessingUpperChest)) != null) {
            chest.x_();
        }
    }

    @Override
    @Nonnull
    public afj insertItem(int slot, @Nonnull afj stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        ase chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return stack;
        }
        int starting = stack.E();
        afj ret = chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate);
        if (ret.E() != starting && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.x_();
        }
        return ret;
    }

    @Override
    @Nonnull
    public afj extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        ase chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return afj.a;
        }
        afj ret = chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate);
        if (!ret.b() && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.x_();
        }
        return ret;
    }

    @Override
    public int getSlotLimit(int slot) {
        boolean accessingUpperChest = slot < 27;
        return this.getChest(accessingUpperChest).y_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanillaDoubleChestItemHandler that = (VanillaDoubleChestItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        ase otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)this.mainChest, (Object)that.mainChest) && Objects.equal((Object)otherChest, (Object)that.getOtherChest());
        }
        return Objects.equal((Object)this.mainChest, (Object)that.getOtherChest()) && Objects.equal((Object)otherChest, (Object)that.mainChest);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        ase tileEntityChest = (ase)this.get();
        return tileEntityChest == null || tileEntityChest.y();
    }
}

