/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiOverlayDebug;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.opengl.GL11;

public class GuiIngameForge
extends GuiIngame {
    private static final int WHITE = 0xFFFFFF;
    public static boolean renderVignette = true;
    public static boolean renderHelmet = true;
    public static boolean renderPortal = true;
    public static boolean renderHotbar = true;
    public static boolean renderCrosshairs = true;
    public static boolean renderBossHealth = true;
    public static boolean renderHealth = true;
    public static boolean renderArmor = true;
    public static boolean renderFood = true;
    public static boolean renderHealthMount = true;
    public static boolean renderAir = true;
    public static boolean renderExperiance = true;
    public static boolean renderJumpBar = true;
    public static boolean renderObjective = true;
    public static int left_height = 39;
    public static int right_height = 39;
    private FontRenderer fontrenderer = null;
    private RenderGameOverlayEvent eventParent;
    private GuiOverlayDebugForge debugOverlay;

    public GuiIngameForge(Minecraft mc) {
        super(mc);
        this.debugOverlay = new GuiOverlayDebugForge(mc);
    }

    public void func_175180_a(float partialTicks) {
        ScoreObjective scoreobjective1;
        int slot;
        this.field_194811_H = this.field_73839_d.field_195558_d.func_198107_o();
        this.field_194812_I = this.field_73839_d.field_195558_d.func_198087_p();
        this.eventParent = new RenderGameOverlayEvent(partialTicks, this.field_73839_d.field_195558_d);
        renderHealthMount = this.field_73839_d.field_71439_g.func_184187_bx() instanceof EntityLivingBase;
        renderFood = this.field_73839_d.field_71439_g.func_184187_bx() == null;
        renderJumpBar = this.field_73839_d.field_71439_g.func_110317_t();
        right_height = 39;
        left_height = 39;
        if (this.pre(RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.fontrenderer = this.field_73839_d.field_71466_p;
        GlStateManager.func_179147_l();
        if (renderVignette && Minecraft.func_71375_t()) {
            this.func_212303_b(this.field_73839_d.func_175606_aa());
        } else {
            GlStateManager.func_179126_j();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        if (renderHelmet) {
            this.renderHelmet(partialTicks);
        }
        if (renderPortal && !this.field_73839_d.field_71439_g.func_70644_a(MobEffects.field_76431_k)) {
            this.func_194805_e(partialTicks);
        }
        if (renderHotbar) {
            this.func_194806_b(partialTicks);
        }
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73735_i = -90.0f;
            this.field_73842_c.setSeed(this.field_73837_f * 312871);
            if (renderCrosshairs) {
                this.func_194798_c(partialTicks);
            }
            if (renderBossHealth) {
                this.renderBossHealth();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.field_73839_d.field_71442_b.func_78755_b() && this.field_73839_d.func_175606_aa() instanceof EntityPlayer) {
                if (renderHealth) {
                    this.renderHealth(this.field_194811_H, this.field_194812_I);
                }
                if (renderArmor) {
                    this.renderArmor(this.field_194811_H, this.field_194812_I);
                }
                if (renderFood) {
                    this.renderFood(this.field_194811_H, this.field_194812_I);
                }
                if (renderHealthMount) {
                    this.renderHealthMount(this.field_194811_H, this.field_194812_I);
                }
                if (renderAir) {
                    this.renderAir(this.field_194811_H, this.field_194812_I);
                }
            }
            if (renderJumpBar) {
                this.func_194803_a(this.field_194811_H / 2 - 91);
            } else if (renderExperiance) {
                this.renderExperience(this.field_194811_H / 2 - 91);
            }
            if (this.field_73839_d.field_71474_y.field_92117_D && this.field_73839_d.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
                this.func_194801_c();
            } else if (this.field_73839_d.field_71439_g.func_175149_v()) {
                this.field_175197_u.func_195623_a();
            }
        }
        this.renderSleepFade(this.field_194811_H, this.field_194812_I);
        this.renderHUDText(this.field_194811_H, this.field_194812_I);
        this.renderFPSGraph();
        this.func_194809_b();
        if (!this.field_73839_d.field_71474_y.field_74319_N) {
            this.renderRecordOverlay(this.field_194811_H, this.field_194812_I, partialTicks);
            this.renderSubtitles();
            this.renderTitle(this.field_194811_H, this.field_194812_I, partialTicks);
        }
        Scoreboard scoreboard = this.field_73839_d.field_71441_e.func_96441_U();
        ScoreObjective objective = null;
        ScorePlayerTeam scoreplayerteam = scoreboard.func_96509_i(this.field_73839_d.field_71439_g.func_195047_I_());
        if (scoreplayerteam != null && (slot = scoreplayerteam.func_178775_l().func_175746_b()) >= 0) {
            objective = scoreboard.func_96539_a(3 + slot);
        }
        ScoreObjective scoreObjective = scoreobjective1 = objective != null ? objective : scoreboard.func_96539_a(1);
        if (renderObjective && scoreobjective1 != null) {
            this.func_194802_a(scoreobjective1);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179118_c();
        this.renderChat(this.field_194811_H, this.field_194812_I);
        this.renderPlayerList(this.field_194811_H, this.field_194812_I);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        this.post(RenderGameOverlayEvent.ElementType.ALL);
    }

    protected void func_194798_c(float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.CROSSHAIRS)) {
            return;
        }
        this.bind(Gui.field_110324_m);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        super.func_194798_c(partialTicks);
        this.post(RenderGameOverlayEvent.ElementType.CROSSHAIRS);
    }

    protected void func_194809_b() {
        if (this.pre(RenderGameOverlayEvent.ElementType.POTION_ICONS)) {
            return;
        }
        super.func_194809_b();
        this.post(RenderGameOverlayEvent.ElementType.POTION_ICONS);
    }

    protected void renderSubtitles() {
        if (this.pre(RenderGameOverlayEvent.ElementType.SUBTITLES)) {
            return;
        }
        this.field_184049_t.func_195620_a();
        this.post(RenderGameOverlayEvent.ElementType.SUBTITLES);
    }

    protected void renderBossHealth() {
        if (this.pre(RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return;
        }
        this.bind(Gui.field_110324_m);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.field_73839_d.field_71424_I.func_76320_a("bossHealth");
        GlStateManager.func_179147_l();
        this.field_184050_w.func_184051_a();
        GlStateManager.func_179084_k();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.BOSSHEALTH);
    }

    protected void func_212303_b(Entity entity) {
        if (this.pre(RenderGameOverlayEvent.ElementType.VIGNETTE)) {
            GlStateManager.func_179126_j();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            return;
        }
        super.func_212303_b(entity);
        this.post(RenderGameOverlayEvent.ElementType.VIGNETTE);
    }

    private void renderHelmet(float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HELMET)) {
            return;
        }
        ItemStack itemstack = this.field_73839_d.field_71439_g.field_71071_by.func_70440_f(3);
        if (this.field_73839_d.field_71474_y.field_74320_O == 0 && !itemstack.func_190926_b()) {
            Item item = itemstack.func_77973_b();
            if (item == Blocks.field_196625_cS.func_199767_j()) {
                this.func_194808_p();
            } else {
                item.renderHelmetOverlay(itemstack, (EntityPlayer)this.field_73839_d.field_71439_g, this.field_194811_H, this.field_194812_I, partialTicks);
            }
        }
        this.post(RenderGameOverlayEvent.ElementType.HELMET);
    }

    protected void renderArmor(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.ARMOR)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("armor");
        GlStateManager.func_179147_l();
        int left = width / 2 - 91;
        int top = height - left_height;
        int level = this.field_73839_d.field_71439_g.func_70658_aO();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                this.func_73729_b(left, top, 34, 9, 9, 9);
            } else if (i == level) {
                this.func_73729_b(left, top, 25, 9, 9, 9);
            } else if (i > level) {
                this.func_73729_b(left, top, 16, 9, 9, 9);
            }
            left += 8;
        }
        left_height += 10;
        GlStateManager.func_179084_k();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.ARMOR);
    }

    protected void func_194805_e(float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.PORTAL)) {
            return;
        }
        float f1 = this.field_73839_d.field_71439_g.field_71080_cy + (this.field_73839_d.field_71439_g.field_71086_bY - this.field_73839_d.field_71439_g.field_71080_cy) * partialTicks;
        if (f1 > 0.0f) {
            super.func_194805_e(f1);
        }
        this.post(RenderGameOverlayEvent.ElementType.PORTAL);
    }

    protected void func_194806_b(float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HOTBAR)) {
            return;
        }
        if (this.field_73839_d.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
            this.field_175197_u.func_195622_a(partialTicks);
        } else {
            super.func_194806_b(partialTicks);
        }
        this.post(RenderGameOverlayEvent.ElementType.HOTBAR);
    }

    public void func_175188_a(ITextComponent component, boolean animateColor) {
        this.func_110326_a(component.func_150254_d(), animateColor);
    }

    protected void renderAir(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.AIR)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("air");
        EntityPlayer player = (EntityPlayer)this.field_73839_d.func_175606_aa();
        GlStateManager.func_179147_l();
        int left = width / 2 + 91;
        int top = height - right_height;
        int air = player.func_70086_ai();
        if (player.func_208600_a(FluidTags.field_206959_a) || air < 300) {
            int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            right_height += 10;
        }
        GlStateManager.func_179084_k();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.AIR);
    }

    public void renderHealth(int width, int height) {
        boolean highlight;
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTH)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("health");
        GlStateManager.func_179147_l();
        EntityPlayer player = (EntityPlayer)this.field_73839_d.func_175606_aa();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = this.field_175191_F > (long)this.field_73837_f && (this.field_175191_F - (long)this.field_73837_f) / 3L % 2L == 1L;
        if (health < this.field_175194_C && player.field_70172_ad > 0) {
            this.field_175190_E = Util.func_211177_b();
            this.field_175191_F = this.field_73837_f + 20;
        } else if (health > this.field_175194_C && player.field_70172_ad > 0) {
            this.field_175190_E = Util.func_211177_b();
            this.field_175191_F = this.field_73837_f + 10;
        }
        if (Util.func_211177_b() - this.field_175190_E > 1000L) {
            this.field_175194_C = health;
            this.field_175189_D = health;
            this.field_175190_E = Util.func_211177_b();
        }
        this.field_175194_C = health;
        int healthLast = this.field_175189_D;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.field_73842_c.setSeed(this.field_73837_f * 312871);
        int left = width / 2 - 91;
        int top = height - left_height;
        left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(MobEffects.field_76428_l)) {
            regen = this.field_73837_f % 25;
        }
        int TOP = 9 * (this.field_73839_d.field_71441_e.func_72912_H().func_76093_s() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            MARGIN += 36;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.field_73842_c.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.func_73729_b(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.func_73729_b(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.func_73729_b(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.func_73729_b(x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.func_73729_b(x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.func_73729_b(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.func_73729_b(x, y, MARGIN + 45, TOP, 9, 9);
        }
        GlStateManager.func_179084_k();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.HEALTH);
    }

    public void renderFood(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.FOOD)) {
            return;
        }
        this.field_73839_d.field_71424_I.func_76320_a("food");
        EntityPlayer player = (EntityPlayer)this.field_73839_d.func_175606_aa();
        GlStateManager.func_179147_l();
        int left = width / 2 + 91;
        int top = height - right_height;
        right_height += 10;
        boolean unused = false;
        FoodStats stats = this.field_73839_d.field_71439_g.func_71024_bL();
        int level = stats.func_75116_a();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 0;
            if (this.field_73839_d.field_71439_g.func_70644_a(MobEffects.field_76438_s)) {
                icon += 36;
                background = 13;
            }
            if (unused) {
                background = 1;
            }
            if (player.func_71024_bL().func_75115_e() <= 0.0f && this.field_73837_f % (level * 3 + 1) == 0) {
                y = top + (this.field_73842_c.nextInt(3) - 1);
            }
            this.func_73729_b(x, y, 16 + background * 9, 27, 9, 9);
            if (idx < level) {
                this.func_73729_b(x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != level) continue;
            this.func_73729_b(x, y, icon + 45, 27, 9, 9);
        }
        GlStateManager.func_179084_k();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.FOOD);
    }

    protected void renderSleepFade(int width, int height) {
        if (this.field_73839_d.field_71439_g.func_71060_bI() > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("sleep");
            GlStateManager.func_179097_i();
            GlStateManager.func_179118_c();
            int sleepTime = this.field_73839_d.field_71439_g.func_71060_bI();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            GuiIngameForge.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)color);
            GlStateManager.func_179141_d();
            GlStateManager.func_179126_j();
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderExperience(int x) {
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        if (this.field_73839_d.field_71442_b.func_78763_f()) {
            super.func_194804_b(x);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.EXPERIENCE);
    }

    public void func_194803_a(int x) {
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.JUMPBAR)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        super.func_194803_a(x);
        GlStateManager.func_179147_l();
        this.field_73839_d.field_71424_I.func_76319_b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.JUMPBAR);
    }

    protected void renderHUDText(int width, int height) {
        RenderGameOverlayEvent.Text event;
        this.field_73839_d.field_71424_I.func_76320_a("forgeHudText");
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        ArrayList<String> listL = new ArrayList<String>();
        ArrayList<String> listR = new ArrayList<String>();
        if (this.field_73839_d.func_71355_q()) {
            long time = this.field_73839_d.field_71441_e.func_82737_E();
            if (time >= 120500L) {
                listR.add(I18n.func_135052_a((String)"demo.demoExpired", (Object[])new Object[0]));
            } else {
                listR.add(I18n.func_135052_a((String)"demo.remainingTime", (Object[])new Object[]{StringUtils.func_76337_a((int)((int)(120500L - time)))}));
            }
        }
        if (this.field_73839_d.field_71474_y.field_74330_P && !this.pre(RenderGameOverlayEvent.ElementType.DEBUG)) {
            this.debugOverlay.update();
            listL.addAll(this.debugOverlay.getLeft());
            listR.addAll(this.debugOverlay.getRight());
            this.post(RenderGameOverlayEvent.ElementType.DEBUG);
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Text(this.eventParent, listL, listR)))) {
            int top = 2;
            for (String msg : listL) {
                if (msg == null) continue;
                GuiIngameForge.func_73734_a((int)1, (int)(top - 1), (int)(2 + this.fontrenderer.func_78256_a(msg) + 1), (int)(top + this.fontrenderer.field_78288_b - 1), (int)-1873784752);
                this.fontrenderer.func_175063_a(msg, 2.0f, (float)top, 0xE0E0E0);
                top += this.fontrenderer.field_78288_b;
            }
            top = 2;
            for (String msg : listR) {
                if (msg == null) continue;
                int w = this.fontrenderer.func_78256_a(msg);
                int left = width - 2 - w;
                GuiIngameForge.func_73734_a((int)(left - 1), (int)(top - 1), (int)(left + w + 1), (int)(top + this.fontrenderer.field_78288_b - 1), (int)-1873784752);
                this.fontrenderer.func_175063_a(msg, (float)left, (float)top, 0xE0E0E0);
                top += this.fontrenderer.field_78288_b;
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.TEXT);
    }

    protected void renderFPSGraph() {
        if (this.field_73839_d.field_71474_y.field_74330_P && this.field_73839_d.field_71474_y.field_181657_aC && !this.pre(RenderGameOverlayEvent.ElementType.FPS_GRAPH)) {
            this.debugOverlay.func_181554_e();
            this.post(RenderGameOverlayEvent.ElementType.FPS_GRAPH);
        }
    }

    protected void renderRecordOverlay(int width, int height, float partialTicks) {
        if (this.field_73845_h > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("overlayMessage");
            float hue = (float)this.field_73845_h - partialTicks;
            int opacity = (int)(hue * 256.0f / 20.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(width / 2), (float)(height - 68), (float)0.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int color = this.field_73844_j ? MathHelper.func_181758_c((float)(hue / 50.0f), (float)0.7f, (float)0.6f) & 0xFFFFFF : 0xFFFFFF;
                this.fontrenderer.func_175063_a(this.field_73838_g, (float)(-this.fontrenderer.func_78256_a(this.field_73838_g) / 2), -4.0f, color | opacity << 24);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderTitle(int width, int height, float partialTicks) {
        if (this.field_175195_w > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("titleAndSubtitle");
            float age = (float)this.field_175195_w - partialTicks;
            int opacity = 255;
            if (this.field_175195_w > this.field_175193_B + this.field_175192_A) {
                float f3 = (float)(this.field_175199_z + this.field_175192_A + this.field_175193_B) - age;
                opacity = (int)(f3 * 255.0f / (float)this.field_175199_z);
            }
            if (this.field_175195_w <= this.field_175193_B) {
                opacity = (int)(age * 255.0f / (float)this.field_175193_B);
            }
            if ((opacity = MathHelper.func_76125_a((int)opacity, (int)0, (int)255)) > 8) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)0.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
                int l = opacity << 24 & 0xFF000000;
                this.func_175179_f().func_175063_a(this.field_175201_x, (float)(-this.func_175179_f().func_78256_a(this.field_175201_x) / 2), -10.0f, 0xFFFFFF | l);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.func_175179_f().func_175063_a(this.field_175200_y, (float)(-this.func_175179_f().func_78256_a(this.field_175200_y) / 2), 5.0f, 0xFFFFFF | l);
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    protected void renderChat(int width, int height) {
        this.field_73839_d.field_71424_I.func_76320_a("chat");
        RenderGameOverlayEvent.Chat event = new RenderGameOverlayEvent.Chat(this.eventParent, 0, height - 48);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)event.getPosX(), (float)event.getPosY(), (float)0.0f);
        this.field_73840_e.func_146230_a(this.field_73837_f);
        GlStateManager.func_179121_F();
        this.post(RenderGameOverlayEvent.ElementType.CHAT);
        this.field_73839_d.field_71424_I.func_76319_b();
    }

    protected void renderPlayerList(int width, int height) {
        ScoreObjective scoreobjective = this.field_73839_d.field_71441_e.func_96441_U().func_96539_a(0);
        NetHandlerPlayClient handler = this.field_73839_d.field_71439_g.field_71174_a;
        if (this.field_73839_d.field_71474_y.field_74321_H.func_151470_d() && (!this.field_73839_d.func_71387_A() || handler.func_175106_d().size() > 1 || scoreobjective != null)) {
            this.field_175196_v.func_175246_a(true);
            if (this.pre(RenderGameOverlayEvent.ElementType.PLAYER_LIST)) {
                return;
            }
            this.field_175196_v.func_175249_a(width, this.field_73839_d.field_71441_e.func_96441_U(), scoreobjective);
            this.post(RenderGameOverlayEvent.ElementType.PLAYER_LIST);
        } else {
            this.field_175196_v.func_175246_a(false);
        }
    }

    protected void renderHealthMount(int width, int height) {
        EntityPlayer player = (EntityPlayer)this.field_73839_d.func_175606_aa();
        Entity tmp = player.func_184187_bx();
        if (!(tmp instanceof EntityLivingBase)) {
            return;
        }
        this.bind(field_110324_m);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
            return;
        }
        boolean unused = false;
        int left_align = width / 2 + 91;
        this.field_73839_d.field_71424_I.func_76318_c("mountHealth");
        GlStateManager.func_179147_l();
        EntityLivingBase mount = (EntityLivingBase)tmp;
        int health = (int)Math.ceil(mount.func_110143_aJ());
        float healthMax = mount.func_110138_aP();
        int hearts = (int)(healthMax + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        int MARGIN = 52;
        int BACKGROUND = 52 + (unused ? 1 : 0);
        int HALF = 97;
        int FULL = 88;
        int heart = 0;
        while (hearts > 0) {
            int top = height - right_height;
            int rowCount = Math.min(hearts, 10);
            hearts -= rowCount;
            for (int i = 0; i < rowCount; ++i) {
                int x = left_align - i * 8 - 9;
                this.func_73729_b(x, top, BACKGROUND, 9, 9, 9);
                if (i * 2 + 1 + heart < health) {
                    this.func_73729_b(x, top, 88, 9, 9, 9);
                    continue;
                }
                if (i * 2 + 1 + heart != health) continue;
                this.func_73729_b(x, top, 97, 9, 9, 9);
            }
            right_height += 10;
            heart += 20;
        }
        GlStateManager.func_179084_k();
        this.post(RenderGameOverlayEvent.ElementType.HEALTHMOUNT);
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(this.eventParent, type));
    }

    private void bind(ResourceLocation res) {
        this.field_73839_d.func_110434_K().func_110577_a(res);
    }

    private class GuiOverlayDebugForge
    extends GuiOverlayDebug {
        private Minecraft mc;

        private GuiOverlayDebugForge(Minecraft mc) {
            super(mc);
            this.mc = mc;
        }

        public void update() {
            Entity entity = this.mc.func_175606_aa();
            this.field_211537_g = entity.func_174822_a(20.0, 0.0f, RayTraceFluidMode.NEVER);
            this.field_211538_h = entity.func_174822_a(20.0, 0.0f, RayTraceFluidMode.ALWAYS);
        }

        protected void func_180798_a() {
        }

        protected void func_194819_c() {
        }

        private List<String> getLeft() {
            List ret = this.func_209011_c();
            ret.add("");
            ret.add("Debug: Pie [shift]: " + (this.mc.field_71474_y.field_74329_Q ? "visible" : "hidden") + " FPS [alt]: " + (this.mc.field_71474_y.field_181657_aC ? "visible" : "hidden"));
            ret.add("For help: press F3 + Q");
            return ret;
        }

        private List<String> getRight() {
            return this.func_175238_c();
        }
    }
}

