/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public abstract class SimpleModelFontRenderer
extends FontRenderer {
    private float r;
    private float g;
    private float b;
    private float a;
    private final Matrix4f matrix;
    private ImmutableList.Builder<BakedQuad> builder = ImmutableList.builder();
    private final VertexFormat format;
    private final Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
    private final EnumFacing orientation;
    private boolean fillBlanks = false;
    private TextureAtlasSprite sprite;
    private final Vector4f vec = new Vector4f();

    public SimpleModelFontRenderer(GameSettings settings, ResourceLocation font, TextureManager manager, boolean isUnicode, Matrix4f matrix, VertexFormat format) {
        super(manager, null);
        this.matrix = new Matrix4f(matrix);
        Matrix3f nm = new Matrix3f();
        this.matrix.getRotationScale(nm);
        nm.invert();
        nm.transpose();
        this.format = format;
        nm.transform((Tuple3f)this.normal);
        this.normal.normalize();
        this.orientation = EnumFacing.func_176737_a((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public void setFillBlanks(boolean fillBlanks) {
        this.fillBlanks = fillBlanks;
    }

    private void addVertex(UnpackedBakedQuad.Builder quadBuilder, float x, float y, float u, float v) {
        this.vec.x = x;
        this.vec.y = y;
        this.vec.z = 0.0f;
        this.vec.w = 1.0f;
        this.matrix.transform((Tuple4f)this.vec);
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    quadBuilder.put(e, this.vec.x, this.vec.y, this.vec.z, this.vec.w);
                    continue block6;
                }
                case UV: {
                    quadBuilder.put(e, this.sprite.func_94214_a((double)(u * 16.0f)), this.sprite.func_94207_b((double)(v * 16.0f)), 0.0f, 1.0f);
                    continue block6;
                }
                case COLOR: {
                    quadBuilder.put(e, this.r, this.g, this.b, this.a);
                    continue block6;
                }
                case NORMAL: {
                    quadBuilder.put(e, 0.0f, 0.0f, 1.0f, 1.0f);
                    continue block6;
                }
                default: {
                    quadBuilder.put(e, new float[0]);
                }
            }
        }
    }

    public ImmutableList<BakedQuad> build() {
        ImmutableList ret = this.builder.build();
        this.builder = ImmutableList.builder();
        return ret;
    }
}

