/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.common.ForgeMod;

public class ForgeBlockModelRenderer
extends BlockModelRenderer {
    private final ThreadLocal<VertexLighterFlat> lighterFlat;
    private final ThreadLocal<VertexLighterSmoothAo> lighterSmooth;
    private final ThreadLocal<VertexBufferConsumer> wrFlat = new ThreadLocal();
    private final ThreadLocal<VertexBufferConsumer> wrSmooth = new ThreadLocal();
    private final ThreadLocal<BufferBuilder> lastRendererFlat = new ThreadLocal();
    private final ThreadLocal<BufferBuilder> lastRendererSmooth = new ThreadLocal();

    public ForgeBlockModelRenderer(BlockColors colors) {
        super(colors);
        this.lighterFlat = ThreadLocal.withInitial(() -> new VertexLighterFlat(colors));
        this.lighterSmooth = ThreadLocal.withInitial(() -> new VertexLighterSmoothAo(colors));
    }

    public boolean func_199325_c(IWorldReader world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, Random rand, long seed) {
        if (ForgeMod.forgeLightPipelineEnabled) {
            if (buffer != this.lastRendererFlat.get()) {
                this.lastRendererFlat.set(buffer);
                VertexBufferConsumer newCons = new VertexBufferConsumer(buffer);
                this.wrFlat.set(newCons);
                this.lighterFlat.get().setParent(newCons);
            }
            this.wrFlat.get().setOffset(pos);
            return ForgeBlockModelRenderer.render(this.lighterFlat.get(), world, model, state, pos, buffer, checkSides, rand, seed);
        }
        return super.func_199325_c(world, model, state, pos, buffer, checkSides, rand, seed);
    }

    public boolean func_199326_b(IWorldReader world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, Random rand, long seed) {
        if (ForgeMod.forgeLightPipelineEnabled) {
            if (buffer != this.lastRendererSmooth.get()) {
                this.lastRendererSmooth.set(buffer);
                VertexBufferConsumer newCons = new VertexBufferConsumer(buffer);
                this.wrSmooth.set(newCons);
                this.lighterSmooth.get().setParent(newCons);
            }
            this.wrSmooth.get().setOffset(pos);
            return ForgeBlockModelRenderer.render(this.lighterSmooth.get(), world, model, state, pos, buffer, checkSides, rand, seed);
        }
        return super.func_199326_b(world, model, state, pos, buffer, checkSides, rand, seed);
    }

    public static boolean render(VertexLighterFlat lighter, IWorldReader world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder wr, boolean checkSides, Random rand, long seed) {
        lighter.setWorld(world);
        lighter.setState(state);
        lighter.setBlockPos(pos);
        boolean empty = true;
        rand.setSeed(seed);
        List quads = model.func_200117_a(state, null, rand);
        if (!quads.isEmpty()) {
            lighter.updateBlockInfo();
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)lighter);
            }
        }
        for (EnumFacing side : EnumFacing.values()) {
            rand.setSeed(seed);
            quads = model.func_200117_a(state, side, rand);
            if (quads.isEmpty() || checkSides && !Block.func_176225_a((IBlockState)state, (IBlockReader)world, (BlockPos)pos, (EnumFacing)side)) continue;
            if (empty) {
                lighter.updateBlockInfo();
            }
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe((IVertexConsumer)lighter);
            }
        }
        lighter.resetBlockInfo();
        return !empty;
    }
}

