/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.registries.ClearableRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DimensionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker DIMMGR = MarkerManager.getMarker((String)"DIMS");
    private static final ClearableRegistry<DimensionType> REGISTRY = new ClearableRegistry(new ResourceLocation("dimension_type"));
    private static final Int2ObjectMap<Data> dimensions = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final IntSet unloadQueue = IntSets.synchronize((IntSet)new IntLinkedOpenHashSet());
    private static final ConcurrentMap<World, World> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static final Multiset<Integer> leakedWorlds = HashMultiset.create();
    private static final Map<ResourceLocation, SavedEntry> savedEntries = new HashMap<ResourceLocation, SavedEntry>();

    public static DimensionType registerDimension(ResourceLocation name, ModDimension type, PacketBuffer data) {
        Validate.notNull((Object)name, (String)"Can not register a dimesnion with null name", (Object[])new Object[0]);
        Validate.isTrue((!REGISTRY.func_212607_c(name) ? 1 : 0) != 0, (String)("Dimension: " + name + " Already registered"), (Object[])new Object[0]);
        Validate.notNull((Object)type, (String)"Can not register a null dimension type", (Object[])new Object[0]);
        int id = REGISTRY.getNextId();
        SavedEntry old = savedEntries.get(name);
        if (old != null) {
            id = old.getId();
            if (!type.getRegistryName().equals((Object)old.getType())) {
                LOGGER.info(DIMMGR, "Changing ModDimension for '{}' from '{}' to '{}'", (Object)name.toString(), (Object)(old.getType() == null ? null : old.getType().toString()), (Object)type.getRegistryName().toString());
            }
            savedEntries.remove(name);
        }
        DimensionType instance = new DimensionType(id, "", name.func_110624_b() + "/" + name.func_110623_a(), type.getFactory(), type, data);
        REGISTRY.func_177775_a(id, name, instance);
        LOGGER.info(DIMMGR, "Registered dimension {} of type {} and id {}", (Object)name.toString(), (Object)type.getRegistryName().toString(), (Object)id);
        return instance;
    }

    public static boolean keepLoaded(DimensionType dim, boolean value) {
        Validate.notNull((Object)dim, (String)"Dimension type must not be null", (Object[])new Object[0]);
        Data data = DimensionManager.getData(dim);
        boolean ret = data.keepLoaded;
        data.keepLoaded = value;
        return ret;
    }

    public static boolean keepLoaded(DimensionType dim) {
        Validate.notNull((Object)dim, (String)"Dimension type must not be null", (Object[])new Object[0]);
        Data data = (Data)dimensions.get(dim.func_186068_a());
        return data == null ? false : data.keepLoaded;
    }

    @Nullable
    public static WorldServer getWorld(MinecraftServer server, DimensionType dim, boolean resetUnloadDelay, boolean forceLoad) {
        WorldServer ret;
        Validate.notNull((Object)server, (String)"Must provide server when creating world", (Object[])new Object[0]);
        Validate.notNull((Object)dim, (String)"Dimension type must not be null", (Object[])new Object[0]);
        if (StartupQuery.pendingQuery()) {
            return null;
        }
        if (resetUnloadDelay && unloadQueue.contains(dim.func_186068_a())) {
            DimensionManager.getData((DimensionType)dim).ticksWaited = 0;
        }
        if ((ret = (WorldServer)server.forgeGetWorldMap().get(dim)) == null && forceLoad) {
            ret = DimensionManager.initWorld(server, dim);
        }
        return ret;
    }

    public static void unregisterDimension(int id) {
        Validate.isTrue((boolean)dimensions.containsKey(id), (String)String.format("Failed to unregister dimension for id %d; No provider registered", id), (Object[])new Object[0]);
        dimensions.remove(id);
    }

    public static DimensionType registerDimensionInternal(int id, ResourceLocation name, ModDimension type, PacketBuffer data) {
        Validate.notNull((Object)name, (String)"Can not register a dimesnion with null name", (Object[])new Object[0]);
        Validate.notNull((Object)type, (String)"Can not register a null dimension type", (Object[])new Object[0]);
        Validate.isTrue((!REGISTRY.func_212607_c(name) ? 1 : 0) != 0, (String)("Dimension: " + name + " Already registered"), (Object[])new Object[0]);
        Validate.isTrue((REGISTRY.func_148754_a(id) == null ? 1 : 0) != 0, (String)("Dimension with id " + id + " already registered as name " + REGISTRY.func_177774_c(REGISTRY.func_148754_a(id))), (Object[])new Object[0]);
        DimensionType instance = new DimensionType(id, "", name.func_110624_b() + "/" + name.func_110623_a(), type.getFactory(), type, data);
        REGISTRY.func_177775_a(id, name, instance);
        LOGGER.info(DIMMGR, "Registered dimension {} of type {} and id {}", (Object)name.toString(), (Object)type.getRegistryName().toString(), (Object)id);
        return instance;
    }

    public static WorldServer initWorld(MinecraftServer server, DimensionType dim) {
        Validate.isTrue((dim != DimensionType.OVERWORLD ? 1 : 0) != 0, (String)"Can not hotload overworld. This must be loaded at all times by main Server.", (Object[])new Object[0]);
        Validate.notNull((Object)server, (String)"Must provide server when creating world", (Object[])new Object[0]);
        Validate.notNull((Object)dim, (String)"Must provide dimension when creating world", (Object[])new Object[0]);
        WorldServer overworld = DimensionManager.getWorld(server, DimensionType.OVERWORLD, false, false);
        Validate.notNull((Object)overworld, (String)"Cannot Hotload Dim: Overworld is not Loaded!", (Object[])new Object[0]);
        WorldServerMulti world = new WorldServerMulti(server, overworld.func_72860_G(), dim, overworld, server.field_71304_b).func_212251_i__();
        world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(server, (WorldServer)world));
        if (!server.func_71264_H()) {
            world.func_72912_H().func_76060_a(server.func_71265_f());
        }
        server.forgeGetWorldMap().put(dim, world);
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)world));
        server.func_147139_a(server.func_147135_j());
        return world;
    }

    private static boolean canUnloadWorld(WorldServer world) {
        return world.func_212412_ag().isEmpty() && world.field_73010_i.isEmpty() && !DimensionManager.getData((DimensionType)world.func_201675_m().func_186058_p()).keepLoaded;
    }

    public static void unloadWorld(WorldServer world) {
        if (world == null || !DimensionManager.canUnloadWorld(world)) {
            return;
        }
        int id = world.func_201675_m().func_186058_p().func_186068_a();
        if (unloadQueue.add(id)) {
            LOGGER.debug(DIMMGR, "Queueing dimension {} to unload", (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(MinecraftServer server, boolean checkLeaks) {
        IntIterator queueIterator = unloadQueue.iterator();
        while (queueIterator.hasNext()) {
            int id = queueIterator.nextInt();
            DimensionType dim = DimensionType.func_186069_a((int)id);
            if (dim == null) {
                LOGGER.warn(DIMMGR, "Dimension with unknown type '{}' added to unload queue, removing", (Object)id);
                queueIterator.remove();
                continue;
            }
            Data dimension = (Data)dimensions.computeIfAbsent(id, k -> new Data());
            if (dimension.ticksWaited < (Integer)ForgeConfig.SERVER.dimensionUnloadQueueDelay.get()) {
                ++dimension.ticksWaited;
                continue;
            }
            queueIterator.remove();
            WorldServer w = (WorldServer)server.forgeGetWorldMap().get(dim);
            dimension.ticksWaited = 0;
            if (w == null || !DimensionManager.canUnloadWorld(w)) {
                LOGGER.debug(DIMMGR, "Aborting unload for dimension {} as status changed", (Object)id);
                continue;
            }
            try {
                w.func_73044_a(true, null);
            }
            catch (Exception e) {
                LOGGER.error(DIMMGR, "Caught an exception while saving all chunks:", (Throwable)e);
            }
            finally {
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)w));
                w.close();
                server.forgeGetWorldMap().remove(dim);
            }
        }
        if (checkLeaks) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(server.forgeGetWorldMap().values());
            allWorlds.stream().map(System::identityHashCode).forEach(arg_0 -> leakedWorlds.add(arg_0));
            for (World w : allWorlds) {
                int hash = System.identityHashCode(w);
                int leakCount = leakedWorlds.count((Object)hash);
                if (leakCount == 5) {
                    LOGGER.debug(DIMMGR, "The world {} ({}) may have leaked: first encounter (5 occurrences).\n", (Object)Integer.toHexString(hash), (Object)w.func_72912_H().func_76065_j());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                LOGGER.debug(DIMMGR, "The world {} ({}) may have leaked: seen {} times.\n", (Object)Integer.toHexString(hash), (Object)w.func_72912_H().func_76065_j(), (Object)leakCount);
            }
        }
    }

    public static void writeRegistry(NBTTagCompound data) {
        data.func_74768_a("version", 1);
        ArrayList<SavedEntry> list = new ArrayList<SavedEntry>();
        Iterator<DimensionType> iterator = REGISTRY.iterator();
        while (iterator.hasNext()) {
            DimensionType type = iterator.next();
            list.add(new SavedEntry(type));
        }
        savedEntries.values().forEach(list::add);
        Collections.sort(list, (a, b) -> a.id - b.id);
        NBTTagList lst = new NBTTagList();
        list.forEach(e -> lst.add((INBTBase)((SavedEntry)e).write()));
        data.func_74782_a("entries", (INBTBase)lst);
    }

    public static void readRegistry(NBTTagCompound data) {
        int version = data.func_74762_e("version");
        if (version != 1) {
            throw new IllegalStateException("Attempted to load world with unknown Dimension data format: " + version);
        }
        LOGGER.debug(DIMMGR, "Reading Dimension Entries.");
        Map<ResourceLocation, DimensionType> vanilla = REGISTRY.func_201756_e().filter(DimensionType::isVanilla).collect(Collectors.toMap(REGISTRY::func_177774_c, v -> v));
        REGISTRY.clear();
        vanilla.forEach((key, value) -> {
            LOGGER.debug(DIMMGR, "Registering vanilla entry ID: {} Name: {} Value: {}", (Object)(value.func_186068_a() + 1), (Object)key.toString(), (Object)value.toString());
            REGISTRY.func_177775_a(value.func_186068_a() + 1, (ResourceLocation)key, (DimensionType)value);
        });
        savedEntries.clear();
        boolean error = false;
        NBTTagList list = data.func_150295_c("entries", 10);
        for (int x = 0; x < list.size(); ++x) {
            SavedEntry entry2 = new SavedEntry(list.func_150305_b(x));
            if (entry2.type == null) {
                DimensionType type = REGISTRY.func_212608_b(entry2.name);
                if (type == null) {
                    LOGGER.error(DIMMGR, "Vanilla entry '{}' id {} in save file not found in registry.", (Object)entry2.name.toString(), (Object)entry2.id);
                    error = true;
                    continue;
                }
                int id = REGISTRY.func_148757_b(type);
                if (id == entry2.id) continue;
                LOGGER.error(DIMMGR, "Vanilla entry '{}' id {} in save file has incorrect in {} in registry.", (Object)entry2.name.toString(), (Object)entry2.id, (Object)id);
                error = true;
                continue;
            }
            ModDimension mod = ForgeRegistries.MOD_DIMENSIONS.getValue(entry2.type);
            if (mod == null) {
                LOGGER.error(DIMMGR, "Modded dimension entry '{}' id {} in save file missing ModDimension.", (Object)entry2.name.toString(), (Object)entry2.id, (Object)entry2.type.toString());
                savedEntries.put(entry2.name, entry2);
                continue;
            }
            DimensionManager.registerDimensionInternal(entry2.id, entry2.name, mod, entry2.data == null ? null : new PacketBuffer(Unpooled.wrappedBuffer((byte[])entry2.data)));
        }
        MinecraftForge.EVENT_BUS.post((Event)new RegisterDimensionsEvent(savedEntries));
        if (!savedEntries.isEmpty()) {
            savedEntries.values().forEach(entry -> LOGGER.warn(DIMMGR, "Missing Dimension Name: '{}' Id: {} Type: '{}", (Object)entry.name.toString(), (Object)entry.id, (Object)entry.type.toString()));
        }
    }

    @Deprecated
    public static IRegistry<DimensionType> getRegistry() {
        return REGISTRY;
    }

    private static Data getData(DimensionType dim) {
        return (Data)dimensions.computeIfAbsent(dim.func_186068_a(), k -> new Data());
    }

    public static class SavedEntry {
        int id;
        ResourceLocation name;
        ResourceLocation type;
        byte[] data;

        public int getId() {
            return this.id;
        }

        public ResourceLocation getName() {
            return this.name;
        }

        @Nullable
        public ResourceLocation getType() {
            return this.type;
        }

        @Nullable
        public byte[] getData() {
            return this.data;
        }

        private SavedEntry(NBTTagCompound data) {
            this.id = data.func_74762_e("id");
            this.name = new ResourceLocation(data.func_74779_i("name"));
            this.type = data.func_150297_b("type", 8) ? new ResourceLocation(data.func_74779_i("type")) : null;
            this.data = data.func_150297_b("data", 7) ? data.func_74770_j("data") : null;
        }

        private SavedEntry(DimensionType data) {
            this.id = REGISTRY.func_148757_b(data);
            this.name = REGISTRY.func_177774_c(data);
            if (data.getModType() != null) {
                this.type = data.getModType().getRegistryName();
            }
            if (data.getData() != null) {
                this.data = data.getData().array();
            }
        }

        private NBTTagCompound write() {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74768_a("id", this.id);
            ret.func_74778_a("name", this.name.toString());
            if (this.type != null) {
                ret.func_74778_a("type", this.type.toString());
            }
            if (this.data != null) {
                ret.func_74773_a("data", this.data);
            }
            return ret;
        }
    }

    private static class Data {
        int ticksWaited = 0;
        boolean keepLoaded = false;

        private Data() {
        }
    }
}

