/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ForgeMessage {
    private static final Logger LOGGER = LogManager.getLogger();

    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class DimensionRegisterMessage
    extends ForgeMessage {
        int id;
        ResourceLocation name;
        ModDimension dim;
        @Nullable
        PacketBuffer data;

        public DimensionRegisterMessage() {
        }

        public DimensionRegisterMessage(int id, ResourceLocation name, ModDimension dim, @Nullable PacketBuffer data) {
            this.id = id;
            this.dim = dim;
            this.data = data;
        }

        @Override
        void toBytes(ByteBuf buff) {
            PacketBuffer output = new PacketBuffer(buff);
            output.writeInt(this.id);
            output.func_192572_a(this.name);
            output.func_192572_a(this.dim.getRegistryName());
            if (this.data == null) {
                output.writeShort(0);
            } else {
                ByteBuf dup = this.data.duplicate();
                output.writeShort(dup.readableBytes());
                output.writeBytes(dup);
            }
        }

        @Override
        void fromBytes(ByteBuf buff) {
            PacketBuffer input = new PacketBuffer(buff);
            this.id = input.readInt();
            this.name = input.func_192575_l();
            this.dim = ForgeRegistries.MOD_DIMENSIONS.getValue(input.func_192575_l());
            short len = input.readShort();
            if (len != 0) {
                this.data = new PacketBuffer(Unpooled.buffer());
                input.readBytes((ByteBuf)this.data, (int)len);
            }
        }
    }
}

